/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import ghidra.framework.options.SaveState;
import java.util.List;
import java.util.function.BiConsumer;
import org.jdom.Element;

public abstract class MultiProviderSaveBehavior<P extends SaveableProvider> {
    private static final String KEY_CONNECTED_PROVIDER = "connectedProvider";
    private static final String KEY_DISCONNECTED_COUNT = "disconnectedCount";
    private static final String PREFIX_DISCONNECTED_PROVIDER = "disconnectedProvider";

    protected abstract P getConnectedProvider();

    protected abstract List<P> getDisconnectedProviders();

    protected abstract P createDisconnectedProvider();

    protected abstract void removeDisconnectedProvider(P var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(SaveState saveState, BiConsumer<? super P, ? super SaveState> writer) {
        List<P> disconnected;
        List<P> disconnectedProviders;
        P cp = this.getConnectedProvider();
        SaveState cpState = new SaveState();
        writer.accept(cp, (SaveState)cpState);
        saveState.putXmlElement(KEY_CONNECTED_PROVIDER, cpState.saveToXml());
        List<P> list = disconnectedProviders = this.getDisconnectedProviders();
        synchronized (list) {
            disconnected = List.copyOf(disconnectedProviders);
        }
        saveState.putInt(KEY_DISCONNECTED_COUNT, disconnected.size());
        for (int i = 0; i < disconnected.size(); ++i) {
            SaveableProvider dp = (SaveableProvider)disconnected.get(i);
            String stateName = PREFIX_DISCONNECTED_PROVIDER + i;
            SaveState dpState = new SaveState();
            writer.accept(dp, (SaveState)dpState);
            saveState.putXmlElement(stateName, dpState.saveToXml());
        }
    }

    protected void doRead(SaveState saveState, BiConsumer<? super P, ? super SaveState> reader, boolean matchCount) {
        Element cpElement = saveState.getXmlElement(KEY_CONNECTED_PROVIDER);
        if (cpElement != null) {
            P cp = this.getConnectedProvider();
            SaveState cpState = new SaveState(cpElement);
            reader.accept(cp, (SaveState)cpState);
        }
        int disconnectedCount = saveState.getInt(KEY_DISCONNECTED_COUNT, 0);
        List<P> disconnectedProviders = this.getDisconnectedProviders();
        while (matchCount && disconnectedProviders.size() < disconnectedCount) {
            this.createDisconnectedProvider();
        }
        while (matchCount && disconnectedProviders.size() > disconnectedCount) {
            this.removeDisconnectedProvider((SaveableProvider)disconnectedProviders.get(disconnectedProviders.size() - 1));
        }
        int count = Math.min(disconnectedCount, disconnectedProviders.size());
        for (int i = 0; i < count; ++i) {
            String stateName = PREFIX_DISCONNECTED_PROVIDER + i;
            Element dpElement = saveState.getXmlElement(stateName);
            if (dpElement == null) continue;
            SaveableProvider dp = (SaveableProvider)disconnectedProviders.get(i);
            SaveState dpState = new SaveState(dpElement);
            reader.accept(dp, (SaveState)dpState);
        }
    }

    public void writeConfigState(SaveState saveState) {
        this.doWrite(saveState, SaveableProvider::writeConfigState);
    }

    public void readConfigState(SaveState saveState) {
        this.doRead(saveState, SaveableProvider::readConfigState, true);
    }

    public void writeDataState(SaveState saveState) {
        this.doWrite(saveState, SaveableProvider::writeDataState);
    }

    public void readDataState(SaveState saveState) {
        this.doRead(saveState, SaveableProvider::readDataState, false);
    }

    public static interface SaveableProvider {
        public void writeConfigState(SaveState var1);

        public void readConfigState(SaveState var1);

        public void writeDataState(SaveState var1);

        public void readDataState(SaveState var1);
    }
}

