/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.register;

import ghidra.app.plugin.core.debug.gui.register.DebuggerRegistersProvider;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.Objects;

public class RegisterRow {
    private final DebuggerRegistersProvider provider;
    private boolean favorite;
    private final int number;
    private final Register register;

    protected RegisterRow(DebuggerRegistersProvider provider, int number, Register register) {
        this.provider = provider;
        this.number = number;
        this.register = Objects.requireNonNull(register);
        this.favorite = provider.isFavorite(register);
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
        this.provider.setFavorite(this.register, favorite);
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public int getNumber() {
        return this.number;
    }

    public Register getRegister() {
        return this.register;
    }

    public String getName() {
        return this.register.getName();
    }

    public boolean isValueEditable() {
        return this.provider.canWriteRegister(this.register);
    }

    public void setValue(BigInteger value) {
        try {
            this.provider.writeRegisterValue(this.register, value);
        }
        catch (Throwable t) {
            Msg.showError((Object)this, null, (String)"Cannot edit Register Value", (Object)t.getMessage(), (Throwable)t);
        }
    }

    public BigInteger getValue() {
        return this.provider.getRegisterValue(this.register);
    }

    public Data getData() {
        return this.provider.getRegisterData(this.register);
    }

    public void setDataType(DataType dataType) {
        this.provider.writeRegisterDataType(this.register, dataType);
    }

    public DataType getDataType() {
        return this.provider.getRegisterDataType(this.register);
    }

    public void setRepresentation(String representation) {
        this.provider.writeRegisterValueRepresentation(this.register, representation);
    }

    public boolean isRepresentationEditable() {
        return this.provider.canWriteRegisterRepresentation(this.register);
    }

    public String getRepresentation() {
        return this.provider.getRegisterValueRepresentation(this.register);
    }

    public boolean isKnown() {
        return this.provider.isRegisterKnown(this.register);
    }

    public boolean isChanged() {
        return this.provider.isRegisterChanged(this.register);
    }

    public DebuggerCoordinates getCurrent() {
        return this.provider.getCurrent();
    }
}

