/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Register;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

sealed interface Sym {
    public static Sym opaque() {
        return OpaqueSym.OPAQUE;
    }

    public Sym add(CompilerSpec var1, Sym var2);

    default public Sym sub(CompilerSpec cSpec, Sym in2) {
        return this.add(cSpec, in2.twosComp());
    }

    public Sym twosComp();

    public Sym and(CompilerSpec var1, Sym var2);

    public long sizeOf(CompilerSpec var1);

    public static Sym constant(long value) {
        return new ConstSym(value, 8);
    }

    public Address addressIn(AddressSpace var1, CompilerSpec var2);

    public static enum OpaqueSym implements Sym
    {
        OPAQUE;


        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            return this;
        }

        @Override
        public Sym and(CompilerSpec cSpec, Sym in2) {
            return this;
        }

        @Override
        public Sym twosComp() {
            return this;
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            return Address.NO_ADDRESS;
        }
    }

    public record ConstSym(long value, int size) implements Sym
    {
        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            Sym sym;
            Sym sym2 = in2;
            Objects.requireNonNull(sym2);
            Sym sym3 = sym2;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstSym.class, RegisterSym.class, StackOffsetSym.class}, (Object)sym3, n)) {
                    case 0: {
                        ConstSym const2 = (ConstSym)sym3;
                        sym = new ConstSym(this.value + const2.value, this.size);
                        break block5;
                    }
                    case 1: {
                        RegisterSym reg2 = (RegisterSym)sym3;
                        if (reg2.register() != cSpec.getStackPointer()) {
                            n = 2;
                            continue block5;
                        }
                        sym = new StackOffsetSym(this.value);
                        break block5;
                    }
                    case 2: {
                        StackOffsetSym off2 = (StackOffsetSym)sym3;
                        sym = new StackOffsetSym(this.value + off2.offset);
                        break block5;
                    }
                    default: {
                        sym = Sym.opaque();
                        break block5;
                    }
                }
                break;
            }
            return sym;
        }

        @Override
        public Sym and(CompilerSpec cSpec, Sym in2) {
            Sym sym = in2;
            Objects.requireNonNull(sym);
            Sym sym2 = sym;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstSym.class, RegisterSym.class, StackDerefSym.class}, (Object)sym2, n)) {
                case 0 -> {
                    ConstSym const2 = (ConstSym)sym2;
                    yield new ConstSym(this.value & const2.value, this.size);
                }
                case 1 -> {
                    RegisterSym reg2 = (RegisterSym)sym2;
                    yield reg2.withAppliedMask(this.value);
                }
                case 2 -> {
                    StackDerefSym deref2 = (StackDerefSym)sym2;
                    yield deref2.withAppliedMask(this.value);
                }
                default -> Sym.opaque();
            };
        }

        @Override
        public Sym twosComp() {
            return new ConstSym(-this.value, this.size);
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            return this.size;
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            if (space.isConstantSpace() || space.isRegisterSpace() || space.isUniqueSpace()) {
                return space.getAddress(this.value);
            }
            return Address.NO_ADDRESS;
        }
    }

    public record StackDerefSym(long offset, long mask, int size) implements Sym
    {
        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            Sym sym = in2;
            Objects.requireNonNull(sym);
            Sym sym2 = sym;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstSym.class}, (Object)sym2, n)) {
                case 0 -> {
                    ConstSym const2 = (ConstSym)sym2;
                    yield const2.add(cSpec, this);
                }
                default -> Sym.opaque();
            };
        }

        @Override
        public Sym and(CompilerSpec cSpec, Sym in2) {
            Sym sym = in2;
            Objects.requireNonNull(sym);
            Sym sym2 = sym;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstSym.class}, (Object)sym2, n)) {
                case 0 -> {
                    ConstSym const2 = (ConstSym)sym2;
                    yield const2.and(cSpec, this);
                }
                default -> Sym.opaque();
            };
        }

        public StackDerefSym withAppliedMask(long mask) {
            return new StackDerefSym(this.offset, this.mask & mask, this.size);
        }

        @Override
        public Sym twosComp() {
            return Sym.opaque();
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            return this.size;
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            return Address.NO_ADDRESS;
        }
    }

    public record StackOffsetSym(long offset) implements Sym
    {
        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            Sym sym = in2;
            Objects.requireNonNull(sym);
            Sym sym2 = sym;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstSym.class}, (Object)sym2, n)) {
                case 0 -> {
                    ConstSym const2 = (ConstSym)sym2;
                    yield const2.add(cSpec, this);
                }
                default -> Sym.opaque();
            };
        }

        @Override
        public Sym and(CompilerSpec cSpec, Sym in2) {
            Sym sym = in2;
            Objects.requireNonNull(sym);
            Sym sym2 = sym;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstSym.class}, (Object)sym2, n)) {
                case 0 -> {
                    ConstSym const2 = (ConstSym)sym2;
                    yield const2.and(cSpec, this);
                }
                default -> Sym.opaque();
            };
        }

        @Override
        public Sym twosComp() {
            return Sym.opaque();
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            return cSpec.getStackPointer().getMinimumByteSize();
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            if (space != cSpec.getStackBaseSpace()) {
                return Address.NO_ADDRESS;
            }
            return cSpec.getStackSpace().getAddress(this.offset);
        }
    }

    public record RegisterSym(Register register, long mask) implements Sym
    {
        @Override
        public Sym add(CompilerSpec cSpec, Sym in2) {
            Sym sym = in2;
            Objects.requireNonNull(sym);
            Sym sym2 = sym;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstSym.class}, (Object)sym2, n)) {
                case 0 -> {
                    ConstSym const2 = (ConstSym)sym2;
                    yield const2.add(cSpec, this);
                }
                default -> Sym.opaque();
            };
        }

        @Override
        public Sym and(CompilerSpec cSpec, Sym in2) {
            Sym sym = in2;
            Objects.requireNonNull(sym);
            Sym sym2 = sym;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstSym.class}, (Object)sym2, n)) {
                case 0 -> {
                    ConstSym const2 = (ConstSym)sym2;
                    yield const2.and(cSpec, this);
                }
                default -> Sym.opaque();
            };
        }

        public RegisterSym withAppliedMask(long mask) {
            return new RegisterSym(this.register, this.mask & mask);
        }

        @Override
        public Sym twosComp() {
            return Sym.opaque();
        }

        @Override
        public long sizeOf(CompilerSpec cSpec) {
            return this.register.getMinimumByteSize();
        }

        @Override
        public Address addressIn(AddressSpace space, CompilerSpec cSpec) {
            if (this.register != cSpec.getStackPointer()) {
                return Address.NO_ADDRESS;
            }
            if (space != cSpec.getStackBaseSpace()) {
                return Address.NO_ADDRESS;
            }
            return cSpec.getStackSpace().getAddress(0L);
        }
    }
}

