/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.connection.tree;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.TraceRmiConnectionManagerProvider;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.AbstractTraceRmiManagerNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiTargetNode;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import resources.MultiIcon;

public class TraceRmiConnectionNode
extends AbstractTraceRmiManagerNode {
    private static final Icon ICON = DebuggerResources.ICON_CONNECTION;
    private static final Icon ICON_TX = new MultiIcon(ICON, new Icon[]{ICON_TX_OVERLAY});
    private final TraceRmiConnection connection;
    private final Map<Target, TraceRmiTargetNode> targetNodes = new HashMap<Target, TraceRmiTargetNode>();

    public TraceRmiConnectionNode(TraceRmiConnectionManagerProvider provider, TraceRmiConnection connection) {
        super(provider, "Connected: " + String.valueOf(connection.getRemoteAddress()));
        this.connection = connection;
    }

    public String getDisplayText() {
        return this.connection.getDescription() + " at " + String.valueOf(this.connection.getRemoteAddress());
    }

    public Icon getIcon(boolean expanded) {
        return this.connection.isBusy() ? ICON_TX : ICON;
    }

    public String getToolTip() {
        return "Trace RMI Connection to " + this.connection.getDescription() + " at " + String.valueOf(this.connection.getRemoteAddress());
    }

    public boolean isLeaf() {
        return false;
    }

    private TraceRmiTargetNode newTargetNode(Target target) {
        return new TraceRmiTargetNode(this.provider, this, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceRmiTargetNode addTargetNode(Target target) {
        TraceRmiTargetNode node;
        Map<Target, TraceRmiTargetNode> map = this.targetNodes;
        synchronized (map) {
            node = this.targetNodes.computeIfAbsent(target, this::newTargetNode);
        }
        this.addNode(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTargetNode(Target target) {
        TraceRmiTargetNode node;
        Map<Target, TraceRmiTargetNode> map = this.targetNodes;
        synchronized (map) {
            node = this.targetNodes.remove(target);
        }
        if (node == null) {
            return;
        }
        this.removeNode(node);
    }

    public TraceRmiTargetNode targetPublished(Target target) {
        return this.addTargetNode(target);
    }

    public void targetWithdrawn(Target target) {
        this.removeTargetNode(target);
    }

    public TraceRmiConnection getConnection() {
        return this.connection;
    }
}

