/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import generic.theme.GThemeDefaults;
import ghidra.service.graph.Attributed;
import java.awt.Color;
import java.awt.ItemSelectable;
import java.awt.Paint;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import javax.swing.event.EventListenerList;

public class AttributeFilters
implements ItemSelectable {
    List<AbstractButton> buttons = new ArrayList<AbstractButton>();
    Multiset<String> multiset = HashMultiset.create();
    Set<String> selectedTexts = new HashSet<String>();
    protected EventListenerList listenerList = new EventListenerList();

    public static Builder builder() {
        return new Builder();
    }

    private AttributeFilters(Builder builder) {
        this(builder.excludedAttributes, builder.elements, builder.maxFactor, builder.buttonSupplier, builder.paintFunction);
    }

    private AttributeFilters(Collection<String> precludedNames, Set<? extends Attributed> elements, double maxFactor, Supplier<AbstractButton> buttonSupplier, Function<String, Paint> paintFunction) {
        for (Attributed attributed : elements) {
            HashMap attributeMap = new HashMap(attributed.getAttributes());
            for (Map.Entry entry : attributeMap.entrySet()) {
                if (precludedNames.contains(entry.getKey())) continue;
                this.multiset.add((Object)((String)entry.getValue()));
            }
        }
        if (maxFactor == 0.0) {
            maxFactor = 0.01;
        }
        double threshold = Math.max(2.0, (double)elements.size() * maxFactor);
        this.multiset.removeIf(s -> (double)this.multiset.count(s) < threshold);
        this.multiset.elementSet();
        for (String key : this.multiset.elementSet()) {
            AbstractButton button = buttonSupplier.get();
            button.setForeground((Color)paintFunction.apply(key));
            button.setText(key);
            button.addItemListener(item -> {
                if (item.getStateChange() == 1) {
                    this.selectedTexts.add(button.getText());
                    this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedTexts, 1));
                } else if (item.getStateChange() == 2) {
                    this.selectedTexts.remove(button.getText());
                    this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedTexts, 2));
                }
            });
            this.buttons.add(button);
        }
    }

    public List<AbstractButton> getButtons() {
        return this.buttons;
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.selectedTexts.toArray();
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    public static class Builder {
        private Collection<String> excludedAttributes = Collections.emptyList();
        private Set<? extends Attributed> elements;
        private double maxFactor;
        private Supplier<AbstractButton> buttonSupplier = JRadioButton::new;
        private Function<String, Paint> paintFunction = v -> GThemeDefaults.Colors.FOREGROUND;

        public Builder exclude(Collection<String> excluded) {
            this.excludedAttributes = excluded;
            return this;
        }

        public Builder elements(Set<? extends Attributed> newElements) {
            this.elements = newElements;
            return this;
        }

        public Builder maxFactor(double newMaxFactor) {
            this.maxFactor = newMaxFactor;
            return this;
        }

        public Builder buttonSupplier(Supplier<AbstractButton> newButtonSupplier) {
            this.buttonSupplier = newButtonSupplier;
            return this;
        }

        public Builder paintFunction(Function<String, Paint> newPaintFunction) {
            this.paintFunction = newPaintFunction;
            return this;
        }

        public AttributeFilters build() {
            return new AttributeFilters(this);
        }
    }
}

