/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.DockingUtils;
import docking.util.AnimationUtils;
import docking.util.SwingAnimationCallback;
import docking.widgets.EventTrigger;
import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.listener.FieldLocationListener;
import docking.widgets.fieldpanel.listener.FieldMouseListener;
import docking.widgets.fieldpanel.listener.FieldSelectionListener;
import docking.widgets.fieldpanel.listener.LayoutListener;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.FieldSelectionHelper;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.HoverProvider;
import docking.widgets.fieldpanel.support.ViewerPosition;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import generic.theme.GColor;
import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.ClangCommentToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangOpToken;
import ghidra.app.decompiler.ClangStatement;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.DecompilerLocationInfo;
import ghidra.app.decompiler.component.ClangDecompilerHighlighter;
import ghidra.app.decompiler.component.ClangHighlightController;
import ghidra.app.decompiler.component.ClangHighlightListener;
import ghidra.app.decompiler.component.ClangLayoutController;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.ColorProvider;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerHoverProvider;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.component.DefaultColorProvider;
import ghidra.app.decompiler.component.EmptyDecompileData;
import ghidra.app.decompiler.component.NameTokenMatcher;
import ghidra.app.decompiler.component.TokenHighlightColors;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.decompiler.component.margin.DecompilerMarginProvider;
import ghidra.app.decompiler.component.margin.LineNumberDecompilerMarginProvider;
import ghidra.app.decompiler.component.margin.VerticalLayoutPixelIndexMap;
import ghidra.app.decompiler.location.DefaultDecompilerLocation;
import ghidra.app.decompiler.location.FunctionNameDecompilerLocation;
import ghidra.app.decompiler.location.VariableDecompilerLocation;
import ghidra.app.plugin.core.decompile.DecompilerClipboardProvider;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearchLocation;
import ghidra.app.util.viewer.util.ScrollpaneAlignedHorizontalLayout;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.UndefinedFunction;
import ghidra.util.bean.field.AnnotatedTextFieldElement;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DecompilerPanel
extends JPanel
implements FieldMouseListener,
FieldLocationListener,
FieldSelectionListener,
ClangHighlightListener,
LayoutListener {
    private static final Color NON_FUNCTION_BACKGROUND_COLOR_DEF = new GColor("color.bg.undefined");
    private static final Color SPECIAL_COLOR_DEF = new GColor("color.bg.decompiler.highlights.special");
    private final DecompilerController controller;
    private final DecompileOptions options;
    private LineNumberDecompilerMarginProvider lineNumbersMargin;
    private final DecompilerFieldPanel fieldPanel;
    private ClangLayoutController layoutController;
    private final IndexedScrollPane scroller;
    private final JComponent taskMonitorComponent;
    private final List<DecompilerMarginProvider> marginProviders = new ArrayList<DecompilerMarginProvider>();
    private final VerticalLayoutPixelIndexMap pixmap = new VerticalLayoutPixelIndexMap();
    private FieldHighlightFactory hlFactory;
    private ClangHighlightController highlightController;
    private Map<String, DecompilerHighlighter> highlightersById = new HashMap<String, DecompilerHighlighter>();
    private PendingHighlightUpdate pendingHighlightUpdate;
    private SwingUpdateManager highlighCursorUpdater = new SwingUpdateManager(() -> {
        if (this.pendingHighlightUpdate != null) {
            this.pendingHighlightUpdate.doUpdate();
            this.pendingHighlightUpdate = null;
        }
    });
    private Set<String> ignoredMiddleMouseTokens = Set.of("{", "}", ";");
    private ActiveMiddleMouse activeMiddleMouse;
    private int middleMouseHighlightButton;
    private Color middleMouseHighlightColor;
    private Color currentVariableHighlightColor;
    private Color searchHighlightColor;
    private SearchLocation currentSearchLocation;
    private DecompileData decompileData = new EmptyDecompileData("No Function");
    private final DecompilerClipboardProvider clipboard;
    private Color originalBackgroundColor;
    private boolean useNonFunctionColor = false;
    private boolean navitationEnabled = true;
    private DecompilerHoverProvider decompilerHoverProvider;

    DecompilerPanel(DecompilerController controller, DecompileOptions options, DecompilerClipboardProvider clipboard, JComponent taskMonitorComponent) {
        this.controller = controller;
        this.options = options;
        this.clipboard = clipboard;
        this.taskMonitorComponent = taskMonitorComponent;
        FontMetrics metrics = this.getFontMetrics(options);
        if (clipboard != null) {
            clipboard.setFontMetrics(metrics);
        }
        this.hlFactory = new SearchHighlightFactory();
        this.layoutController = new ClangLayoutController(options, this, metrics, this.hlFactory);
        this.fieldPanel = new DecompilerFieldPanel(this.layoutController);
        this.scroller = new IndexedScrollPane((JComponent)((Object)this.fieldPanel));
        this.fieldPanel.addFieldSelectionListener(this);
        this.fieldPanel.addFieldMouseListener(this);
        this.fieldPanel.addFieldLocationListener(this);
        this.fieldPanel.addLayoutListener(this);
        this.fieldPanel.setName("Decompiler View");
        this.fieldPanel.getAccessibleContext().setAccessibleName("Decompiler View");
        this.fieldPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (DecompilerMarginProvider provider : DecompilerPanel.this.marginProviders) {
                    provider.getComponent().invalidate();
                }
                DecompilerPanel.this.validate();
            }
        });
        this.setBackground(options.getBackgroundColor());
        this.decompilerHoverProvider = new DecompilerHoverProvider();
        this.searchHighlightColor = options.getSearchHighlightColor();
        this.currentVariableHighlightColor = options.getCurrentVariableHighlightColor();
        this.middleMouseHighlightColor = options.getMiddleMouseHighlightColor();
        this.middleMouseHighlightButton = options.getMiddleMouseHighlightButton();
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller);
        this.add((Component)taskMonitorComponent, "South");
        this.setPreferredSize(new Dimension(600, 400));
        this.setDecompileData(new EmptyDecompileData("No Function"));
        if (options.isDisplayLineNumbers()) {
            this.lineNumbersMargin = new LineNumberDecompilerMarginProvider();
            this.addMarginProvider(this.lineNumbersMargin);
        }
    }

    public DecompilerController getController() {
        return this.controller;
    }

    public List<ClangLine> getLines() {
        return this.layoutController.getLines();
    }

    public List<Field> getFields() {
        return Arrays.asList(this.layoutController.getFields());
    }

    public FieldPanel getFieldPanel() {
        return this.fieldPanel;
    }

    public TokenHighlightColors getSecondaryHighlightColors() {
        return this.highlightController.getSecondaryHighlightColors();
    }

    public boolean hasSecondaryHighlights(Function function) {
        return this.highlightController.hasSecondaryHighlights(function);
    }

    public boolean hasSecondaryHighlight(ClangToken token) {
        return this.highlightController.hasSecondaryHighlight(token);
    }

    public Color getSecondaryHighlight(ClangToken token) {
        return this.highlightController.getSecondaryHighlight(token);
    }

    public TokenHighlights getHighlights(DecompilerHighlighter highligter) {
        return this.highlightController.getHighlighterHighlights(highligter);
    }

    public TokenHighlights getMiddleMouseHighlights() {
        if (this.activeMiddleMouse != null) {
            return this.activeMiddleMouse.getHighlights();
        }
        return null;
    }

    private Set<DecompilerHighlighter> getSecondaryHighlihgtersByFunction(Function function) {
        return this.highlightController.getSecondaryHighlighters(function);
    }

    public void removeSecondaryHighlights(Function function) {
        this.highlightController.removeSecondaryHighlights(function);
    }

    public void removeSecondaryHighlight(ClangToken token) {
        this.highlightController.removeSecondaryHighlights(token);
    }

    public void addSecondaryHighlight(ClangToken token) {
        ColorProvider cp = this.highlightController.getGeneratedColorProvider();
        this.addSecondaryHighlight(token.getText(), cp);
    }

    public void addSecondaryHighlight(ClangToken token, Color color) {
        DefaultColorProvider cp = new DefaultColorProvider("User Secondary Highlight", color);
        this.addSecondaryHighlight(token.getText(), cp);
    }

    private void addSecondaryHighlight(String tokenText, ColorProvider colorProvider) {
        NameTokenMatcher matcher = new NameTokenMatcher(tokenText, colorProvider);
        DecompilerHighlighter highlighter = this.createHighlighter(matcher);
        this.applySecondaryHighlights(highlighter);
    }

    private void applySecondaryHighlights(DecompilerHighlighter highlighter) {
        Function function = this.decompileData.getFunction();
        this.highlightController.addSecondaryHighlighter(function, highlighter);
        highlighter.applyHighlights();
    }

    private void toggleMiddleMouseHighlight(FieldLocation location, Field field) {
        ClangToken token = ((ClangTextField)field).getToken(location);
        ActiveMiddleMouse previousMiddleMouse = this.activeMiddleMouse;
        this.activeMiddleMouse = null;
        if (previousMiddleMouse != null) {
            previousMiddleMouse.clear();
            if (previousMiddleMouse.matches(token)) {
                return;
            }
        }
        if (this.shouldIgnoreOpToken(token)) {
            return;
        }
        if (this.shouldIgnoreSyntaxTokenHighlight(token)) {
            return;
        }
        ActiveMiddleMouse newMiddleMouse = new ActiveMiddleMouse(token.getText());
        newMiddleMouse.apply();
        this.activeMiddleMouse = newMiddleMouse;
    }

    private boolean shouldIgnoreOpToken(ClangToken token) {
        if (!(token instanceof ClangOpToken)) {
            return false;
        }
        String text = token.toString();
        return !text.equals("return");
    }

    private boolean shouldIgnoreSyntaxTokenHighlight(ClangToken token) {
        if (!(token instanceof ClangSyntaxToken)) {
            return false;
        }
        ClangSyntaxToken syntaxToken = (ClangSyntaxToken)token;
        String string = syntaxToken.toString();
        return this.ignoredMiddleMouseTokens.contains(string);
    }

    void addHighlighterHighlights(ClangDecompilerHighlighter highlighter, Supplier<? extends Collection<ClangToken>> tokens, ColorProvider colorProvider) {
        this.highlightController.addHighlighterHighlights(highlighter, tokens, colorProvider);
    }

    void removeHighlighterHighlights(DecompilerHighlighter highlighter) {
        this.highlightController.removeHighlighterHighlights(highlighter);
    }

    private DecompilerHighlighter createHighlighter(CTokenHighlightMatcher tm) {
        Function function = this.decompileData.getFunction();
        return this.createHighlighter(function, tm);
    }

    public DecompilerHighlighter createHighlighter(Function f, CTokenHighlightMatcher tm) {
        UUID uuId = UUID.randomUUID();
        String id = uuId.toString();
        return this.createHighlighter(id, f, tm);
    }

    public DecompilerHighlighter createHighlighter(String id, Function f, CTokenHighlightMatcher tm) {
        DecompilerHighlighter currentHighlighter = this.highlightersById.get(id);
        if (currentHighlighter != null) {
            currentHighlighter.dispose();
        }
        ClangDecompilerHighlighter newHighlighter = new ClangDecompilerHighlighter(id, this, f, tm);
        this.highlightersById.put(id, newHighlighter);
        this.highlightController.addHighlighter(newHighlighter);
        return newHighlighter;
    }

    public DecompilerHighlighter getHighlighter(String id) {
        return this.highlightersById.get(id);
    }

    void removeHighlighter(String id) {
        DecompilerHighlighter highlighter = this.highlightersById.remove(id);
        this.highlightController.removeHighlighter(highlighter);
    }

    public void clearPrimaryHighlights() {
        this.highlightController.clearPrimaryHighlights();
    }

    public void addHighlights(Set<Varnode> varnodes, ColorProvider colorProvider) {
        ClangTokenGroup root = this.layoutController.getRoot();
        this.highlightController.addPrimaryHighlights(root, colorProvider);
    }

    public void addHighlights(Set<PcodeOp> ops, Color hlColor) {
        ClangTokenGroup root = this.layoutController.getRoot();
        this.highlightController.addPrimaryHighlights(root, ops, hlColor);
    }

    public void setHighlightController(ClangHighlightController highlightController) {
        if (this.highlightController != null) {
            this.highlightController.removeListener(this);
        }
        this.highlightController = ClangHighlightController.dummyIfNull(highlightController);
        highlightController.setHighlightColor(this.currentVariableHighlightColor);
        highlightController.addListener(this);
    }

    public ClangHighlightController getHighlightController() {
        return this.highlightController;
    }

    @Override
    public void tokenHighlightsChanged() {
        this.repaint();
    }

    public void tokenRenamed(ClangToken token, String newName) {
        this.repairMiddleMouseSelectionForRename(token, newName);
        this.repairSecondarySelectionForRename(token, newName);
    }

    private void repairSecondarySelectionForRename(ClangToken token, String newName) {
        Color hlColor = this.highlightController.getSecondaryHighlight(token);
        if (hlColor == null) {
            return;
        }
        this.highlightController.removeSecondaryHighlights(token);
        this.controller.doWhenNotBusy(() -> this.addSecondaryHighlight(newName, (ClangToken t) -> hlColor));
    }

    private void repairMiddleMouseSelectionForRename(ClangToken token, String newName) {
        if (this.activeMiddleMouse == null || !this.activeMiddleMouse.matches(token)) {
            return;
        }
        this.activeMiddleMouse.clear();
        this.activeMiddleMouse = new ActiveMiddleMouse(newName);
        this.controller.doWhenNotBusy(() -> this.activeMiddleMouse.apply());
    }

    private void cloneServiceHiglighters(DecompilerPanel sourcePanel) {
        Set<DecompilerHighlighter> serviceHighlighters = sourcePanel.highlightController.getServiceHighlighters();
        for (DecompilerHighlighter otherHighlighter : serviceHighlighters) {
            if (!(otherHighlighter instanceof ClangDecompilerHighlighter)) continue;
            ClangDecompilerHighlighter clangHighlighter = (ClangDecompilerHighlighter)otherHighlighter;
            ClangDecompilerHighlighter newHighlighter = clangHighlighter.clone(this);
            this.highlightersById.put(newHighlighter.getId(), newHighlighter);
            TokenHighlights otherHighlighterTokens = sourcePanel.highlightController.getHighlighterHighlights(otherHighlighter);
            if (otherHighlighterTokens == null || otherHighlighterTokens.isEmpty()) continue;
            newHighlighter.applyHighlights();
        }
    }

    public void cloneHighlights(DecompilerPanel sourcePanel) {
        Function function = this.decompileData.getFunction();
        this.cloneServiceHiglighters(sourcePanel);
        Set<DecompilerHighlighter> secondaryHighlighters = sourcePanel.getSecondaryHighlihgtersByFunction(function);
        for (DecompilerHighlighter highlighter : secondaryHighlighters) {
            if (!(highlighter instanceof ClangDecompilerHighlighter)) continue;
            ClangDecompilerHighlighter clangHighlighter = (ClangDecompilerHighlighter)highlighter;
            ClangDecompilerHighlighter newHighlighter = clangHighlighter.copy(this);
            this.highlightersById.put(newHighlighter.getId(), newHighlighter);
            this.applySecondaryHighlights(newHighlighter);
        }
    }

    @Override
    public void setBackground(Color bg) {
        this.originalBackgroundColor = bg;
        if (this.useNonFunctionColor) {
            bg = NON_FUNCTION_BACKGROUND_COLOR_DEF;
        }
        if (this.fieldPanel != null) {
            this.fieldPanel.setBackgroundColor(bg);
            this.scroller.setBackground(bg);
        }
        super.setBackground(bg);
    }

    void setDecompileData(DecompileData decompileData) {
        if (this.layoutController == null) {
            return;
        }
        DecompileData oldData = this.decompileData;
        this.decompileData = decompileData;
        Function function = decompileData.getFunction();
        if (decompileData.hasDecompileResults()) {
            this.layoutController.buildLayouts(function, decompileData.getCCodeMarkup(), null, true);
            if (decompileData.getDebugFile() != null) {
                this.controller.setStatusMessage("Debug file generated: " + decompileData.getDebugFile().getAbsolutePath());
            }
        } else {
            this.layoutController.buildLayouts(null, null, decompileData.getErrorMessage(), true);
        }
        this.setLocation(oldData, decompileData);
        this.decompilerHoverProvider.setProgram(decompileData.getProgram());
        this.useNonFunctionColor = function instanceof UndefinedFunction;
        this.setBackground(this.originalBackgroundColor);
        if (this.clipboard != null) {
            this.clipboard.selectionChanged(null);
        }
        this.currentSearchLocation = null;
        if (function != null) {
            this.highlightController.reapplyAllHighlights(function);
        }
    }

    private void setLocation(DecompileData oldData, DecompileData newData) {
        Function function = oldData.getFunction();
        if (SystemUtilities.isEqual((Object)function, (Object)newData.getFunction())) {
            return;
        }
        ProgramLocation location = newData.getLocation();
        if (location != null) {
            this.setLocation(location, newData.getViewerPosition());
        }
    }

    public ClangLayoutController getLayoutController() {
        return this.layoutController;
    }

    public boolean containsLocation(ProgramLocation location) {
        return this.decompileData.contains(location);
    }

    public void setLocation(ProgramLocation location, ViewerPosition viewerPosition) {
        this.repaint();
        if (location.getAddress() == null) {
            return;
        }
        if (viewerPosition != null) {
            this.fieldPanel.setViewerPosition(viewerPosition.getIndex(), viewerPosition.getXOffset(), viewerPosition.getYOffset());
        }
        if (location instanceof DecompilerLocation) {
            DecompilerLocation decompilerLocation = (DecompilerLocation)location;
            this.fieldPanel.goTo(BigInteger.valueOf(decompilerLocation.getLineNumber()), 0, 0, decompilerLocation.getCharPos(), false);
            return;
        }
        Address address = location.getAddress();
        if (this.goToFunctionSignature(address)) {
            return;
        }
        List<ClangToken> tokens = DecompilerUtils.getTokensFromView(this.layoutController.getFields(), address);
        this.goToBeginningOfLine(tokens);
    }

    private boolean goToFunctionSignature(Address address) {
        if (!this.decompileData.hasDecompileResults()) {
            return false;
        }
        Address entry = this.decompileData.getFunction().getEntryPoint();
        if (!entry.equals((Object)address)) {
            return false;
        }
        List<ClangLine> lines = this.layoutController.getLines();
        ClangLine signatureLine = this.getFunctionSignatureLine(lines);
        if (signatureLine == null) {
            return false;
        }
        int lineNumber = signatureLine.getLineNumber() - 1;
        this.fieldPanel.goTo(BigInteger.valueOf(lineNumber), 0, 0, 0, false);
        return true;
    }

    private ClangLine getFunctionSignatureLine(List<ClangLine> functionLines) {
        for (ClangLine line : functionLines) {
            List<ClangToken> tokens = line.getAllTokens();
            for (ClangToken token : tokens) {
                if (!(token.Parent() instanceof ClangFuncProto)) continue;
                return line;
            }
        }
        return null;
    }

    private void goToBeginningOfLine(List<ClangToken> tokens) {
        if (tokens.isEmpty()) {
            return;
        }
        int firstLineNumber = DecompilerUtils.findIndexOfFirstField(tokens, this.layoutController.getFields());
        if (firstLineNumber != -1) {
            this.fieldPanel.goTo(BigInteger.valueOf(firstLineNumber), 0, 0, 0, false);
        }
    }

    public void goToToken(ClangToken token) {
        ClangLine line = token.getLineParent();
        int offset = 0;
        List<ClangToken> tokens = line.getAllTokens();
        for (ClangToken lineToken : tokens) {
            if (lineToken.equals(token)) break;
            offset += lineToken.getText().length();
        }
        int lineNumber = line.getLineNumber() - 1;
        int column = offset;
        FieldLocation start = this.getCursorPosition();
        int distance = this.getOffscreenDistance(lineNumber);
        if (distance == 0) {
            this.fieldPanel.navigateTo(lineNumber, column);
            return;
        }
        ScrollingCallback callback = new ScrollingCallback(start, lineNumber, column, distance);
        AnimationUtils.executeSwingAnimationCallback((SwingAnimationCallback)callback);
    }

    private int getOffscreenDistance(int line) {
        AnchoredLayout start = this.fieldPanel.getVisibleStartLayout();
        int visibleStartLine = start.getIndex().intValue();
        if (visibleStartLine > line) {
            return visibleStartLine - line;
        }
        AnchoredLayout end = this.fieldPanel.getVisibleEndLayout();
        int visibleEndLine = end.getIndex().intValue();
        if (visibleEndLine < line) {
            return line - visibleEndLine;
        }
        return 0;
    }

    void setSelection(ProgramSelection selection) {
        FieldSelection fieldSelection = null;
        if (selection == null || selection.isEmpty()) {
            fieldSelection = new FieldSelection();
        } else {
            List<ClangToken> tokens = DecompilerUtils.getTokens((ClangNode)this.layoutController.getRoot(), (AddressSetView)selection);
            fieldSelection = DecompilerUtils.getFieldSelection(tokens);
        }
        this.fieldPanel.setSelection(fieldSelection);
    }

    public void setDecompilerHoverProvider(DecompilerHoverProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the hover handler to null!");
        }
        if (this.decompilerHoverProvider != null) {
            if (this.decompilerHoverProvider.isShowing()) {
                this.decompilerHoverProvider.closeHover();
            }
            this.decompilerHoverProvider.initializeListingHoverHandler(provider);
            this.decompilerHoverProvider.dispose();
        }
        this.decompilerHoverProvider = provider;
    }

    public void dispose() {
        this.setDecompileData(new EmptyDecompileData("Disposed"));
        this.layoutController = null;
        this.decompilerHoverProvider.dispose();
        this.highlighCursorUpdater.dispose();
        this.highlightController.dispose();
        this.highlightersById.clear();
    }

    public FontMetrics getFontMetrics() {
        Font font = this.options.getDefaultFont();
        return super.getFontMetrics(font);
    }

    private FontMetrics getFontMetrics(DecompileOptions decompileOptions) {
        Font font = decompileOptions.getDefaultFont();
        return this.getFontMetrics(font);
    }

    void setMouseNavigationEnabled(boolean enabled) {
        this.navitationEnabled = enabled;
    }

    public void buttonPressed(FieldLocation location, Field field, MouseEvent ev) {
        if (!this.decompileData.hasDecompileResults()) {
            return;
        }
        int clickCount = ev.getClickCount();
        int buttonState = ev.getButton();
        if (buttonState == 1) {
            if (DockingUtils.isControlModifier((MouseEvent)ev) && clickCount == 2) {
                this.tryToGoto(location, field, ev, true);
            } else if (clickCount == 2) {
                this.tryToGoto(location, field, ev, false);
            } else if (DockingUtils.isControlModifier((MouseEvent)ev) && ev.isShiftDown()) {
                this.controller.exportLocation();
            }
        }
        if (buttonState == this.middleMouseHighlightButton && clickCount == 1) {
            this.toggleMiddleMouseHighlight(location, field);
        }
    }

    private void tryToGoto(FieldLocation location, Field field, MouseEvent event, boolean newWindow) {
        if (!this.navitationEnabled) {
            return;
        }
        ClangTextField textField = (ClangTextField)field;
        ClangToken token = textField.getToken(location);
        if (token instanceof ClangFuncNameToken) {
            this.tryGoToFunction((ClangFuncNameToken)token, newWindow);
        } else if (token instanceof ClangLabelToken) {
            this.tryGoToLabel((ClangLabelToken)token, newWindow);
        } else if (token instanceof ClangVariableToken) {
            this.tryGoToVarnode((ClangVariableToken)token, newWindow);
        } else if (token instanceof ClangCommentToken) {
            this.tryGoToComment(location, event, textField, newWindow);
        } else if (token instanceof ClangSyntaxToken) {
            this.tryGoToSyntaxToken((ClangSyntaxToken)token);
        }
    }

    private void tryGoToComment(FieldLocation location, MouseEvent event, ClangTextField textField, boolean newWindow) {
        FieldElement clickedElement = textField.getClickedObject(location);
        if (clickedElement instanceof AnnotatedTextFieldElement) {
            AnnotatedTextFieldElement annotation = (AnnotatedTextFieldElement)clickedElement;
            this.controller.annotationClicked(annotation, event, newWindow);
            return;
        }
        String text = textField.getText();
        String word = StringUtilities.findWord((String)text, (int)location.col);
        this.tryGoToScalar(word, newWindow);
    }

    private void tryGoToFunction(ClangFuncNameToken functionToken, boolean newWindow) {
        Function function = DecompilerUtils.getFunction(this.controller.getProgram(), functionToken);
        if (function != null) {
            this.controller.goToFunction(function, newWindow);
            return;
        }
    }

    private void tryGoToLabel(ClangLabelToken token, boolean newWindow) {
        ClangTokenGroup root;
        ClangLabelToken destination;
        ClangNode node = token.Parent();
        if (node instanceof ClangStatement && (destination = DecompilerUtils.getGoToTargetToken(root = this.layoutController.getRoot(), token)) != null) {
            this.goToToken(destination);
            return;
        }
        Address addr = token.getMinAddress();
        this.controller.goToAddress(addr, newWindow);
    }

    private void tryGoToSyntaxToken(ClangSyntaxToken token) {
        ClangSyntaxToken otherBrace;
        if (DecompilerUtils.isBrace(token) && (otherBrace = DecompilerUtils.getMatchingBrace(token)) != null) {
            this.goToToken(otherBrace);
        }
    }

    private void tryGoToVarnode(ClangVariableToken token, boolean newWindow) {
        HighVariable highVar;
        Varnode vn = token.getVarnode();
        if (vn == null) {
            PcodeOp op = token.getPcodeOp();
            if (op == null) {
                return;
            }
            int operation = op.getOpcode();
            if (operation != 66 && operation != 65) {
                return;
            }
            vn = op.getInput(1);
            if (vn == null) {
                return;
            }
        }
        if ((highVar = vn.getHigh()) instanceof HighGlobal) {
            vn = highVar.getRepresentative();
        }
        if (vn.isAddress()) {
            Address addr = vn.getAddress();
            if (addr.isMemoryAddress()) {
                this.controller.goToAddress(vn.getAddress(), newWindow);
            }
        } else if (vn.isConstant()) {
            this.controller.goToScalar(vn.getOffset(), newWindow);
        }
    }

    private void tryGoToScalar(String text, boolean newWindow) {
        if (text.startsWith("0x")) {
            text = text.substring(2);
        } else if (text.startsWith("(") && text.endsWith(")")) {
            int commaIx = text.indexOf(",0x");
            if (commaIx < 2) {
                return;
            }
            String spaceName = text.substring(1, commaIx);
            String offsetStr = text.substring(commaIx + 3, text.length() - 1);
            try {
                AddressSpace space = this.decompileData.getProgram().getAddressFactory().getAddressSpace(spaceName);
                if (space == null) {
                    return;
                }
                Address addr = space.getAddress(NumericUtilities.parseHexLong((String)offsetStr), true);
                this.controller.goToAddress(addr, newWindow);
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                // empty catch block
            }
            return;
        }
        try {
            long value = NumericUtilities.parseHexLong((String)text);
            this.controller.goToScalar(value, newWindow);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    Program getProgram() {
        return this.decompileData.getProgram();
    }

    public ProgramLocation getCurrentLocation() {
        if (!this.decompileData.hasDecompileResults()) {
            return null;
        }
        Field currentField = this.fieldPanel.getCurrentField();
        FieldLocation cursorPosition = this.fieldPanel.getCursorLocation();
        return this.getProgramLocation(currentField, cursorPosition);
    }

    public void fieldLocationChanged(FieldLocation location, Field field, EventTrigger trigger) {
        ProgramLocation programLocation;
        if (!this.decompileData.hasDecompileResults()) {
            return;
        }
        this.pendingHighlightUpdate = new PendingHighlightUpdate(location, field, trigger);
        this.highlighCursorUpdater.update();
        if (!(field instanceof ClangTextField)) {
            return;
        }
        ClangToken tok = ((ClangTextField)field).getToken(location);
        if (tok == null) {
            return;
        }
        if (trigger == EventTrigger.GUI_ACTION && (programLocation = this.getProgramLocation(field, location)) != null) {
            this.controller.locationChanged(programLocation);
        }
    }

    public void selectionChanged(FieldSelection selection, EventTrigger trigger) {
        if (this.clipboard != null) {
            this.clipboard.selectionChanged(selection);
        }
        if (!this.decompileData.hasDecompileResults()) {
            return;
        }
        if (trigger != EventTrigger.API_CALL) {
            Program program = this.decompileData.getProgram();
            Field[] lines = this.layoutController.getFields();
            List<ClangToken> tokenList = DecompilerUtils.getTokensInSelection(selection, lines);
            AddressSpace functionSpace = this.decompileData.getFunctionSpace();
            AddressSet addrset = DecompilerUtils.findClosestAddressSet(program, functionSpace, tokenList);
            ProgramSelection programSelection = new ProgramSelection((AddressSetView)addrset);
            this.controller.selectionChanged(programSelection);
        }
    }

    public void layoutsChanged(List<AnchoredLayout> layouts) {
        this.pixmap.layoutsChanged(layouts);
        for (DecompilerMarginProvider element : this.marginProviders) {
            element.setProgram(this.getProgram(), this.layoutController, this.pixmap);
        }
    }

    private ProgramLocation getProgramLocation(Field field, FieldLocation location) {
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangToken token = ((ClangTextField)field).getToken(location);
        if (token == null) {
            return null;
        }
        Address address = DecompilerUtils.getClosestAddress(this.getProgram(), token);
        if (address == null) {
            address = DecompilerUtils.findAddressBefore(this.layoutController.getFields(), token);
        }
        Function function = this.decompileData.getFunction();
        if (address == null) {
            address = function.getEntryPoint();
        }
        Address entryPoint = function.getEntryPoint();
        DecompileResults results = this.decompileData.getDecompileResults();
        int lineNumber = location.getIndex().intValue();
        int charPos = location.col;
        DecompilerLocationInfo info = new DecompilerLocationInfo(entryPoint, results, token, lineNumber, charPos);
        Program program = this.decompileData.getProgram();
        ProgramLocation signatureLocation = this.createFunctionSignatureLocation(token, address, info);
        if (signatureLocation != null) {
            return signatureLocation;
        }
        return new DefaultDecompilerLocation(program, address, info);
    }

    private ProgramLocation createFunctionSignatureLocation(ClangToken token, Address address, DecompilerLocationInfo info) {
        Function function = this.decompileData.getFunction();
        Address entryPoint = function.getEntryPoint();
        if (!entryPoint.equals((Object)address)) {
            return null;
        }
        if (token instanceof ClangFuncNameToken) {
            ClangFuncNameToken ft = (ClangFuncNameToken)token;
            Program program = this.decompileData.getProgram();
            String functionName = ft.getText();
            return new FunctionNameDecompilerLocation(program, entryPoint, functionName, info);
        }
        if (token instanceof ClangVariableToken) {
            ClangVariableToken cvt = (ClangVariableToken)token;
            return this.createVariableDeclarationLocation(cvt, address, info);
        }
        return null;
    }

    private ProgramLocation createVariableDeclarationLocation(ClangVariableToken cvt, Address address, DecompilerLocationInfo info) {
        Function function = this.decompileData.getFunction();
        Address entryPoint = function.getEntryPoint();
        Program program = this.decompileData.getProgram();
        Variable variable = this.getVariable(cvt);
        if (variable != null) {
            return new VariableDecompilerLocation(program, entryPoint, variable, info);
        }
        HighVariable highVar = cvt.getHighVariable();
        if (highVar == null) {
            return new FunctionNameDecompilerLocation(program, entryPoint, cvt.getText(), info);
        }
        HighSymbol highSymbol = highVar.getSymbol();
        if (highSymbol != null && highSymbol.isParameter()) {
            return new FunctionNameDecompilerLocation(program, entryPoint, cvt.getText(), info);
        }
        return null;
    }

    private Variable getVariable(ClangVariableToken token) {
        Variable[] locals;
        HighVariable highVar = token.getHighVariable();
        if (highVar == null) {
            return null;
        }
        HighSymbol highSymbol = highVar.getSymbol();
        if (highSymbol == null) {
            return null;
        }
        Variable variable = HighFunctionDBUtil.getFunctionVariable((HighSymbol)highSymbol);
        if (variable != null) {
            return variable;
        }
        Function function = this.decompileData.getFunction();
        Symbol symbol = highSymbol.getSymbol();
        for (Variable local : locals = function.getLocalVariables()) {
            Symbol localSymbol = local.getSymbol();
            if (symbol != localSymbol) continue;
            return local;
        }
        return null;
    }

    public void setSearchResults(SearchLocation searchLocation) {
        this.currentSearchLocation = searchLocation;
        this.repaint();
    }

    public DecompilerSearchLocation getSearchResults() {
        return (DecompilerSearchLocation)this.currentSearchLocation;
    }

    public Color getCurrentVariableHighlightColor() {
        return this.currentVariableHighlightColor;
    }

    public Color getMiddleMouseHighlightColor() {
        return this.middleMouseHighlightColor;
    }

    public Color getSpecialHighlightColor() {
        return SPECIAL_COLOR_DEF;
    }

    public String getHighlightedText() {
        ClangToken token = this.highlightController.getHighlightedToken();
        if (token == null) {
            return null;
        }
        if (token instanceof ClangCommentToken) {
            return null;
        }
        return token.getText();
    }

    public String getTextUnderCursor() {
        FieldLocation location = this.fieldPanel.getCursorLocation();
        ClangTextField textField = (ClangTextField)this.fieldPanel.getCurrentField();
        if (textField == null) {
            return null;
        }
        ClangToken token = textField.getToken(location);
        if (!(token instanceof ClangCommentToken)) {
            return token.getText();
        }
        FieldElement clickedElement = textField.getClickedObject(location);
        if (clickedElement instanceof AnnotatedTextFieldElement) {
            AnnotatedTextFieldElement annotation = (AnnotatedTextFieldElement)clickedElement;
            return annotation.getDisplayString();
        }
        String text = textField.getText();
        return StringUtilities.findWord((String)text, (int)location.col);
    }

    public String getSelectedText() {
        FieldSelection selection = this.fieldPanel.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return FieldSelectionHelper.getFieldSelectionText((FieldSelection)selection, (FieldPanel)this.fieldPanel);
    }

    public FieldLocation getCursorPosition() {
        return this.fieldPanel.getCursorLocation();
    }

    public void setCursorPosition(FieldLocation fieldLocation) {
        this.fieldPanel.setCursorPosition(fieldLocation.getIndex(), fieldLocation.getFieldNum(), fieldLocation.getRow(), fieldLocation.getCol());
        this.fieldPanel.scrollToCursor();
    }

    public ClangToken getSelectedToken() {
        FieldSelection selection = this.fieldPanel.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Field[] lines = this.layoutController.getFields();
        List<ClangToken> tokens = DecompilerUtils.getTokensInSelection(selection, lines);
        long count = tokens.stream().filter(t -> !t.getText().trim().isEmpty()).count();
        if (count == 1L) {
            return tokens.get(0);
        }
        return null;
    }

    public ClangToken getTokenAtCursor() {
        FieldLocation cursorPosition = this.fieldPanel.getCursorLocation();
        Field field = this.fieldPanel.getCurrentField();
        if (field == null) {
            return null;
        }
        return ((ClangTextField)field).getToken(cursorPosition);
    }

    public int getLineNumber(int y) {
        return this.pixmap.getIndex(y).intValue() + 1;
    }

    public DecompileOptions getOptions() {
        return this.options;
    }

    public void addHoverService(DecompilerHoverService hoverService) {
        this.decompilerHoverProvider.addHoverService(hoverService);
    }

    public void removeHoverService(DecompilerHoverService hoverService) {
        this.decompilerHoverProvider.removeHoverService(hoverService);
    }

    public void setHoverMode(boolean enabled) {
        this.decompilerHoverProvider.setHoverEnabled(enabled);
        if (enabled) {
            this.fieldPanel.setHoverProvider((HoverProvider)this.decompilerHoverProvider);
        } else {
            this.fieldPanel.setHoverProvider(null);
        }
    }

    public boolean isHoverShowing() {
        return this.decompilerHoverProvider.isShowing();
    }

    public List<ClangToken> findTokensByName(String name) {
        ArrayList<ClangToken> tokens = new ArrayList<ClangToken>();
        this.doFindTokensByName(tokens, this.layoutController.getRoot(), name);
        return tokens;
    }

    private void doFindTokensByName(List<ClangToken> tokens, ClangTokenGroup group, String name) {
        for (int i = 0; i < group.numChildren(); ++i) {
            ClangToken token;
            ClangNode child = group.Child(i);
            if (child instanceof ClangTokenGroup) {
                this.doFindTokensByName(tokens, (ClangTokenGroup)child, name);
                continue;
            }
            if (!(child instanceof ClangToken) || !name.equals((token = (ClangToken)child).getText())) continue;
            tokens.add(token);
        }
    }

    public ViewerPosition getViewerPosition() {
        return this.fieldPanel.getViewerPosition();
    }

    public void setViewerPosition(ViewerPosition viewerPosition) {
        this.fieldPanel.setViewerPosition(viewerPosition.getIndex(), viewerPosition.getXOffset(), viewerPosition.getYOffset());
    }

    @Override
    public void requestFocus() {
        this.fieldPanel.requestFocus();
    }

    public void selectAll(EventTrigger trigger) {
        BigInteger numIndexes = this.layoutController.getNumIndexes();
        FieldSelection selection = new FieldSelection();
        selection.addRange(BigInteger.ZERO, numIndexes);
        this.fieldPanel.setSelection(selection, trigger);
    }

    public void optionsChanged(DecompileOptions decompilerOptions) {
        this.setBackground(decompilerOptions.getBackgroundColor());
        this.currentVariableHighlightColor = this.options.getCurrentVariableHighlightColor();
        this.middleMouseHighlightColor = decompilerOptions.getMiddleMouseHighlightColor();
        this.middleMouseHighlightButton = decompilerOptions.getMiddleMouseHighlightButton();
        this.searchHighlightColor = decompilerOptions.getSearchHighlightColor();
        this.highlightController.setHighlightColor(this.currentVariableHighlightColor);
        if (this.options.isDisplayLineNumbers()) {
            if (this.lineNumbersMargin == null) {
                this.lineNumbersMargin = new LineNumberDecompilerMarginProvider();
                this.addMarginProvider(this.lineNumbersMargin);
            }
        } else if (this.lineNumbersMargin != null) {
            this.removeMarginProvider(this.lineNumbersMargin);
            this.lineNumbersMargin = null;
        }
        for (DecompilerMarginProvider element : this.marginProviders) {
            element.setOptions(this.options);
        }
    }

    public void addMarginProvider(DecompilerMarginProvider provider) {
        this.marginProviders.add(0, provider);
        provider.setOptions(this.options);
        provider.setProgram(this.getProgram(), this.layoutController, this.pixmap);
        this.buildPanels();
    }

    public void removeMarginProvider(DecompilerMarginProvider provider) {
        this.marginProviders.remove(provider);
        this.buildPanels();
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.fieldPanel.addFocusListener(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.fieldPanel.removeFocusListener(l);
    }

    private void buildPanels() {
        this.removeAll();
        this.add((Component)this.buildLeftComponent(), "West");
        this.add((Component)this.scroller, "Center");
        this.add((Component)this.taskMonitorComponent, "South");
    }

    private JComponent buildLeftComponent() {
        JPanel leftPanel = new JPanel((LayoutManager)new ScrollpaneAlignedHorizontalLayout(this.scroller));
        for (DecompilerMarginProvider marginProvider : this.marginProviders) {
            leftPanel.add(marginProvider.getComponent());
        }
        return leftPanel;
    }

    private class SearchHighlightFactory
    implements FieldHighlightFactory {
        private SearchHighlightFactory() {
        }

        public Highlight[] createHighlights(Field field, String text, int cursorTextOffset) {
            FieldLocation searchCursorLocation;
            int searchLineNumber;
            if (DecompilerPanel.this.currentSearchLocation == null) {
                return new Highlight[0];
            }
            ClangTextField cField = (ClangTextField)field;
            int highlightLine = cField.getLineNumber();
            if (highlightLine != (searchLineNumber = (searchCursorLocation = ((DecompilerSearchLocation)DecompilerPanel.this.currentSearchLocation).getFieldLocation()).getIndex().intValue() + 1)) {
                return new Highlight[0];
            }
            return new Highlight[]{new Highlight(DecompilerPanel.this.currentSearchLocation.getStartIndexInclusive(), DecompilerPanel.this.currentSearchLocation.getEndIndexInclusive(), DecompilerPanel.this.searchHighlightColor)};
        }
    }

    private class DecompilerFieldPanel
    extends FieldPanel {
        public DecompilerFieldPanel(LayoutModel model) {
            super(model, "Decompiler");
            this.setFieldDescriptionProvider((l, f) -> {
                if (f == null) {
                    return null;
                }
                return "line " + (l.getIndex().intValue() + 1);
            });
        }

        void navigateTo(int lineNumber, int column) {
            DecompilerPanel.this.fieldPanel.goTo(BigInteger.valueOf(lineNumber), 0, 0, column, false, EventTrigger.GUI_ACTION);
        }
    }

    private class ActiveMiddleMouse {
        private String tokenText;
        private DecompilerHighlighter highlighter;

        ActiveMiddleMouse(String tokenText) {
            this.tokenText = tokenText;
            MiddleMouseColorProvider cp = new MiddleMouseColorProvider();
            NameTokenMatcher matcher = new NameTokenMatcher(tokenText, cp);
            this.highlighter = DecompilerPanel.this.createHighlighter(matcher);
        }

        TokenHighlights getHighlights() {
            return DecompilerPanel.this.highlightController.getHighlighterHighlights(this.highlighter);
        }

        boolean matches(ClangToken other) {
            return this.tokenText.equals(other.getText());
        }

        void clear() {
            DecompilerPanel.this.highlightController.removeHighlighter(this.highlighter);
        }

        void apply() {
            DecompilerPanel.this.applySecondaryHighlights(this.highlighter);
        }

        public String toString() {
            return "Middle Mouse Token " + this.tokenText;
        }
    }

    private class ScrollingCallback
    implements SwingAnimationCallback {
        private int startLine;
        private int endLine;
        private int endColumn;
        private int duration;

        ScrollingCallback(FieldLocation start, int endLineNumber, int endColumn, int distance) {
            this.startLine = start.getIndex().intValue();
            this.endLine = endLineNumber;
            this.endColumn = endColumn;
            double rate = Math.pow(distance, 0.8);
            int ms = (int)rate * 100;
            this.duration = Math.min(1000, ms);
        }

        public int getDuration() {
            return this.duration;
        }

        public void progress(double percentComplete) {
            int length = Math.abs(this.endLine - this.startLine);
            long offset = Math.round((double)length * percentComplete);
            int current = 0;
            current = this.startLine > this.endLine ? (int)((long)this.startLine - offset) : (int)((long)this.startLine + offset);
            FieldLocation location = new FieldLocation(BigInteger.valueOf(current));
            DecompilerPanel.this.fieldPanel.scrollTo(location);
        }

        public void done() {
            DecompilerPanel.this.fieldPanel.goTo(BigInteger.valueOf(this.endLine), 0, 0, this.endColumn, false);
        }
    }

    private class PendingHighlightUpdate {
        private FieldLocation location;
        private Field field;
        private EventTrigger trigger;
        private long updateId;

        PendingHighlightUpdate(FieldLocation location, Field field, EventTrigger trigger) {
            this.location = location;
            this.field = field;
            this.trigger = trigger;
            this.updateId = DecompilerPanel.this.highlightController.getUpdateId();
        }

        void doUpdate() {
            long lastUpdateId = DecompilerPanel.this.highlightController.getUpdateId();
            if (this.updateId == lastUpdateId) {
                DecompilerPanel.this.highlightController.fieldLocationChanged(this.location, this.field, this.trigger);
            }
        }
    }

    private class MiddleMouseColorProvider
    implements ColorProvider {
        private MiddleMouseColorProvider() {
        }

        @Override
        public Color getColor(ClangToken token) {
            return DecompilerPanel.this.middleMouseHighlightColor;
        }

        public String toString() {
            return "Middle Mouse Color Provider " + String.valueOf(DecompilerPanel.this.middleMouseHighlightColor);
        }
    }
}

