/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.util.FillOutStructureCmd;
import ghidra.app.decompiler.util.FillOutStructureHelper;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;

public abstract class CreateStructureVariableAction
extends DockingAction {
    protected final DecompilerController controller;
    private final PluginTool tool;

    public CreateStructureVariableAction(String owner, PluginTool tool, DecompilerController controller) {
        super("Recover Structure Variable", owner);
        this.tool = tool;
        this.controller = controller;
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionAutoStructure"));
        this.setPopupMenuData(new MenuData(new String[]{"Auto Create Structure"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(91, 64));
    }

    public abstract boolean isEnabledForContext(ActionContext var1);

    protected void adjustCreateStructureMenuText(DataType dt, boolean isThisParam) {
        dt = FillOutStructureHelper.getStructureForExtending(dt);
        String menuString = "Auto Create Structure";
        if (dt != null) {
            menuString = isThisParam ? "Auto Fill in Class Structure" : "Auto Fill in Structure";
        } else if (isThisParam) {
            menuString = "Auto Create Class Structure";
        }
        this.getPopupMenuData().setMenuItemName(menuString);
    }

    public void actionPerformed(ActionContext context) {
        ProgramLocation location = null;
        Program program = null;
        if (context instanceof DecompilerActionContext) {
            DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
            if (decompilerActionContext.isDecompiling()) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
                return;
            }
            location = decompilerActionContext.getLocation();
            program = decompilerActionContext.getProgram();
        } else if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            location = listingContext.getLocation();
            program = listingContext.getProgram();
        } else {
            return;
        }
        DecompileOptions decompileOptions = DecompilerUtils.getDecompileOptions((ServiceProvider)this.tool, program);
        FillOutStructureCmd cmd = new FillOutStructureCmd(location, decompileOptions);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (DomainObject)program);
    }
}

