/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.error.LowlevelError;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import java.math.BigInteger;

public class MIPSEmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    private Register ismReg;
    private Register isaModeReg;
    private RegisterValue ISA_MODE0;
    private RegisterValue ISA_MODE1;

    public MIPSEmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.isaModeReg = this.language.getRegister("ISA_MODE");
        if (this.isaModeReg != null) {
            this.ismReg = this.language.getRegister("ISAModeSwitch");
            if (this.ismReg == null) {
                throw new RuntimeException("Expected ISA_VARIANT language " + String.valueOf(this.language.getLanguageID()) + " to have ISAModeSwitch register defined");
            }
            this.ISA_MODE1 = new RegisterValue(this.isaModeReg, BigInteger.ONE);
            this.ISA_MODE0 = new RegisterValue(this.isaModeReg, BigInteger.ZERO);
        }
    }

    public void initialExecuteCallback(Emulate emulate, Address current_address, RegisterValue contextRegisterValue) throws LowlevelError {
        if (this.ismReg == null) {
            return;
        }
        BigInteger isaModeValue = BigInteger.ZERO;
        if (contextRegisterValue != null) {
            isaModeValue = contextRegisterValue.getRegisterValue(this.isaModeReg).getUnsignedValueIgnoreMask();
        }
        if (!BigInteger.ZERO.equals(isaModeValue)) {
            isaModeValue = BigInteger.ONE;
        }
        this.emu.getMemoryState().setValue(this.ismReg, isaModeValue);
    }

    public void postExecuteCallback(Emulate emulate, Address lastExecuteAddress, PcodeOp[] lastExecutePcode, int lastPcodeIndex, Address currentAddress) throws LowlevelError {
        if (this.ismReg == null) {
            return;
        }
        if (lastPcodeIndex < 0) {
            return;
        }
        int lastOp = lastExecutePcode[lastPcodeIndex].getOpcode();
        if (lastOp != 4 && lastOp != 5 && lastOp != 6 && lastOp != 7 && lastOp != 8 && lastOp != 10) {
            return;
        }
        long tbValue = this.emu.getMemoryState().getValue(this.ismReg);
        if (tbValue == 1L) {
            this.emu.setContextRegisterValue(this.ISA_MODE1);
            if ((currentAddress.getOffset() & 1L) == 1L) {
                emulate.setExecuteAddress(currentAddress.previous());
            }
        } else {
            if ((currentAddress.getOffset() & 1L) == 1L) {
                throw new LowlevelError("Flow to odd address occurred without setting ISM register (16-bit mode)");
            }
            this.emu.setContextRegisterValue(this.ISA_MODE0);
        }
    }
}

