/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import generic.theme.Gui;
import generic.theme.ThemeManager;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Font;

public class ThemeFontOption
extends Option {
    private String fontId;

    public ThemeFontOption(String optionName, String fontId, String description, HelpLocation help) {
        super(optionName, OptionType.FONT_TYPE, description, help, null, true, null);
        this.fontId = fontId;
        if (!Gui.hasFont(fontId)) {
            Msg.warn((Object)this, (Object)("Registered a theme font option with a non-defined theme font id of \"" + fontId + "\""));
        }
    }

    @Override
    public Font getCurrentValue() {
        return Gui.getFont(this.fontId);
    }

    @Override
    public Object getDefaultValue() {
        return this.getCurrentValue();
    }

    @Override
    public void doSetCurrentValue(Object value) {
        ThemeManager.getInstance().setFont(this.fontId, (Font)value);
    }

    @Override
    public boolean isDefault() {
        return !ThemeManager.getInstance().isChangedFont(this.fontId);
    }

    @Override
    public void restoreDefault() {
        ThemeManager.getInstance().restoreFont(this.fontId);
    }
}

