/*
 * Decompiled with CFR 0.152.
 */
package ghidra.jython;

import docking.widgets.label.GDLabel;
import generic.theme.GColor;
import ghidra.app.plugin.core.console.CodeCompletion;
import ghidra.framework.options.Options;
import ghidra.jython.JythonPlugin;
import ghidra.util.Msg;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.python.core.PyInstance;
import org.python.core.PyObject;

public class JythonCodeCompletionFactory {
    private static List<Class<?>> classes = new ArrayList();
    private static Map<Class<?>, Color> classToColorMap = new HashMap();
    private static Map<String, Class<?>> simpleNameToClass = new HashMap();
    private static Map<Class<?>, String> classDescription = new HashMap();
    public static final String COMPLETION_LABEL = "Code Completion Colors";
    static final String INCLUDE_TYPES_LABEL = "Include type names in code completion popup?";
    private static final String INCLUDE_TYPES_DESCRIPTION = "Whether or not to include the type names (classes) of the possible completions in the code completion window.  The class name will be parenthesized after the completion.";
    private static final boolean INCLUDE_TYPES_DEFAULT = true;
    private static boolean includeTypes = true;
    public static final Color NULL_COLOR = new GColor("color.fg.plugin.jython.syntax.null");
    public static final Color FUNCTION_COLOR = new GColor("color.fg.plugin.jython.syntax.function");
    public static final Color PACKAGE_COLOR = new GColor("color.fg.plugin.jython.syntax.package");
    public static final Color CLASS_COLOR = new GColor("color.fg.plugin.jython.syntax.class");
    public static final Color METHOD_COLOR = new GColor("color.fg.plugin.jython.syntax.method");
    public static final Color CODE_COLOR = new GColor("color.fg.plugin.jython.syntax.code");
    public static final Color INSTANCE_COLOR = new GColor("color.fg.plugin.jython.syntax.instance");
    public static final Color SEQUENCE_COLOR = new GColor("color.fg.plugin.jython.syntax.sequence");
    public static final Color MAP_COLOR = new GColor("color.fg.plugin.jython.syntax.map");
    public static final Color NUMBER_COLOR = new GColor("color.fg.plugin.jython.syntax.number");
    public static final Color SPECIAL_COLOR = new GColor("color.fg.plugin.jython.syntax.special");

    private static String getSimpleName(Class<?> klass) {
        return JythonCodeCompletionFactory.getSimpleName(klass.getName());
    }

    private static String getSimpleName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static void setupClass(String className, Color defaultColor, String description) {
        try {
            Class<?> klass = Class.forName(className);
            classes.add(klass);
            classToColorMap.put(klass, defaultColor);
            simpleNameToClass.put(JythonCodeCompletionFactory.getSimpleName(klass), klass);
            classDescription.put(klass, description);
        }
        catch (ClassNotFoundException cnfe) {
            Msg.debug(JythonCodeCompletionFactory.class, (Object)("Unable to find class: " + className), (Throwable)cnfe);
        }
    }

    @Deprecated
    public static CodeCompletion newCodeCompletion(String description, String insertion, PyObject pyObj) {
        return JythonCodeCompletionFactory.newCodeCompletion(description, insertion, pyObj, "");
    }

    public static CodeCompletion newCodeCompletion(String description, String insertion, PyObject pyObj, String userInput) {
        GDLabel comp = null;
        if (pyObj != null) {
            if (includeTypes) {
                String className = JythonCodeCompletionFactory.getSimpleName(pyObj.getClass());
                if (pyObj instanceof PyInstance) {
                    className = JythonCodeCompletionFactory.getSimpleName(((PyInstance)pyObj).instclass.__name__);
                } else if (className.startsWith("Py")) {
                    className = className.substring("Py".length());
                }
                description = (String)description + " (" + className + ")";
            }
            comp = new GDLabel((String)description);
            for (Class<?> testClass : classes) {
                if (!testClass.isInstance(pyObj)) continue;
                comp.setForeground(classToColorMap.get(testClass));
                break;
            }
        }
        int charsToRemove = userInput.length();
        return new CodeCompletion((String)description, insertion, (JComponent)comp, charsToRemove);
    }

    public static void setupOptions(JythonPlugin plugin, Options options) {
        includeTypes = options.getBoolean(INCLUDE_TYPES_LABEL, true);
        options.registerOption(INCLUDE_TYPES_LABEL, (Object)true, null, INCLUDE_TYPES_DESCRIPTION);
    }

    public static void changeOptions(Options options, String name, Object oldValue, Object newValue) {
        if (name.equals(INCLUDE_TYPES_LABEL)) {
            includeTypes = (Boolean)newValue;
        } else {
            Msg.error(JythonCodeCompletionFactory.class, (Object)("unknown option '" + name + "'"));
        }
    }

    public static Object[] getCallMethods(PyObject obj) {
        Method[] declaredMethods;
        ArrayList<Method> callMethodList = new ArrayList<Method>();
        for (Method declaredMethod : declaredMethods = obj.getClass().getDeclaredMethods()) {
            if (!declaredMethod.getName().equals("__call__")) continue;
            callMethodList.add(declaredMethod);
        }
        return callMethodList.toArray();
    }

    static {
        JythonCodeCompletionFactory.setupClass("org.python.core.PyNone", NULL_COLOR, "'None' (null) Objects");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyReflectedFunction", FUNCTION_COLOR, "Python functions written in Java");
        JythonCodeCompletionFactory.setupClass("org.python.core.__builtin__", FUNCTION_COLOR, "Python's built-in functions collection (note that many are re-implemented in Java)");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyFunction", FUNCTION_COLOR, "functions written in Python");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyMethodDescr", FUNCTION_COLOR, "unbound Python builtin instance methods (they take an Object as the first argument)");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyJavaPackage", PACKAGE_COLOR, "Java packages");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyModule", PACKAGE_COLOR, "Python modules");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyJavaType", CLASS_COLOR, "Java classes");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyClass", CLASS_COLOR, "Python classes");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyType", CLASS_COLOR, "core Python types");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyMethod", METHOD_COLOR, "methods");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyBuiltinFunction", METHOD_COLOR, "core Python methods, often inherited from Python's Object (overriding these methods is very powerful)");
        JythonCodeCompletionFactory.setupClass("org.python.core.PySequence", SEQUENCE_COLOR, "iterable sequences, including arrays, list, and strings");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyDictionary", MAP_COLOR, "arbitrary Python mapping type");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyStringMap", MAP_COLOR, "Python String->Object mapping type");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyInteger", NUMBER_COLOR, "integers");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyLong", NUMBER_COLOR, "long integers");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyFloat", NUMBER_COLOR, "floating-point (decimal) numbers");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyComplex", NUMBER_COLOR, "complex numbers");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyCompoundCallable", SPECIAL_COLOR, "special Python properties for assigning Python functions as EventListeners on Java objects");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyObjectDerived", INSTANCE_COLOR, "Java Objects");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyInstance", INSTANCE_COLOR, "Python Objects");
        JythonCodeCompletionFactory.setupClass("org.python.core.PyCode", CODE_COLOR, "chunks of Python code");
    }
}

