/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledList;
import ghidra.app.util.demangler.DemangledParameter;
import ghidra.app.util.demangler.swift.SwiftDemangledNodeKind;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftDataTypeUtils;
import ghidra.app.util.demangler.swift.datatypes.SwiftFunction;
import ghidra.app.util.demangler.swift.datatypes.SwiftTuple;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftFunctionTypeNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        DemangledList list;
        Demangled argumentTuple = null;
        Demangled returnType = null;
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case ArgumentTuple: {
                    argumentTuple = child.demangle(demangler);
                    continue block4;
                }
                case ReturnType: {
                    returnType = child.demangle(demangler);
                    continue block4;
                }
            }
            this.skip(child);
        }
        SwiftFunction function = new SwiftFunction(this.properties.mangled(), this.properties.originalDemangled(), "<unknown>", null, "default");
        function.addParameters(SwiftDataTypeUtils.extractParameters(argumentTuple));
        SwiftNode functionAncestor = this.getFirstAncestor(SwiftDemangledNodeKind.Function, SwiftDemangledNodeKind.Getter);
        if (functionAncestor != null) {
            Demangled demangled;
            if (functionAncestor.getKind().equals((Object)SwiftDemangledNodeKind.Getter)) {
                functionAncestor = functionAncestor.getChildren().get(0);
            }
            SwiftNode struct = functionAncestor.getChild(SwiftDemangledNodeKind.Structure);
            SwiftNode enumm = functionAncestor.getChild(SwiftDemangledNodeKind.Enum);
            if (struct != null) {
                Demangled demangled2 = struct.demangle(demangler);
                if (demangled2 instanceof DemangledDataType) {
                    type = (DemangledDataType)demangled2;
                    function.addParameter(new DemangledParameter(type));
                }
            } else if (enumm != null && (demangled = enumm.demangle(demangler)) instanceof DemangledDataType) {
                type = (DemangledDataType)demangled;
                function.addParameter(new DemangledParameter(type));
                DemangledDataType varargs = new DemangledDataType(this.properties.mangled(), this.properties.originalDemangled(), "undefined");
                varargs.setVarArgs();
                function.addParameter(new DemangledParameter(varargs));
            }
        }
        if (returnType instanceof DemangledDataType) {
            DemangledDataType type = (DemangledDataType)returnType;
            function.setReturnType(type);
        } else if (returnType instanceof DemangledList && (list = (DemangledList)returnType).size() > 0) {
            if (list.containsNull()) {
                DemangledDataType dt = new DemangledDataType(this.properties.mangled(), this.properties.originalDemangled(), "undefined");
                dt.incrementPointerLevels();
                function.setReturnType(dt);
            } else {
                SwiftTuple tuple = new SwiftTuple(this.properties.mangled(), this.properties.originalDemangled(), list, demangler);
                function.setReturnType((DemangledDataType)tuple);
            }
        }
        return function;
    }
}

