/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.breakpoint.DBTraceObjectBreakpointLocation;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class DBTraceObjectBreakpointSpec
implements TraceObjectBreakpointSpec,
DBTraceObjectInterface {
    private static final Map<TraceObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TraceObjectSchema, Set<String>>();
    private final DBTraceObject object;
    private final Set<String> keys;
    private TraceBreakpointKind.TraceBreakpointKindSet kinds = TraceBreakpointKind.TraceBreakpointKindSet.of(new TraceBreakpointKind[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTraceObjectBreakpointSpec(DBTraceObject object) {
        this.object = object;
        TraceObjectSchema schema = object.getSchema();
        Map<TraceObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
        synchronized (map) {
            this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(schema.checkAliasedAttribute("_kinds"), schema.checkAliasedAttribute("_enabled")));
        }
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(long snap, String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(Lifespan.nowOn(snap), "_display", name);
        }
    }

    @Override
    public String getName(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_display", String.class, "");
    }

    @Override
    public AddressRange getRange(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public Address getMinAddress(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public Address getMaxAddress(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public long getLength(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void setEnabled(long snap, boolean enabled) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(Lifespan.nowOn(snap), "_enabled", enabled ? Boolean.valueOf(true) : null);
        }
    }

    @Override
    public boolean isEnabled(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_enabled", Boolean.class, false);
    }

    @Override
    public void setKinds(Lifespan lifespan, Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_kinds", TraceBreakpointKind.TraceBreakpointKindSet.encode(kinds));
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.copyOf(kinds);
        }
    }

    @Override
    public void setKinds(long snap, Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setKinds(Lifespan.nowOn(snap), kinds);
        }
    }

    @Override
    public Set<TraceBreakpointKind> getKinds(long snap) {
        String kindsStr = TraceObjectInterfaceUtils.getValue(this.object, snap, "_kinds", String.class, null);
        if (kindsStr == null) {
            return this.kinds;
        }
        try {
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.decode(kindsStr, true);
            return this.kinds;
        }
        catch (IllegalArgumentException e) {
            Msg.warn((Object)this, (Object)("Unrecognized breakpoint kind(s) in trace database: " + String.valueOf(e)));
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.decode(kindsStr, false);
            return this.kinds;
        }
    }

    @Override
    public String getExpression(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_expression", String.class, null);
    }

    @Override
    public Set<TraceThread> getThreads(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void setComment(long snap, String comment) {
        throw new UnsupportedOperationException("Set on a location instead");
    }

    @Override
    public String getComment(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void setEmuEnabled(long snap, boolean enabled) {
        throw new UnsupportedOperationException("Set on a location instead");
    }

    @Override
    public boolean isEmuEnabled(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void setEmuSleigh(long snap, String sleigh) {
        throw new UnsupportedOperationException("Set on a location instead");
    }

    @Override
    public String getEmuSleigh(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.ALL);
        }
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.nowOn(snap));
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.isAlive(snap);
    }

    @Override
    public boolean isAlive(Lifespan span) {
        return this.object.isAlive(span);
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    protected Collection<? extends TraceObjectBreakpointLocation> getLocations(Lifespan span) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Collection collection = this.object.querySuccessorsInterface(span, TraceObjectBreakpointLocation.class, true).collect(Collectors.toSet());
            return collection;
        }
    }

    @Override
    public Collection<? extends TraceObjectBreakpointLocation> getLocations(long snap) {
        return this.getLocations(Lifespan.at(snap));
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        if (rec.getEventType() == TraceEvents.VALUE_CREATED) {
            TraceChangeRecord cast = TraceEvents.VALUE_CREATED.cast(rec);
            TraceObjectValue affected = (TraceObjectValue)cast.getAffectedObject();
            String key = affected.getEntryKey();
            boolean applies = this.keys.contains(key);
            if (!applies) {
                return null;
            }
            assert (affected.getParent() == this.object);
            if (this.object.getCanonicalParent(affected.getMaxSnap()) == null) {
                return null;
            }
            for (TraceObjectBreakpointLocation traceObjectBreakpointLocation : this.getLocations(affected.getLifespan())) {
                DBTraceObjectBreakpointLocation dbLoc = (DBTraceObjectBreakpointLocation)traceObjectBreakpointLocation;
                TraceAddressSpace space = dbLoc.getTraceAddressSpace(affected.getMinSnap());
                TraceChangeRecord<TraceObjectBreakpointLocation, Object> evt = new TraceChangeRecord<TraceObjectBreakpointLocation, Object>(TraceEvents.BREAKPOINT_CHANGED, space, traceObjectBreakpointLocation, null, null);
                this.object.getTrace().setChanged(evt);
            }
            return null;
        }
        return null;
    }
}

