/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.AbstractDBTraceProgramViewMemoryBlock;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpaceInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import javax.help.UnsupportedOperationException;

public class DBTraceProgramViewMemoryRegionBlock
extends AbstractDBTraceProgramViewMemoryBlock {
    private final TraceMemoryRegion region;
    private final long snap;

    public DBTraceProgramViewMemoryRegionBlock(DBTraceProgramView program, TraceMemoryRegion region, long snap) {
        super(program);
        this.region = region;
        this.snap = snap;
    }

    @Override
    protected String getInfoDescription() {
        return "Trace region: " + String.valueOf(this.region);
    }

    @Override
    protected AddressSpace getAddressSpace() {
        return this.region.getRange(this.snap).getAddressSpace();
    }

    @Override
    public AddressRange getAddressRange() {
        return this.region.getRange(this.snap);
    }

    protected void checkSnapOnSet() {
        long snap = this.program.getSnap();
        if (snap != this.snap) {
            throw new UnsupportedOperationException("Region is from a forked snapshot");
        }
    }

    public void setPermissions(boolean read, boolean write, boolean execute) {
        this.checkSnapOnSet();
        this.region.setRead(this.snap, read);
        this.region.setWrite(this.snap, write);
        this.region.setExecute(this.snap, execute);
    }

    public int getFlags() {
        int bits = 0;
        for (TraceMemoryFlag flag : this.region.getFlags(this.snap)) {
            bits |= flag.getBits();
        }
        return bits;
    }

    @Override
    public InputStream getData() {
        AddressRange range = this.region.getRange(this.snap);
        DBTraceMemorySpace space = this.program.trace.getMemoryManager().getMemorySpace(range.getAddressSpace(), false);
        if (space == null) {
            return null;
        }
        return new TraceMemorySpaceInputStream(this.program, space, range);
    }

    public Address getStart() {
        return this.region.getRange(this.snap).getMinAddress();
    }

    public Address getEnd() {
        return this.region.getRange(this.snap).getMaxAddress();
    }

    @Override
    public long getSize() {
        return this.region.getRange(this.snap).getLength();
    }

    @Override
    public BigInteger getSizeAsBigInteger() {
        return this.region.getRange(this.snap).getBigLength();
    }

    public String getName() {
        return this.region.getName(this.snap);
    }

    public void setName(String name) throws LockException {
        this.checkSnapOnSet();
        this.region.setName(this.snap, name);
    }

    public boolean isRead() {
        return this.region.isRead(this.snap);
    }

    public void setRead(boolean r) {
        this.checkSnapOnSet();
        this.region.setRead(this.snap, r);
    }

    public boolean isWrite() {
        return this.region.isWrite(this.snap);
    }

    public void setWrite(boolean w) {
        this.checkSnapOnSet();
        this.region.setWrite(this.snap, w);
    }

    public boolean isExecute() {
        return this.region.isExecute(this.snap);
    }

    public void setExecute(boolean e) {
        this.checkSnapOnSet();
        this.region.setExecute(this.snap, e);
    }

    public boolean isVolatile() {
        return this.region.isVolatile(this.snap);
    }

    public void setVolatile(boolean v) {
        this.checkSnapOnSet();
        this.region.setVolatile(this.snap, v);
    }

    public boolean isArtificial() {
        return false;
    }

    public void setArtificial(boolean a) {
        throw new UnsupportedOperationException();
    }
}

