/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.plugin.core.analysis.eBPFHelperDataTypes;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class eBPFSyscallAnalyzer
extends AbstractAnalyzer {
    private static final String PROCESSOR_NAME = "eBPF";
    private static final String SYSCALL_ADDRSPACE_NAME = "syscall";
    private static final String NAME = "eBPF Syscall Functions";
    private static final String DESCRIPTION = "Apply eBPF syscall Functions";

    public eBPFSyscallAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setPriority(AnalysisPriority.FUNCTION_ID_ANALYSIS.before());
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return PROCESSOR_NAME.equals(program.getLanguage().getProcessor().toString());
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AddressSpace syscallSpace = program.getAddressFactory().getAddressSpace(SYSCALL_ADDRSPACE_NAME);
        AddressSet syscallSet = set.intersectRange(syscallSpace.getMinAddress(), syscallSpace.getMaxAddress());
        if (syscallSet.isEmpty()) {
            return true;
        }
        BookmarkManager bookmarkMgr = program.getBookmarkManager();
        bookmarkMgr.removeBookmarks((AddressSetView)syscallSet, "Error", monitor);
        eBPFHelperDataTypes helperDataTypes = eBPFHelperDataTypes.get(program, log);
        if (helperDataTypes == null) {
            return false;
        }
        for (Function f : program.getFunctionManager().getFunctions((AddressSetView)syscallSet, true)) {
            monitor.checkCancelled();
            if (f.getSymbol().getSource() != SourceType.DEFAULT) continue;
            this.applySyscallSignature(f, helperDataTypes);
        }
        return true;
    }

    private void applySyscallSignature(Function func, eBPFHelperDataTypes helperDataTypes) {
        Program program = func.getProgram();
        int helperId = (int)func.getEntryPoint().getOffset();
        FunctionDefinition helperDef = helperDataTypes.getHelperFunctionDef(helperId);
        if (helperDef == null) {
            try {
                func.setName("bpf_undef_0x" + Integer.toHexString(helperId), SourceType.ANALYSIS);
            }
            catch (DuplicateNameException | InvalidInputException throwable) {}
        } else {
            ApplyFunctionSignatureCmd cmd = new ApplyFunctionSignatureCmd(func.getEntryPoint(), (FunctionSignature)helperDef, SourceType.ANALYSIS);
            cmd.applyTo((DomainObject)program);
        }
    }
}

