/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.Option;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeaderType;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ARM_ElfExtension
extends ElfExtension {
    public static final String APPLY_PC_BIAS_TO_RELATIVE_RELOCATIONS_OPTION_NAME = "Apply PC Bias to relative relocations";
    public static final boolean APPLY_PC_BIAS_TO_RELATIVE_RELOCATIONS_DEFAULT = false;
    public static final ElfProgramHeaderType PT_ARM_EXIDX = new ElfProgramHeaderType(0x70000000, "PT_ARM_EXIDX", "Frame unwind information");
    public static final ElfSectionHeaderType SHT_ARM_EXIDX = new ElfSectionHeaderType(0x70000001, "SHT_ARM_EXIDX", "Exception Index table");
    public static final ElfSectionHeaderType SHT_ARM_PREEMPTMAP = new ElfSectionHeaderType(0x70000002, "SHT_ARM_PREEMPTMAP", "BPABI DLL dynamic linking preemption map");
    public static final ElfSectionHeaderType SHT_ARM_ATTRIBUTES = new ElfSectionHeaderType(0x70000003, "SHT_ARM_ATTRIBUTES", "Object file compatibility attributes");
    public static final ElfSectionHeaderType SHT_ARM_DEBUGOVERLAY = new ElfSectionHeaderType(0x70000004, "SHT_ARM_DEBUGOVERLAY", "See DBGOVL for details");
    public static final ElfSectionHeaderType SHT_ARM_OVERLAYSECTION = new ElfSectionHeaderType(0x70000005, "SHT_ARM_OVERLAYSECTION", "See Debugging Overlaid Programs (DBGOVL) for details");

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 40;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "ARM".equals(language.getProcessor().toString());
    }

    public String getDataTypeSuffix() {
        return "_ARM";
    }

    public void addLoadOptions(ElfHeader elf, List<Option> options) {
        boolean enablePcBiasOption = false;
        try {
            elf.parse();
            ElfSectionHeader section = elf.getSection(".ghsinfo");
            if (section != null) {
                enablePcBiasOption = true;
            }
        }
        catch (IOException e) {
            Msg.warn((Object)((Object)this), (Object)"Failed to fully parse ELF headers to formulate ARM import options");
        }
        options.add(new Option(APPLY_PC_BIAS_TO_RELATIVE_RELOCATIONS_OPTION_NAME, (Object)enablePcBiasOption, Boolean.class, "-loader-applyArmElfRelocPCBias"));
    }

    public void processElf(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        Register tmodeRegister = elfLoadHelper.getProgram().getRegister("TMode");
        if (tmodeRegister == null) {
            elfLoadHelper.log("WARNING: TMode register not found - Thumb mode not supported");
        }
    }

    public Address creatingFunction(ElfLoadHelper elfLoadHelper, Address functionAddress) {
        Program program = elfLoadHelper.getProgram();
        if ((functionAddress.getOffset() & 1L) != 0L) {
            Register tmodeRegister = program.getRegister("TMode");
            if (tmodeRegister == null) {
                elfLoadHelper.log("TMode mode not supported, unable to mark address as Thumb: " + String.valueOf(functionAddress));
                return functionAddress;
            }
            functionAddress = functionAddress.previous();
            try {
                program.getProgramContext().setValue(tmodeRegister, functionAddress, functionAddress, BigInteger.ONE);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
        if (functionAddress.getOffset() % 4L == 2L) {
            elfLoadHelper.log("Function address is two bit aligned (reserved per ARM manual): " + String.valueOf(functionAddress));
        }
        return functionAddress;
    }

    public Address evaluateElfSymbol(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address, boolean isExternal) {
        if (isExternal) {
            return address;
        }
        Program program = elfLoadHelper.getProgram();
        String symName = elfSymbol.getNameAsString();
        if (StringUtils.isBlank((CharSequence)symName)) {
            return address;
        }
        try {
            long symVal;
            Register tmodeRegister = program.getRegister("TMode");
            if (tmodeRegister != null) {
                if ("$t".equals(symName) || symName.startsWith("$t.")) {
                    program.getProgramContext().setValue(tmodeRegister, address, address, BigInteger.valueOf(1L));
                    elfLoadHelper.markAsCode(address);
                    elfLoadHelper.setElfSymbolAddress(elfSymbol, address);
                    return null;
                }
                if ("$a".equals(symName) || symName.startsWith("$a.")) {
                    program.getProgramContext().setValue(tmodeRegister, address, address, BigInteger.valueOf(0L));
                    elfLoadHelper.markAsCode(address);
                    elfLoadHelper.setElfSymbolAddress(elfSymbol, address);
                    return null;
                }
                if (!"$b".equals(symName) && ("$d".equals(symName) || symName.startsWith("$d."))) {
                    elfLoadHelper.createUndefinedData(address, (int)elfSymbol.getSize());
                    elfLoadHelper.setElfSymbolAddress(elfSymbol, address);
                    return null;
                }
            }
            if (elfSymbol.getType() == 2 && ((symVal = address.getOffset()) & 1L) != 0L && tmodeRegister != null) {
                address = address.previous();
                program.getProgramContext().setValue(tmodeRegister, address, address, BigInteger.valueOf(1L));
            }
        }
        catch (ContextChangeException contextChangeException) {
            // empty catch block
        }
        return address;
    }
}

