/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.grammars;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;

public abstract class AbstractAssemblyProduction<NT extends AssemblyNonTerminal>
implements Comparable<AbstractAssemblyProduction<NT>> {
    private final NT lhs;
    private final AssemblySentential<NT> rhs;
    int idx = -1;

    public AbstractAssemblyProduction(NT lhs, AssemblySentential<NT> rhs) {
        rhs.finish();
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public int getIndex() {
        return this.idx;
    }

    public NT getLHS() {
        return this.lhs;
    }

    public AssemblySentential<NT> getRHS() {
        return this.rhs;
    }

    public String toString() {
        String result = this.idx + ". " + String.valueOf(this.lhs) + " => " + String.valueOf(this.rhs);
        return result;
    }

    public boolean equals(Object that) {
        if (!(that instanceof AbstractAssemblyProduction)) {
            return false;
        }
        AbstractAssemblyProduction aap = (AbstractAssemblyProduction)that;
        if (!((AssemblySymbol)this.lhs).equals(aap.lhs)) {
            return false;
        }
        return this.rhs.equals(aap.rhs);
    }

    @Override
    public int compareTo(AbstractAssemblyProduction<NT> that) {
        int result = ((AssemblySymbol)this.lhs).compareTo((AssemblySymbol)that.lhs);
        if (result != 0) {
            return result;
        }
        result = this.rhs.compareTo(that.rhs);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public int hashCode() {
        int result = 0;
        result += ((AssemblySymbol)this.lhs).hashCode();
        result *= 31;
        return result += this.rhs.hashCode();
    }

    public String getName() {
        return ((AssemblySymbol)this.lhs).getName();
    }
}

