/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.ContextSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.EndSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.EpsilonSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.NameSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Next2Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.StartSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolScope;
import ghidra.app.plugin.processors.sleigh.symbol.UseropSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.ValueMapSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeListSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;

public class SymbolTable {
    private Symbol[] symbollist;
    private UseropSymbol[] userOps;
    private SymbolScope[] table;
    private SymbolScope curscope = null;

    private SymbolScope skipScope(int i) {
        SymbolScope res = this.curscope;
        while (i > 0) {
            if (res.getParent() == null) {
                return res;
            }
            res = res.getParent();
            --i;
        }
        return res;
    }

    private Symbol findSymbolInternal(SymbolScope scope, String nm) {
        while (scope != null) {
            Symbol res = scope.findSymbol(nm);
            if (res != null) {
                return res;
            }
            scope = scope.getParent();
        }
        return null;
    }

    public SymbolScope getCurrentScope() {
        return this.curscope;
    }

    public SymbolScope getGlobalScope() {
        return this.table[0];
    }

    public void setCurrentScope(SymbolScope scope) {
        this.curscope = scope;
    }

    public Symbol findSymbol(String nm) {
        return this.findSymbolInternal(this.curscope, nm);
    }

    public Symbol findSymbol(String nm, int skip) {
        return this.findSymbolInternal(this.skipScope(skip), nm);
    }

    public Symbol findGlobalSymbol(String nm) {
        return this.findSymbolInternal(this.table[0], nm);
    }

    public Symbol[] getSymbolList() {
        return this.symbollist;
    }

    public Symbol findSymbol(int id) {
        return this.symbollist[id];
    }

    public void decode(Decoder decoder, SleighLanguage sleigh) throws DecoderException {
        int i;
        int el = decoder.openElement(SlaFormat.ELEM_SYMBOL_TABLE);
        int scopesize = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_SCOPESIZE);
        this.table = new SymbolScope[scopesize];
        int symsize = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_SYMBOLSIZE);
        this.symbollist = new Symbol[symsize];
        for (i = 0; i < scopesize; ++i) {
            int subel = decoder.openElement(SlaFormat.ELEM_SCOPE);
            int id = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_ID);
            int parent = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_PARENT);
            SymbolScope sscope = parent == id ? null : this.table[parent];
            this.table[id] = new SymbolScope(sscope, id);
            decoder.closeElement(subel);
        }
        this.curscope = this.table[0];
        for (i = 0; i < symsize; ++i) {
            this.decodeSymbolHeader(decoder);
        }
        ArrayList<UseropSymbol> userops = new ArrayList<UseropSymbol>();
        while (decoder.peekElement() != 0) {
            decoder.openElement();
            int id = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_ID);
            Symbol sym = this.findSymbol(id);
            sym.decode(decoder, sleigh);
            if (!(sym instanceof UseropSymbol)) continue;
            userops.add((UseropSymbol)sym);
        }
        this.userOps = new UseropSymbol[userops.size()];
        userops.toArray(this.userOps);
        decoder.closeElement(el);
    }

    public void decodeSymbolHeader(Decoder decoder) throws DecoderException {
        Symbol sym;
        int el = decoder.peekElement();
        if (el == SlaFormat.ELEM_USEROP_HEAD.id()) {
            sym = new UseropSymbol();
        } else if (el == SlaFormat.ELEM_EPSILON_SYM_HEAD.id()) {
            sym = new EpsilonSymbol();
        } else if (el == SlaFormat.ELEM_VALUE_SYM_HEAD.id()) {
            sym = new ValueSymbol();
        } else if (el == SlaFormat.ELEM_VALUEMAP_SYM_HEAD.id()) {
            sym = new ValueMapSymbol();
        } else if (el == SlaFormat.ELEM_NAME_SYM_HEAD.id()) {
            sym = new NameSymbol();
        } else if (el == SlaFormat.ELEM_VARNODE_SYM_HEAD.id()) {
            sym = new VarnodeSymbol();
        } else if (el == SlaFormat.ELEM_CONTEXT_SYM_HEAD.id()) {
            sym = new ContextSymbol();
        } else if (el == SlaFormat.ELEM_VARLIST_SYM_HEAD.id()) {
            sym = new VarnodeListSymbol();
        } else if (el == SlaFormat.ELEM_OPERAND_SYM_HEAD.id()) {
            sym = new OperandSymbol();
        } else if (el == SlaFormat.ELEM_START_SYM_HEAD.id()) {
            sym = new StartSymbol();
        } else if (el == SlaFormat.ELEM_END_SYM_HEAD.id()) {
            sym = new EndSymbol();
        } else if (el == SlaFormat.ELEM_NEXT2_SYM_HEAD.id()) {
            sym = new Next2Symbol();
        } else if (el == SlaFormat.ELEM_SUBTABLE_SYM_HEAD.id()) {
            sym = new SubtableSymbol();
        } else {
            throw new SleighException("Bad symbol encoding");
        }
        sym.decodeHeader(decoder);
        this.symbollist[sym.getId()] = sym;
        this.table[sym.getScopeId()].addSymbol(sym);
    }

    public int getNumberOfUserDefinedOpNames() {
        return this.userOps.length;
    }

    public String getUserDefinedOpName(int index) {
        if (index < this.userOps.length) {
            return this.userOps[index].getName();
        }
        return null;
    }
}

