/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class ConstantValue
extends PatternValue {
    long val;

    public ConstantValue(Location location) {
        super(location);
    }

    public ConstantValue(Location location, long v) {
        super(location);
        this.val = v;
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return new TokenPattern(this.location);
    }

    @Override
    public TokenPattern genPattern(long v) {
        return new TokenPattern(this.location, this.val == v);
    }

    @Override
    public long minValue() {
        return this.val;
    }

    @Override
    public long maxValue() {
        return this.val;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_INTB);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_VAL, this.val);
        encoder.closeElement(SlaFormat.ELEM_INTB);
    }
}

