/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.space;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;
import java.io.PrintStream;

public class AddrSpace {
    public static final AddrSpace MIN_SPACE = new AddrSpace("MIN_SPACE", -1);
    public static final AddrSpace MAX_SPACE = new AddrSpace("MAX_SPACE", Integer.MAX_VALUE);
    protected static final int big_endian = 1;
    protected static final int heritaged = 2;
    protected static final int does_deadcode = 4;
    protected static final int programspecific = 8;
    protected static final int reverse_justification = 16;
    protected static final int overlay = 32;
    protected static final int overlaybase = 64;
    protected static final int truncated = 128;
    public static final int hasphysical = 256;
    protected static final int is_otherspace = 512;
    private int flags;
    private long highest;
    private long mask;
    private Translate trans;
    private String name;
    private spacetype type;
    private int addressSize;
    private int wordsize;
    private int scale;
    private char shortcut;
    private int index;
    private int delay;

    protected AddrSpace(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public AddrSpace(Translate t, spacetype tp, String nm, int size, int ws, int ind, int fl, int dl) {
        this.trans = t;
        this.type = tp;
        this.name = nm;
        this.addressSize = size;
        this.wordsize = ws;
        this.index = ind;
        this.delay = dl;
        this.flags = fl & 0x100;
        if (t.isBigEndian()) {
            this.flags |= 1;
        }
        this.flags |= 2;
        this.calcScaleMask();
    }

    public AddrSpace(Translate t, spacetype tp) {
        this.trans = t;
        this.type = tp;
        this.flags = 2;
        this.wordsize = 1;
        this.scale = 0;
    }

    public long wrapOffset(long off) {
        if ((int)(-Math.pow(-5.0, 3.0)) % 2 == 1) {
            throw new RuntimeException("wrapOffset coded incorrectly");
        }
        if (off <= this.highest) {
            return off;
        }
        long mod = this.highest + 1L;
        long res = off % mod;
        if (res < 0L) {
            res += mod;
        }
        return res;
    }

    protected void setFlags(int fl) {
        this.flags |= fl;
    }

    protected void clearFlags(int fl) {
        this.flags &= ~fl;
    }

    public String getName() {
        return this.name;
    }

    public Translate getTrans() {
        return this.trans;
    }

    public spacetype getType() {
        return this.type;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getIndex() {
        return this.index;
    }

    public int getWordSize() {
        return this.wordsize;
    }

    public int getScale() {
        return this.scale;
    }

    public int getAddrSize() {
        return this.addressSize;
    }

    public long getMask() {
        return this.mask;
    }

    public char getShortCut() {
        return this.shortcut;
    }

    public boolean isHeritaged() {
        return (this.flags & 2) != 0;
    }

    public boolean hasPhysical() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isBigEndian() {
        return (this.flags & 1) != 0;
    }

    public boolean isOtherSpace() {
        return (this.flags & 0x200) != 0;
    }

    public AddrSpace getContain() {
        return null;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int compareTo(AddrSpace base) {
        return this.index - base.index;
    }

    private void calcScaleMask() {
        this.scale = 0;
        for (int wd = this.wordsize; wd > 1; wd >>= 1) {
            ++this.scale;
        }
        this.mask = Utils.calc_mask(this.addressSize);
        for (int i = 1; i < this.wordsize; ++i) {
            this.mask = this.mask << 1 | 1L;
        }
        this.shortcut = this.trans.assignShortcut(this.type);
    }

    void encode_basic_attributes(Encoder encoder) throws IOException {
        encoder.writeString(SlaFormat.ATTRIB_NAME, this.name);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_INDEX, this.index);
        encoder.writeBool(SlaFormat.ATTRIB_BIGENDIAN, this.isBigEndian());
        encoder.writeSignedInteger(SlaFormat.ATTRIB_DELAY, this.delay);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_SIZE, this.addressSize);
        if (this.wordsize > 1) {
            encoder.writeSignedInteger(SlaFormat.ATTRIB_WORDSIZE, this.wordsize);
        }
        encoder.writeBool(SlaFormat.ATTRIB_PHYSICAL, this.hasPhysical());
    }

    public boolean contain(AddrSpace id2) {
        while (this != id2) {
            if ((id2 = id2.getContain()) != null) continue;
            return false;
        }
        return true;
    }

    long data2uintm(byte[] ptr, int size) {
        long res;
        if ((this.flags & 1) != 0) {
            res = 0L;
            for (int i = 0; i < size; ++i) {
                res <<= 8;
                res |= (long)ptr[i];
            }
        } else {
            res = 0L;
            for (int i = size - 1; i >= 0; --i) {
                res <<= 8;
                res |= (long)ptr[i];
            }
        }
        return res;
    }

    public void printOffset(PrintStream s, long offset) {
        s.append("0x");
        int addrSize = this.getAddrSize();
        int padLength = 2 * addrSize;
        String longString = Long.toHexString(offset);
        for (int i = 0; i < padLength - longString.length(); ++i) {
            s.append('0');
        }
        s.append(longString);
    }

    public int printRaw(PrintStream s, long offset) {
        int cut;
        int expectsize = this.getTrans().getDefaultSize();
        this.printOffset(s, offset >>> this.scale);
        if (this.wordsize > 1 && (cut = (int)offset & this.wordsize - 1) != 0) {
            s.append("+");
            s.print(cut);
        }
        return expectsize;
    }

    public String toString() {
        return "AddrSpace[" + this.name + "]";
    }

    public String toString(long offset) {
        int cut;
        StringBuffer s = new StringBuffer();
        int addrSize = this.getAddrSize();
        int padLength = 2 * addrSize;
        String longString = Long.toHexString(offset >>> this.scale);
        for (int i = 0; i < padLength - longString.length(); ++i) {
            s.append('0');
        }
        s.append(longString);
        if (this.wordsize > 1 && (cut = (int)offset & this.wordsize - 1) != 0) {
            s.append("+").append(cut);
        }
        return s.toString();
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_SPACE);
        this.encode_basic_attributes(encoder);
        encoder.closeElement(SlaFormat.ELEM_SPACE);
    }
}

