/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import db.Field;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.EnumDBAdapter;
import ghidra.program.database.data.EnumSignedState;
import ghidra.program.database.data.EnumValueDBAdapter;
import ghidra.program.model.data.BitGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.EnumValuePartitioner;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.UniversalID;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

class EnumDB
extends DataTypeDB
implements Enum {
    private static final SettingsDefinition[] ENUM_SETTINGS_DEFINITIONS = new SettingsDefinition[]{MutabilitySettingsDefinition.DEF};
    private EnumDBAdapter adapter;
    private EnumValueDBAdapter valueAdapter;
    private Map<String, Long> nameMap;
    private SortedMap<Long, List<String>> valueMap;
    private Map<String, String> commentMap;
    private List<BitGroup> bitGroups;
    private EnumSignedState signedState = null;

    EnumDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, EnumDBAdapter adapter, EnumValueDBAdapter valueAdapter, DBRecord record) {
        super(dataMgr, cache, record);
        this.adapter = adapter;
        this.valueAdapter = valueAdapter;
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(2);
    }

    @Override
    protected String doGetName() {
        return this.record.getString(0);
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return ENUM_SETTINGS_DEFINITIONS;
    }

    private void initializeIfNeeded() {
        if (this.nameMap != null) {
            return;
        }
        try {
            this.initialize();
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    private void initialize() throws IOException {
        Field[] ids;
        this.bitGroups = null;
        this.nameMap = new HashMap<String, Long>();
        this.valueMap = new TreeMap<Long, List<String>>();
        this.commentMap = new HashMap<String, String>();
        for (Field id : ids = this.valueAdapter.getValueIdsInEnum(this.key)) {
            DBRecord rec = this.valueAdapter.getRecord(id.getLongValue());
            String valueName = rec.getString(0);
            long value = rec.getLongValue(1);
            String comment = rec.getString(3);
            this.addToCache(valueName, value, comment);
        }
        this.signedState = this.computeSignedness();
    }

    private EnumSignedState computeSignedness() {
        byte length = this.record.getByteValue(3);
        if (this.valueMap.isEmpty()) {
            return EnumSignedState.NONE;
        }
        long minValue = this.valueMap.firstKey();
        long maxValue = this.valueMap.lastKey();
        if (maxValue > this.getMaxPossibleValue(length, true)) {
            if (minValue < 0L) {
                return EnumSignedState.INVALID;
            }
            return EnumSignedState.UNSIGNED;
        }
        if (minValue < 0L) {
            return EnumSignedState.SIGNED;
        }
        return EnumSignedState.NONE;
    }

    private void addToCache(String valueName, long value, String comment) {
        this.nameMap.put(valueName, value);
        List list = this.valueMap.computeIfAbsent(value, v -> new ArrayList());
        list.add(valueName);
        if (!StringUtils.isBlank((CharSequence)comment)) {
            this.commentMap.put(valueName, comment);
        }
    }

    private boolean removeFromCache(String valueName) {
        Long value = this.nameMap.remove(valueName);
        if (value == null) {
            return false;
        }
        List list = (List)this.valueMap.get(value);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!valueName.equals(iter.next())) continue;
            iter.remove();
            break;
        }
        if (list.isEmpty()) {
            this.valueMap.remove(value);
        }
        this.commentMap.remove(valueName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getValue(String valueName) throws NoSuchElementException {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            Long value = this.nameMap.get(valueName);
            if (value == null) {
                throw new NoSuchElementException("No value for " + valueName);
            }
            long l = value;
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName(long value) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            List list = (List)this.valueMap.get(value);
            if (list == null || list.isEmpty()) {
                String string = null;
                return string;
            }
            String string = (String)list.get(0);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNames(long value) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            List list = (List)this.valueMap.get(value);
            if (list == null || list.isEmpty()) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] stringArray = list.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComment(String valueName) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            String comment = this.commentMap.get(valueName);
            if (comment == null) {
                comment = "";
            }
            String string = comment;
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public long[] getValues() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            long[] lArray = this.valueMap.keySet().stream().mapToLong(Long::longValue).toArray();
            return lArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNames() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            ArrayList<String> names = new ArrayList<String>();
            Collection<List<String>> values = this.valueMap.values();
            for (List<String> list : values) {
                Collections.sort(list);
                names.addAll(list);
            }
            String[] stringArray = names.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getCount() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            int n = this.nameMap.size();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void add(String valueName, long value) {
        this.add(valueName, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String valueName, long value, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.initializeIfNeeded();
            this.checkValue(value);
            if (this.nameMap.containsKey(valueName)) {
                throw new IllegalArgumentException(valueName + " already exists in this enum");
            }
            if (StringUtils.isBlank((CharSequence)comment)) {
                comment = null;
            }
            this.bitGroups = null;
            this.valueAdapter.createRecord(this.key, valueName, value, comment);
            this.adapter.updateRecord(this.record, true);
            this.addToCache(valueName, value, comment);
            this.signedState = this.computeSignedness();
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void checkValue(long value) {
        byte length = this.record.getByteValue(3);
        if (length == 8) {
            return;
        }
        long min = this.getMinPossibleValue();
        long max = this.getMaxPossibleValue();
        if (value < min || value > max) {
            throw new IllegalArgumentException("Attempted to add a value outside the range for this enum: (" + min + ", " + max + "): " + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String valueName) {
        this.lock.acquire();
        try {
            Field[] ids;
            this.checkDeleted();
            this.initializeIfNeeded();
            if (!this.removeFromCache(valueName)) {
                return;
            }
            this.bitGroups = null;
            for (Field id : ids = this.valueAdapter.getValueIdsInEnum(this.key)) {
                DBRecord rec = this.valueAdapter.getRecord(id.getLongValue());
                if (!valueName.equals(rec.getString(0))) continue;
                this.valueAdapter.removeRecord(id.getLongValue());
                break;
            }
            this.adapter.updateRecord(this.record, true);
            this.signedState = this.computeSignedness();
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Enum)) {
            throw new IllegalArgumentException();
        }
        Enum enumm = (Enum)dataType;
        this.lock.acquire();
        try {
            String[] names;
            int newLength;
            Field[] ids;
            this.checkDeleted();
            this.bitGroups = null;
            this.nameMap = new HashMap<String, Long>();
            this.valueMap = new TreeMap<Long, List<String>>();
            this.commentMap = new HashMap<String, String>();
            for (Field id : ids = this.valueAdapter.getValueIdsInEnum(this.key)) {
                this.valueAdapter.removeRecord(id.getLongValue());
            }
            int oldLength = this.getLength();
            if (oldLength != (newLength = enumm.getLength())) {
                this.record.setByteValue(3, (byte)newLength);
                this.adapter.updateRecord(this.record, true);
            }
            for (String valueName : names = enumm.getNames()) {
                long value = enumm.getValue(valueName);
                String comment = enumm.getComment(valueName);
                if (StringUtils.isBlank((CharSequence)comment)) {
                    comment = null;
                }
                this.valueAdapter.createRecord(this.key, valueName, value, comment);
                this.adapter.updateRecord(this.record, true);
                this.addToCache(valueName, value, comment);
            }
            this.signedState = this.computeSignedness();
            if (oldLength != newLength) {
                this.notifySizeChanged(false);
            } else {
                this.dataMgr.dataTypeChanged(this, false);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        EnumDataType enumDataType = new EnumDataType(this.getCategoryPath(), this.getName(), this.getLength(), dtm);
        enumDataType.setDescription(this.getDescription());
        enumDataType.replaceWith(this);
        return enumDataType;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        EnumDataType enumDataType = new EnumDataType(this.getCategoryPath(), this.getName(), this.getLength(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        enumDataType.setDescription(this.getDescription());
        enumDataType.replaceWith(this);
        return enumDataType;
    }

    @Override
    public String getMnemonic(Settings settings) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.getDisplayName();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            byte by = this.record.getByteValue(3);
            return by;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getAlignedLength() {
        return this.getLength();
    }

    @Override
    public String getDescription() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String s = this.record.getString(1);
            String string = s == null ? "" : s;
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setDescription(String description) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setString(1, description);
            this.adapter.updateRecord(this.record, true);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long value = 0L;
            switch (this.getLength()) {
                case 1: {
                    value = buf.getByte(0);
                    break;
                }
                case 2: {
                    value = buf.getShort(0);
                    break;
                }
                case 4: {
                    value = buf.getInt(0);
                    break;
                }
                case 8: {
                    value = buf.getLong(0);
                }
            }
            Scalar scalar = new Scalar(length * 8, value);
            return scalar;
        }
        catch (MemoryAccessException e) {
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Scalar.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long value = 0L;
            switch (this.getLength()) {
                case 1: {
                    value = (long)buf.getByte(0) & 0xFFL;
                    break;
                }
                case 2: {
                    value = (long)buf.getShort(0) & 0xFFFFL;
                    break;
                }
                case 4: {
                    value = (long)buf.getInt(0) & 0xFFFFFFFFL;
                    break;
                }
                case 8: {
                    value = buf.getLong(0);
                }
            }
            String string = this.getRepresentation(value);
            return string;
        }
        catch (MemoryAccessException e) {
            String string = "??";
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getRepresentation(BigInteger bigInt, Settings settings, int bitLength) {
        return this.getRepresentation(bigInt.longValue());
    }

    private String getRepresentation(long value) {
        String valueName = this.getName(value);
        if (valueName == null) {
            valueName = this.getCompoundValue(value);
        }
        return valueName;
    }

    private String getCompoundValue(long value) {
        if (value == 0L) {
            return "0";
        }
        List<BitGroup> list = this.getBitGroups();
        StringBuilder buf = new StringBuilder();
        for (BitGroup bitGroup : list) {
            long subValue = bitGroup.getMask() & value;
            if (subValue == 0L) continue;
            Object part = this.getName(subValue);
            if (part == null) {
                part = Long.toHexString(subValue).toUpperCase() + "h";
            }
            if (buf.length() != 0) {
                buf.append(" | ");
            }
            buf.append((String)part);
        }
        return buf.toString();
    }

    private List<BitGroup> getBitGroups() {
        if (this.bitGroups == null) {
            this.bitGroups = EnumValuePartitioner.partition(this.getValues(), this.getLength());
        }
        return this.bitGroups;
    }

    @Override
    protected boolean isEquivalent(DataType dt, DataTypeConflictHandler handler) {
        if (dt == this) {
            return true;
        }
        if (dt == null || !(dt instanceof Enum)) {
            return false;
        }
        Enum enumm = (Enum)dt;
        if (!DataTypeUtilities.equalsIgnoreConflict(this.getName(), enumm.getName())) {
            return false;
        }
        if (handler != null && DataTypeConflictHandler.ConflictResult.USE_EXISTING == handler.resolveConflict(enumm, this)) {
            return true;
        }
        if (this.getLength() != enumm.getLength() || this.getCount() != enumm.getCount()) {
            return false;
        }
        return this.isEachValueEquivalent(enumm);
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        return this.isEquivalent(dt, null);
    }

    private boolean isEachValueEquivalent(Enum enumm) {
        String[] names = this.getNames();
        String[] otherNames = enumm.getNames();
        try {
            for (int i = 0; i < names.length; ++i) {
                String otherComment;
                long otherValue;
                if (!names[i].equals(otherNames[i])) {
                    return false;
                }
                long value = this.getValue(names[i]);
                if (value != (otherValue = enumm.getValue(names[i]))) {
                    return false;
                }
                String comment = this.getComment(names[i]);
                if (comment.equals(otherComment = enumm.getComment(names[i]))) continue;
                return false;
            }
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinPossibleValue() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            byte length = this.record.getByteValue(3);
            long l = this.getMinPossibleValue(length, this.signedState != EnumSignedState.UNSIGNED);
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxPossibleValue() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            byte length = this.record.getByteValue(3);
            long l = this.getMaxPossibleValue(length, this.signedState == EnumSignedState.SIGNED);
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    private long getMaxPossibleValue(int bytes, boolean allowNegativeValues) {
        if (bytes == 8) {
            return Long.MAX_VALUE;
        }
        int bits = bytes * 8;
        if (allowNegativeValues) {
            --bits;
        }
        return (1L << bits) - 1L;
    }

    private long getMinPossibleValue(int bytes, boolean allowNegativeValues) {
        if (!allowNegativeValues) {
            return 0L;
        }
        int bits = bytes * 8;
        return -1L << bits - 1;
    }

    @Override
    protected boolean refresh() {
        try {
            this.nameMap = null;
            this.valueMap = null;
            this.commentMap = null;
            this.bitGroups = null;
            DBRecord rec = this.adapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(2, categoryID);
        this.adapter.updateRecord(this.record, false);
    }

    @Override
    protected void doSetNameRecord(String name) throws IOException {
        this.record.setString(0, name);
        this.adapter.updateRecord(this.record, true);
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    @Override
    public long getLastChangeTime() {
        return this.record.getLongValue(7);
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.record.getLongValue(6);
    }

    @Override
    public UniversalID getUniversalID() {
        return new UniversalID(this.record.getLongValue(5));
    }

    @Override
    protected void setUniversalID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(5, id.getValue());
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return new UniversalID(this.record.getLongValue(4));
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(4, id.getValue());
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(7, lastChangeTime);
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(6, lastChangeTimeInSourceArchive);
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean contains(String name) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            boolean bl = this.nameMap.containsKey(name);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(long value) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            boolean bl = this.valueMap.containsKey(value);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isSigned() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            boolean bl = this.signedState == EnumSignedState.SIGNED;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public EnumSignedState getSignedState() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            EnumSignedState enumSignedState = this.signedState;
            return enumSignedState;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinimumPossibleLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            this.initializeIfNeeded();
            if (this.valueMap.isEmpty()) {
                int n = 1;
                return n;
            }
            long minValue = this.valueMap.firstKey();
            long maxValue = this.valueMap.lastKey();
            boolean hasNegativeValues = minValue < 0L;
            for (int size = 1; size < 8; size *= 2) {
                long minPossible = this.getMinPossibleValue(size, hasNegativeValues);
                long maxPossible = this.getMaxPossibleValue(size, hasNegativeValues);
                if (minValue < minPossible || maxValue > maxPossible) continue;
                int n = size;
                return n;
            }
            int n = 8;
            return n;
        }
        finally {
            this.lock.release();
        }
    }
}

