/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.EnumValueDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class EnumValueDBAdapterV1
extends EnumValueDBAdapter {
    static final int VERSION = 1;
    static final Schema SCHEMA = new Schema(1, "Enum Value ID", new Class[]{StringField.class, LongField.class, LongField.class, StringField.class}, new String[]{"Name", "Value", "Enum ID", "Comment"});
    private Table table;

    EnumValueDBAdapterV1(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + "Enumeration Values";
        if (create) {
            this.table = handle.createTable(tableName, SCHEMA, new int[]{2});
        } else {
            this.table = handle.getTable(tableName);
            if (this.table == null) {
                throw new VersionException(true);
            }
            int version = this.table.getSchema().getVersion();
            if (version != 1) {
                throw new VersionException(version < 1);
            }
        }
    }

    @Override
    void createRecord(long enumID, String name, long value, String comment) throws IOException {
        DBRecord record = SCHEMA.createRecord(this.table.getKey());
        record.setLongValue(2, enumID);
        record.setString(0, name);
        record.setLongValue(1, value);
        record.setString(3, comment);
        this.table.putRecord(record);
    }

    @Override
    DBRecord getRecord(long valueID) throws IOException {
        return this.table.getRecord(valueID);
    }

    @Override
    void removeRecord(long valueID) throws IOException {
        this.table.deleteRecord(valueID);
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    Field[] getValueIdsInEnum(long enumID) throws IOException {
        return this.table.findRecords((Field)new LongField(enumID), 2);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(this.table.getName());
    }

    public DBRecord translateRecord(DBRecord r) {
        return r;
    }
}

