/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.properties.DBPropertyMapManager;
import ghidra.program.database.properties.PropertiesDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class PropertiesDBAdapterV0
implements PropertiesDBAdapter {
    private Table propertiesTable;

    public PropertiesDBAdapterV0(DBHandle dbHandle) throws VersionException {
        this.propertiesTable = dbHandle.getTable("Properties");
        this.testVersion(0);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.propertiesTable.iterator();
    }

    @Override
    public void putRecord(String propertyName, byte type, String objClassName) throws IOException {
        DBRecord rec = DBPropertyMapManager.PROPERTIES_SCHEMA.createRecord((Field)new StringField(propertyName));
        rec.setByteValue(0, type);
        if (type == 4) {
            rec.setString(1, objClassName);
        }
        this.propertiesTable.putRecord(rec);
    }

    @Override
    public void removeRecord(String propertyName) throws IOException {
        this.propertiesTable.deleteRecord((Field)new StringField(propertyName));
    }

    private void testVersion(int expectedVersion) throws VersionException {
        if (this.propertiesTable == null) {
            throw new VersionException("Properties table not found");
        }
        int versionNumber = this.propertiesTable.getSchema().getVersion();
        if (versionNumber != expectedVersion) {
            throw new VersionException("Properties table: Expected Version " + expectedVersion + ", got " + versionNumber);
        }
    }
}

