/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.register;

import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.util.datastruct.IndexRange;
import ghidra.util.datastruct.IndexRangeIterator;
import java.util.Iterator;

public class IndexToAddressRangeIteratorAdapter
implements AddressRangeIterator {
    private AddressMap map;
    private IndexRangeIterator it;

    public IndexToAddressRangeIteratorAdapter(AddressMap addressMap, IndexRangeIterator it) {
        this.map = addressMap;
        this.it = it;
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public AddressRange next() {
        IndexRange indexRange = this.it.next();
        Address start = this.map.decodeAddress(indexRange.getStart());
        Address end = this.map.decodeAddress(indexRange.getEnd());
        return new AddressRangeImpl(start, end);
    }
}

