/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.util.Query;
import ghidra.util.Msg;
import ghidra.util.exception.ClosedException;
import java.io.IOException;

public class QueryRecordIterator
implements RecordIterator {
    private RecordIterator iter;
    private Query query;
    private DBRecord record;
    private boolean forward;

    public QueryRecordIterator(RecordIterator iter, Query query) {
        this(iter, query, true);
    }

    public QueryRecordIterator(RecordIterator iter, Query query, boolean forward) {
        this.iter = iter;
        this.query = query;
        this.forward = forward;
    }

    public boolean hasNext() throws IOException {
        if (this.record == null) {
            if (this.forward) {
                this.findNext();
            } else {
                this.findPrevious();
            }
        }
        return this.record != null;
    }

    public DBRecord next() throws IOException {
        if (this.hasNext()) {
            DBRecord rec = this.record;
            this.record = null;
            return rec;
        }
        return null;
    }

    public boolean hasPrevious() throws IOException {
        if (this.record == null) {
            this.findPrevious();
        }
        return this.record != null;
    }

    public DBRecord previous() throws IOException {
        if (this.hasPrevious()) {
            DBRecord rec = this.record;
            this.record = null;
            return rec;
        }
        return null;
    }

    public boolean delete() throws IOException {
        return this.iter.delete();
    }

    private void findNext() {
        try {
            while (this.iter.hasNext()) {
                DBRecord rec = this.iter.next();
                if (!this.query.matches(rec)) continue;
                this.record = rec;
                return;
            }
        }
        catch (ClosedException rec) {
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, null, null, (Throwable)e);
        }
    }

    private void findPrevious() {
        try {
            while (this.iter.hasPrevious()) {
                DBRecord rec = this.iter.previous();
                if (!this.query.matches(rec)) continue;
                this.record = rec;
                return;
            }
        }
        catch (ClosedException rec) {
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, null, null, (Throwable)e);
        }
    }
}

