/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitGroup;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EnumValuePartitioner {
    private static void merge(List<BitGroup> list, BitGroup bitGroup) {
        Iterator<BitGroup> it = list.iterator();
        while (it.hasNext()) {
            BitGroup next = it.next();
            if (!bitGroup.intersects(next)) continue;
            bitGroup.merge(next);
            it.remove();
        }
        list.add(bitGroup);
    }

    public static List<BitGroup> partition(long[] values, int size) {
        LinkedList<BitGroup> list = new LinkedList<BitGroup>();
        long usedBits = 0L;
        for (long value : values) {
            usedBits |= value;
            BitGroup bitGroup = new BitGroup(value);
            EnumValuePartitioner.merge(list, bitGroup);
        }
        int bits = size * 8;
        long allEnumBits = -1L << bits ^ 0xFFFFFFFFFFFFFFFFL;
        long unusedBits = usedBits ^ 0xFFFFFFFFFFFFFFFFL;
        list.add(new BitGroup(unusedBits & allEnumBits));
        return list;
    }
}

