/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.NumberSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import java.math.BigInteger;

public class OffsetMaskSettingsDefinition
implements NumberSettingsDefinition,
TypeDefSettingsDefinition {
    private static final String OFFSET_MASK_SETTING_NAME = "offset_mask";
    private static final String DESCRIPTION = "Identifies bit-mask to be applied to a stored pointer offset prior to any shift";
    private static final String DISPLAY_NAME = "Offset Mask";
    private static BigInteger MAX_VALUE = new BigInteger("0ffffffffffffffff", 16);
    public static final long DEFAULT = -1L;
    public static final OffsetMaskSettingsDefinition DEF = new OffsetMaskSettingsDefinition();

    private OffsetMaskSettingsDefinition() {
    }

    public BigInteger getMaxValue() {
        return MAX_VALUE;
    }

    public boolean allowNegativeValue() {
        return false;
    }

    public boolean isHexModePreferred() {
        return true;
    }

    public long getValue(Settings settings) {
        if (settings == null) {
            return -1L;
        }
        Long value = settings.getLong(OFFSET_MASK_SETTING_NAME);
        if (value == null) {
            return -1L;
        }
        return value;
    }

    public void setValue(Settings settings, long value) {
        if (value == 0L || value == -1L) {
            settings.clearSetting(OFFSET_MASK_SETTING_NAME);
        } else {
            settings.setLong(OFFSET_MASK_SETTING_NAME, value);
        }
    }

    public boolean hasValue(Settings settings) {
        return this.getValue(settings) != -1L;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public String getStorageKey() {
        return OFFSET_MASK_SETTING_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void clear(Settings settings) {
        settings.clearSetting(OFFSET_MASK_SETTING_NAME);
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        Long value = srcSettings.getLong(OFFSET_MASK_SETTING_NAME);
        if (value == null) {
            destSettings.clearSetting(OFFSET_MASK_SETTING_NAME);
        } else {
            destSettings.setLong(OFFSET_MASK_SETTING_NAME, value.longValue());
        }
    }

    @Override
    public String getAttributeSpecification(Settings settings) {
        if (this.hasValue(settings)) {
            long mask = this.getValue(settings);
            return "mask(0x" + Long.toHexString(mask) + ")";
        }
        return null;
    }
}

