/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AddressSpaceSettingsDefinition;
import ghidra.program.model.data.ComponentOffsetSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.OffsetMaskSettingsDefinition;
import ghidra.program.model.data.OffsetShiftSettingsDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypeSettingsDefinition;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.TypeDef;
import ghidra.util.InvalidNameException;
import java.util.Objects;

public class PointerTypedefBuilder {
    private PointerTypedef typedef;

    public PointerTypedefBuilder(DataType baseDataType, int pointerSize, DataTypeManager dtm) {
        this.typedef = new PointerTypedef(null, baseDataType, pointerSize, dtm);
    }

    public PointerTypedefBuilder(Pointer pointerDataType, DataTypeManager dtm) {
        Objects.requireNonNull(pointerDataType, "Pointer datatype required");
        this.typedef = new PointerTypedef(null, pointerDataType, dtm);
    }

    public PointerTypedefBuilder name(String name) throws InvalidNameException {
        this.typedef.setName(name);
        return this;
    }

    public PointerTypedefBuilder type(PointerType type) {
        PointerTypeSettingsDefinition.DEF.setType(this.typedef.getDefaultSettings(), type);
        return this;
    }

    public PointerTypedefBuilder bitShift(int shift) {
        OffsetShiftSettingsDefinition.DEF.setValue(this.typedef.getDefaultSettings(), shift);
        return this;
    }

    public PointerTypedefBuilder bitMask(long unsignedMask) {
        OffsetMaskSettingsDefinition.DEF.setValue(this.typedef.getDefaultSettings(), unsignedMask);
        return this;
    }

    public PointerTypedefBuilder componentOffset(long offset) {
        ComponentOffsetSettingsDefinition.DEF.setValue(this.typedef.getDefaultSettings(), offset);
        return this;
    }

    public PointerTypedefBuilder addressSpace(AddressSpace space) {
        AddressSpaceSettingsDefinition.DEF.setValue(this.typedef.getDefaultSettings(), space != null ? space.getName() : null);
        return this;
    }

    public PointerTypedefBuilder addressSpace(String spaceName) {
        AddressSpaceSettingsDefinition.DEF.setValue(this.typedef.getDefaultSettings(), spaceName);
        return this;
    }

    public TypeDef build() {
        return this.typedef;
    }
}

