/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AlignedStructureInspector;
import ghidra.program.model.data.AlignedStructurePacker;
import ghidra.program.model.data.BadDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.CompositeInternal;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureInternal;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class StructureDataType
extends CompositeDataTypeImpl
implements StructureInternal {
    protected int structLength;
    private int structAlignment;
    protected int numComponents;
    protected List<DataTypeComponentImpl> components;

    public StructureDataType(String name, int length) {
        this(CategoryPath.ROOT, name, length);
    }

    public StructureDataType(String name, int length, DataTypeManager dtm) {
        this(CategoryPath.ROOT, name, length, dtm);
    }

    public StructureDataType(CategoryPath path, String name, int length) {
        this(path, name, length, null);
    }

    public StructureDataType(CategoryPath path, String name, int length, DataTypeManager dtm) {
        super(path, name, dtm);
        if (length < 0) {
            throw new IllegalArgumentException("Length can't be negative");
        }
        this.components = new ArrayList<DataTypeComponentImpl>();
        this.structLength = length;
        this.numComponents = length;
    }

    public StructureDataType(CategoryPath path, String name, int length, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
        this.components = new ArrayList<DataTypeComponentImpl>();
        this.structLength = length;
        this.numComponents = length;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Structure>";
        }
        return "";
    }

    @Override
    public int getAlignment() {
        if (this.structAlignment > 0) {
            return this.structAlignment;
        }
        if (this.isPackingEnabled()) {
            AlignedStructurePacker.StructurePackResult packResult = AlignedStructureInspector.packComponents(this);
            this.structAlignment = packResult.alignment;
        } else {
            this.structAlignment = this.getNonPackedAlignment();
        }
        return this.structAlignment;
    }

    @Override
    public DataTypeComponent getDefinedComponentAtOrAfterOffset(int offset) {
        if (offset > this.structLength || offset < 0) {
            return null;
        }
        int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
        if (index >= 0) {
            DataTypeComponent dtc = this.components.get(index);
            index = this.backupToFirstComponentContainingOffset(index, offset);
            dtc = this.components.get(index);
            return dtc;
        }
        if ((index = -index - 1) < this.components.size()) {
            return this.components.get(index);
        }
        return null;
    }

    @Override
    public DataTypeComponent getComponentContaining(int offset) {
        if (offset > this.structLength || offset < 0) {
            return null;
        }
        int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
        if (index >= 0) {
            DataTypeComponent dtc = this.components.get(index);
            dtc = this.components.get(index = this.indexOfFirstNonZeroLenComponentContainingOffset(index, offset));
            if (dtc.getLength() != 0) {
                return dtc;
            }
            index = -index - 1;
        }
        if (offset != this.structLength && !this.isPackingEnabled()) {
            return this.generateUndefinedComponent(offset, index);
        }
        return null;
    }

    @Override
    public List<DataTypeComponent> getComponentsContaining(int offset) {
        ArrayList<DataTypeComponent> list = new ArrayList<DataTypeComponent>();
        if (offset > this.structLength || offset < 0) {
            return list;
        }
        int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
        boolean hasSizedComponent = false;
        if (index >= 0) {
            DataTypeComponentImpl dtc = this.components.get(index);
            index = this.backupToFirstComponentContainingOffset(index, offset);
            while (index < this.components.size() && (dtc = this.components.get(index)).containsOffset(offset)) {
                ++index;
                hasSizedComponent |= dtc.getLength() != 0;
                list.add(dtc);
            }
            index = -index - 1;
        }
        if (!hasSizedComponent && offset != this.structLength && !this.isPackingEnabled()) {
            list.add(this.generateUndefinedComponent(offset, index));
        }
        return list;
    }

    private DataTypeComponentImpl generateUndefinedComponent(int offset, int missingComponentIndex) {
        if (missingComponentIndex >= 0) {
            throw new AssertException();
        }
        missingComponentIndex = -missingComponentIndex - 1;
        int ordinal = offset;
        if (missingComponentIndex > 0) {
            DataTypeComponent dtc = this.components.get(missingComponentIndex - 1);
            ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
            if (dtc.getLength() == 0) {
                ++ordinal;
            }
        }
        return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
    }

    @Override
    public DataTypeComponent getDataTypeAt(int offset) {
        DataType dt;
        DataTypeComponent dtc = this.getComponentContaining(offset);
        if (dtc != null && (dt = dtc.getDataType()) instanceof Structure) {
            return ((Structure)dt).getDataTypeAt(offset - dtc.getOffset());
        }
        return dtc;
    }

    @Override
    public boolean isZeroLength() {
        return this.structLength == 0;
    }

    @Override
    public int getLength() {
        if (this.structLength == 0) {
            return 1;
        }
        return this.structLength;
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.isPackingEnabled();
    }

    @Override
    public void delete(int ordinal) {
        if (ordinal < 0 || ordinal >= this.numComponents) {
            throw new IndexOutOfBoundsException(ordinal);
        }
        int idx = this.isPackingEnabled() ? ordinal : Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
        if (idx >= 0) {
            this.doDeleteWithComponentShift(idx, false);
        } else {
            idx = -idx - 1;
            this.shiftOffsets(idx, -1, -1);
        }
        this.repack(false);
        this.notifySizeChanged();
    }

    private DataTypeComponentImpl doDelete(int index) {
        DataTypeComponentImpl dtc = this.components.remove(index);
        dtc.getDataType().removeParent(this);
        return dtc;
    }

    private void doDeleteWithComponentShift(int index, boolean disableOffsetShift) {
        DataTypeComponentImpl dtc = this.doDelete(index);
        if (this.isPackingEnabled()) {
            return;
        }
        int shiftAmount = disableOffsetShift || dtc.isBitFieldComponent() ? 0 : dtc.getLength();
        this.shiftOffsets(index, -1, -shiftAmount);
    }

    @Override
    public void delete(Set<Integer> ordinals) {
        SortedSet<Integer> removedFillerSet;
        if (ordinals.isEmpty()) {
            return;
        }
        if (ordinals.size() == 1) {
            ordinals.forEach(ordinal -> this.delete((int)ordinal));
            return;
        }
        TreeSet<Integer> sortedOrdinals = new TreeSet<Integer>(ordinals);
        int firstOrdinal = sortedOrdinals.first();
        int lastOrdinal = sortedOrdinals.last();
        if (firstOrdinal < 0 || lastOrdinal >= this.numComponents) {
            throw new IndexOutOfBoundsException(ordinals.size() + " ordinals specified");
        }
        Integer nextOrdinal = firstOrdinal;
        int ordinalAdjustment = 0;
        int offsetAdjustment = 0;
        int lastDefinedOrdinal = -1;
        boolean isPacked = this.isPackingEnabled();
        boolean bitFieldRemoved = false;
        ArrayList<DataTypeComponentImpl> newComponents = new ArrayList<DataTypeComponentImpl>(this.components.size());
        for (DataTypeComponentImpl dtc : this.components) {
            SortedSet<Integer> removedFillerSet2;
            int ordinal2 = dtc.getOrdinal();
            if (!isPacked && nextOrdinal != null && nextOrdinal < ordinal2 && !(removedFillerSet2 = sortedOrdinals.subSet(lastDefinedOrdinal + 1, ordinal2)).isEmpty()) {
                int undefinedRemoveCount = removedFillerSet2.size();
                ordinalAdjustment -= undefinedRemoveCount;
                offsetAdjustment -= undefinedRemoveCount;
                nextOrdinal = sortedOrdinals.higher(removedFillerSet2.last());
            }
            if (nextOrdinal != null && nextOrdinal == ordinal2) {
                if (dtc.isBitFieldComponent()) {
                    bitFieldRemoved = true;
                } else {
                    offsetAdjustment -= dtc.getLength();
                }
                --ordinalAdjustment;
                lastDefinedOrdinal = ordinal2;
                nextOrdinal = sortedOrdinals.higher(ordinal2);
                continue;
            }
            if (ordinalAdjustment != 0) {
                this.shiftOffset(dtc, ordinalAdjustment, offsetAdjustment);
            }
            newComponents.add(dtc);
            lastDefinedOrdinal = ordinal2;
        }
        if (!isPacked && !(removedFillerSet = sortedOrdinals.subSet(lastDefinedOrdinal + 1, this.numComponents)).isEmpty()) {
            int undefinedRemoveCount = removedFillerSet.size();
            ordinalAdjustment -= undefinedRemoveCount;
            offsetAdjustment -= undefinedRemoveCount;
        }
        this.components = newComponents;
        this.numComponents += ordinalAdjustment;
        if (isPacked) {
            this.repack(true);
        } else {
            this.structLength += offsetAdjustment;
            if (bitFieldRemoved) {
                this.repack(false);
            }
            this.notifySizeChanged();
        }
    }

    private void shiftOffsets(int index, int deltaOrdinal, int deltaOffset) {
        if (deltaOffset == 0 && deltaOrdinal == 0) {
            return;
        }
        for (int i = index; i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            this.shiftOffset(dtc, deltaOrdinal, deltaOffset);
        }
        this.structLength += deltaOffset;
        this.numComponents += deltaOrdinal;
    }

    protected void shiftOffset(DataTypeComponentImpl dtc, int deltaOrdinal, int deltaOffset) {
        dtc.setOffset(dtc.getOffset() + deltaOffset);
        dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal);
    }

    @Override
    public DataTypeComponentImpl getComponent(int ordinal) {
        if (ordinal < 0 || ordinal >= this.numComponents) {
            throw new IndexOutOfBoundsException(ordinal);
        }
        int index = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
        if (index >= 0) {
            return this.components.get(index);
        }
        int offset = 0;
        if ((index = -index - 1) == 0) {
            offset = ordinal;
        } else {
            DataTypeComponent dtc = this.components.get(index - 1);
            offset = dtc.getEndOffset() + ordinal - dtc.getOrdinal();
            if (dtc.getLength() == 0) {
                --offset;
            }
        }
        return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    @Override
    public int getNumDefinedComponents() {
        return this.components.size();
    }

    @Override
    public final DataTypeComponentImpl insertAtOffset(int offset, DataType dataType, int length) {
        return this.insertAtOffset(offset, dataType, length, null, null);
    }

    @Override
    public DataTypeComponentImpl insertAtOffset(int offset, DataType dataType, int length, String componentName, String comment) throws IllegalArgumentException {
        DataTypeComponent dtc;
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (dataType instanceof BitFieldDataType) {
            BitFieldDataType bfDt = (BitFieldDataType)dataType;
            if (length <= 0) {
                length = dataType.getLength();
            }
            try {
                return this.insertBitFieldAt(offset, length, bfDt.getBitOffset(), bfDt.getBaseDataType(), bfDt.getDeclaredBitSize(), componentName, comment);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)((Object)e));
            }
        }
        dataType = this.validateDataType(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        if (offset > this.structLength && !this.isPackingEnabled()) {
            this.numComponents += offset - this.structLength;
            this.structLength = offset;
        }
        int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
        int additionalShift = 0;
        if (index >= 0) {
            index = this.backupToFirstComponentContainingOffset(index, offset);
            DataTypeComponent dtc2 = this.components.get(index);
            additionalShift = offset - dtc2.getOffset();
        } else {
            index = -index - 1;
        }
        int ordinal = offset;
        if (index > 0) {
            dtc = this.components.get(index - 1);
            ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
        }
        if (dataType == DataType.DEFAULT) {
            this.shiftOffsets(index, 1 + additionalShift, 1 + additionalShift);
            return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
        }
        length = this.getPreferredComponentLength(dataType, length);
        dtc = new DataTypeComponentImpl(dataType, this, length, ordinal, offset, componentName, comment);
        dataType.addParent(this);
        this.shiftOffsets(index, 1 + additionalShift, length + additionalShift);
        this.components.add(index, (DataTypeComponentImpl)dtc);
        this.repack(false);
        this.notifySizeChanged();
        return dtc;
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String componentName, String comment) {
        return this.doAdd(dataType, length, componentName, comment, true);
    }

    private DataTypeComponentImpl doAdd(DataType dataType, int length, String componentName, String comment, boolean packAndNotify) throws IllegalArgumentException {
        DataTypeComponentImpl dtc;
        dataType = this.validateDataType(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        if (dataType == DataType.DEFAULT) {
            dtc = new DataTypeComponentImpl(DataType.DEFAULT, this, 1, this.numComponents, this.structLength);
        } else {
            int componentLength = this.getPreferredComponentLength(dataType, length);
            dtc = new DataTypeComponentImpl(dataType, this, componentLength, this.numComponents, this.structLength, componentName, comment);
            dataType.addParent(this);
            this.components.add(dtc);
        }
        int structureGrowth = dtc.getLength();
        if (structureGrowth != 0 && !this.isPackingEnabled() && length > 0) {
            structureGrowth = length;
        }
        ++this.numComponents;
        this.structLength += structureGrowth;
        if (packAndNotify) {
            if (this.isPackingEnabled()) {
                this.repack(false);
            }
            this.notifySizeChanged();
        }
        return dtc;
    }

    @Override
    public void setLength(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid length: " + len);
        }
        if (len == this.structLength || this.isPackingEnabled()) {
            return;
        }
        if (len < this.structLength) {
            int index = Collections.binarySearch(this.components, len, CompositeInternal.OffsetComparator.INSTANCE);
            index = index < 0 ? -index - 1 : this.backupToFirstComponentContainingOffset(index, len);
            int definedComponentCount = this.components.size();
            if (index >= 0 && index < definedComponentCount) {
                this.components = this.components.subList(0, index);
            }
        } else {
            this.numComponents += len - this.structLength;
        }
        this.structLength = len;
        this.repack(false);
        this.notifySizeChanged();
    }

    @Override
    public void growStructure(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Invalid growth amount: " + amount);
        }
        if (amount == 0 || this.isPackingEnabled()) {
            return;
        }
        this.doGrowStructure(amount);
        this.repack(false);
        this.notifySizeChanged();
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String componentName, String comment) throws IndexOutOfBoundsException, IllegalArgumentException {
        int idx;
        if (ordinal < 0 || ordinal > this.numComponents) {
            throw new IndexOutOfBoundsException(ordinal);
        }
        if (ordinal == this.numComponents) {
            return this.add(dataType, length, componentName, comment);
        }
        dataType = this.validateDataType(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        if (this.isPackingEnabled()) {
            idx = ordinal;
        } else {
            DataTypeComponentImpl previousDtc;
            DataTypeComponentImpl existingDtc;
            idx = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
            if (idx > 0 && (existingDtc = this.components.get(idx)).isBitFieldComponent() && (previousDtc = this.components.get(idx - 1)).getEndOffset() == existingDtc.getOffset()) {
                this.shiftOffsets(idx, 0, 1);
            }
        }
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (dataType == DataType.DEFAULT) {
            this.shiftOffsets(idx, 1, 1);
            return this.getComponent(ordinal);
        }
        length = this.getPreferredComponentLength(dataType, length);
        int offset = this.getComponent(ordinal).getOffset();
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, ordinal, offset, componentName, comment);
        dataType.addParent(this);
        this.shiftOffsets(idx, 1, dtc.getLength());
        this.components.add(idx, dtc);
        this.repack(false);
        this.notifySizeChanged();
        return dtc;
    }

    @Override
    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.dataMgr);
        BitFieldDataType bitFieldDt = new BitFieldDataType(baseDataType, bitSize);
        return this.add(bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
    }

    @Override
    public DataTypeComponent insertBitField(int ordinal, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException, IndexOutOfBoundsException {
        if (ordinal < 0 || ordinal > this.numComponents) {
            throw new IndexOutOfBoundsException(ordinal);
        }
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.dataMgr);
        if (!this.isPackingEnabled()) {
            int offset = this.structLength;
            if (ordinal < this.numComponents) {
                offset = this.getComponent(ordinal).getOffset();
            }
            return this.insertBitFieldAt(offset, byteWidth, bitOffset, baseDataType, bitSize, componentName, comment);
        }
        BitFieldDataType bitFieldDt = new BitFieldDataType(baseDataType, bitSize);
        return this.insert(ordinal, bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
    }

    @Override
    public DataTypeComponentImpl insertBitFieldAt(int byteOffset, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        int requiredLength;
        int ordinal;
        if (byteOffset < 0 || bitSize < 0) {
            throw new IllegalArgumentException("Negative values not permitted when defining bitfield");
        }
        if (byteWidth <= 0) {
            throw new IllegalArgumentException("Invalid byteWidth");
        }
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.dataMgr);
        int effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, baseDataType.getLength());
        int minByteWidth = BitFieldDataType.getMinimumStorageSize(effectiveBitSize + bitOffset);
        if (byteWidth < minByteWidth) {
            throw new IllegalArgumentException("Bitfield does not fit within specified constraints");
        }
        boolean bigEndian = this.getDataOrganization().isBigEndian();
        boolean hasConflict = false;
        int additionalShift = 0;
        int startBitOffset = Structure.BitOffsetComparator.getNormalizedBitfieldOffset(byteOffset, byteWidth, effectiveBitSize, bitOffset, bigEndian);
        Comparator<Object> bitOffsetComparator = bigEndian ? Structure.BitOffsetComparator.INSTANCE_BE : Structure.BitOffsetComparator.INSTANCE_LE;
        int startIndex = Collections.binarySearch(this.components, startBitOffset, bitOffsetComparator);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        } else {
            hasConflict = true;
            DataTypeComponentImpl dtc = this.components.get(startIndex);
            if (bitSize == 0 || dtc.isZeroBitFieldComponent()) {
                boolean bl = hasConflict = dtc.getOffset() != startBitOffset / 8;
            }
            if (hasConflict) {
                additionalShift = byteOffset - dtc.getOffset();
            }
        }
        if (startIndex < this.components.size()) {
            DataTypeComponentImpl dtc = this.components.get(startIndex);
            ordinal = dtc.getOrdinal();
        } else {
            ordinal = startIndex;
        }
        if (this.isPackingEnabled()) {
            this.insertBitField(ordinal, 0, 0, baseDataType, effectiveBitSize, componentName, comment);
        }
        int endIndex = startIndex;
        if (startIndex < this.components.size()) {
            int endBitOffset = startBitOffset;
            if (effectiveBitSize != 0) {
                endBitOffset += effectiveBitSize - 1;
            }
            if ((endIndex = Collections.binarySearch(this.components, endBitOffset, bitOffsetComparator)) < 0) {
                endIndex = -endIndex - 1;
            } else if (effectiveBitSize != 0) {
                hasConflict = true;
            }
        }
        if (startIndex != endIndex) {
            hasConflict = true;
        }
        if (hasConflict) {
            this.shiftOffsets(startIndex, 1, byteWidth + additionalShift);
        }
        if ((requiredLength = byteOffset + byteWidth) > this.structLength) {
            this.structLength = requiredLength;
        }
        int storageBitOffset = bitOffset % 8;
        int revisedOffset = bigEndian ? byteOffset + byteWidth - (effectiveBitSize + bitOffset + 7) / 8 : byteOffset + bitOffset / 8;
        BitFieldDataType bitfieldDt = new BitFieldDataType(baseDataType, bitSize, storageBitOffset);
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(bitfieldDt, this, bitfieldDt.getStorageSize(), ordinal, revisedOffset, componentName, comment);
        bitfieldDt.addParent(this);
        this.components.add(startIndex, dtc);
        this.adjustNonPackedComponents();
        this.notifySizeChanged();
        return dtc;
    }

    private int backupToFirstComponentContainingOffset(int index, int offset) {
        DataTypeComponentImpl previous;
        if (index == 0) {
            return 0;
        }
        while (index != 0 && (previous = this.components.get(index - 1)).containsOffset(offset)) {
            --index;
        }
        return index;
    }

    private int indexOfFirstNonZeroLenComponentContainingOffset(int index, int offset) {
        DataTypeComponentImpl next = this.components.get(index);
        for (index = this.backupToFirstComponentContainingOffset(index, offset); next.getLength() == 0 && index < this.components.size() - 1 && (next = this.components.get(index + 1)).containsOffset(offset); ++index) {
        }
        return index;
    }

    private int advanceToLastComponentContainingOffset(int index, int offset) {
        DataTypeComponentImpl next;
        while (index < this.components.size() - 1 && (next = this.components.get(index + 1)).containsOffset(offset)) {
            ++index;
        }
        return index;
    }

    @Override
    public void deleteAtOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (offset > this.structLength) {
            return;
        }
        int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
        if (index < 0) {
            if (offset == this.structLength) {
                return;
            }
            this.shiftOffsets(-index - 1, -1, -1);
        } else {
            index = this.advanceToLastComponentContainingOffset(index, offset);
            DataTypeComponentImpl dtc = this.components.get(index);
            while (dtc.containsOffset(offset)) {
                this.doDeleteWithComponentShift(index, false);
                if (--index < 0) break;
                dtc = this.components.get(index);
            }
        }
        this.repack(false);
        this.notifySizeChanged();
    }

    @Override
    public void clearAtOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (offset > this.structLength) {
            return;
        }
        int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
        if (index < 0) {
            return;
        }
        index = this.advanceToLastComponentContainingOffset(index, offset);
        DataTypeComponentImpl dtc = this.components.get(index);
        while (dtc.containsOffset(offset)) {
            this.doDeleteWithComponentShift(index, true);
            if (--index < 0) break;
            dtc = this.components.get(index);
        }
        this.repack(false);
        this.notifySizeChanged();
    }

    @Override
    public boolean isEquivalent(DataType dataType) {
        int otherNumComps;
        int otherLength;
        if (dataType == this) {
            return true;
        }
        if (!(dataType instanceof StructureInternal)) {
            return false;
        }
        StructureInternal struct = (StructureInternal)dataType;
        int n = otherLength = struct.isZeroLength() ? 0 : struct.getLength();
        if (this.packing != struct.getStoredPackingValue() || this.minimumAlignment != struct.getStoredMinimumAlignment() || this.packing == -1 && this.structLength != otherLength) {
            return false;
        }
        int myNumComps = this.components.size();
        if (myNumComps != (otherNumComps = struct.getNumDefinedComponents())) {
            return false;
        }
        DataTypeComponent[] otherDefinedComponents = struct.getDefinedComponents();
        if (otherDefinedComponents.length != myNumComps) {
            return false;
        }
        for (int i = 0; i < myNumComps; ++i) {
            DataTypeComponent otherDtc;
            DataTypeComponent myDtc = this.components.get(i);
            if (myDtc.isEquivalent(otherDtc = otherDefinedComponents[i])) continue;
            return false;
        }
        return true;
    }

    private int getAvailableComponentSpace(int index) {
        if (this.isPackingEnabled()) {
            return -1;
        }
        int nextIndex = index + 1;
        if (nextIndex < this.components.size()) {
            DataTypeComponentImpl dtc = this.components.get(index);
            return this.components.get(nextIndex).getOffset() - dtc.getOffset();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (dt instanceof BitFieldDataType) {
            return;
        }
        if (this.isPackingEnabled()) {
            this.repack(true);
            return;
        }
        int oldLength = this.structLength;
        boolean changed = false;
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            int consumed;
            DataTypeComponentImpl dtc = this.components.get(i);
            if (dtc.getDataType() != dt) continue;
            int dtcLen = dtc.getLength();
            int length = this.getPreferredComponentLength(dt, dtcLen, this.getAvailableComponentSpace(i));
            if (length < dtcLen) {
                dtc.setLength(length);
                this.shiftOffsets(i + 1, dtcLen - length, 0);
                changed = true;
                continue;
            }
            if (length <= dtcLen || (consumed = this.consumeBytesAfter(i, length - dtcLen)) <= 0) continue;
            this.shiftOffsets(i + 1, -consumed, 0);
            changed = true;
        }
        if (changed) {
            this.repack(false);
            if (oldLength != this.structLength) {
                this.notifySizeChanged();
            }
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        if (this.isPackingEnabled()) {
            this.repack(true);
        }
    }

    private int consumeBytesAfter(int definedComponentIndex, int numBytes) {
        int available;
        DataTypeComponentImpl thisDtc = this.components.get(definedComponentIndex);
        int thisLen = thisDtc.getLength();
        int nextOffset = thisDtc.getOffset() + thisLen;
        if (definedComponentIndex == this.components.size() - 1) {
            available = this.structLength - nextOffset;
            if (numBytes > available) {
                this.doGrowStructure(numBytes - available);
                available = numBytes;
            }
        } else {
            DataTypeComponent nextDtc = this.components.get(definedComponentIndex + 1);
            available = nextDtc.getOffset() - nextOffset;
        }
        if (numBytes <= available) {
            thisDtc.setLength(thisLen + numBytes);
            return numBytes;
        }
        thisDtc.setLength(thisLen + available);
        return available;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(this.categoryPath, this.getName(), this.structLength, dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public StructureDataType clone(DataTypeManager dtm) {
        if (this.dataMgr == dtm) {
            return this;
        }
        StructureDataType struct = new StructureDataType(this.categoryPath, this.getName(), this.structLength, this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public void clearComponent(int ordinal) {
        if (this.isPackingEnabled()) {
            this.delete(ordinal);
            return;
        }
        if (ordinal < 0 || ordinal >= this.numComponents) {
            throw new IndexOutOfBoundsException(ordinal);
        }
        int idx = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
        if (idx >= 0) {
            DataTypeComponent dtc = this.components.remove(idx);
            dtc.getDataType().removeParent(this);
            int len = dtc.getLength();
            if (len > 1) {
                this.shiftOffsets(idx, len - 1, 0);
            }
            this.repack(false);
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof StructureInternal)) {
            throw new IllegalArgumentException();
        }
        StructureInternal struct = (StructureInternal)dataType;
        this.components.clear();
        this.numComponents = 0;
        this.structLength = 0;
        this.structAlignment = -1;
        this.packing = struct.getStoredPackingValue();
        this.minimumAlignment = struct.getStoredMinimumAlignment();
        if (struct.isPackingEnabled()) {
            this.doReplaceWithPacked(struct);
        } else {
            this.doReplaceWithNonPacked(struct);
        }
        this.repack(false);
        this.notifySizeChanged();
    }

    private void doReplaceWithPacked(Structure struct) {
        DataTypeComponent[] otherComponents;
        for (DataTypeComponent dtc : otherComponents = struct.getDefinedComponents()) {
            DataType dt = dtc.getDataType();
            int length = dt instanceof Dynamic ? dtc.getLength() : -1;
            this.doAdd(dt, length, dtc.getFieldName(), dtc.getComment(), false);
        }
    }

    private void doReplaceWithNonPacked(Structure struct) throws IllegalArgumentException {
        if (struct.isNotYetDefined()) {
            return;
        }
        this.numComponents = this.structLength = struct.isZeroLength() ? 0 : struct.getLength();
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (int i = 0; i < otherComponents.length; ++i) {
            int length;
            DataTypeComponent dtc = otherComponents[i];
            DataType dt = dtc.getDataType().clone(this.dataMgr);
            this.checkAncestry(dt);
            if (dtc.isBitFieldComponent() || dt instanceof Dynamic) {
                length = dtc.getLength();
            } else {
                int nextIndex = i + 1;
                int maxOffset = nextIndex < otherComponents.length ? otherComponents[nextIndex].getOffset() : this.structLength;
                int maxLength = maxOffset - dtc.getOffset();
                length = this.getPreferredComponentLength(dt, -1, maxLength);
            }
            this.components.add(new DataTypeComponentImpl(dt, this, length, dtc.getOrdinal(), dtc.getOffset(), dtc.getFieldName(), dtc.getComment()));
        }
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        boolean changed = false;
        int n = this.components.size();
        for (int i = n - 1; i >= 0; --i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            if (dtc.isBitFieldComponent()) {
                BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
                if (bitfieldDt.getBaseDataType() != dt || !this.updateBitFieldDataType(dtc, dt, bitfieldDt.getPrimitiveBaseDataType())) continue;
                changed = true;
                continue;
            }
            if (dtc.getDataType() != dt) continue;
            this.setComponentDataType(dtc, BadDataType.dataType, i);
            changed = true;
        }
        if (changed && !this.isPackingEnabled()) {
            this.repack(true);
        }
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) throws IllegalArgumentException {
        DataType replacementDt = newDt;
        try {
            replacementDt = this.validateDataType(replacementDt);
            replacementDt = replacementDt.clone(this.dataMgr);
            this.checkAncestry(replacementDt);
        }
        catch (Exception e) {
            replacementDt = this.isPackingEnabled() ? Undefined1DataType.dataType : DataType.DEFAULT;
        }
        boolean changed = false;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            DataTypeComponentImpl comp = this.components.get(i);
            if (comp.isBitFieldComponent()) {
                changed |= this.updateBitFieldDataType(comp, oldDt, replacementDt);
                continue;
            }
            if (comp.getDataType() != oldDt) continue;
            this.setComponentDataType(comp, replacementDt, i);
            changed = true;
        }
        if (changed) {
            this.repack(false);
            this.notifySizeChanged();
        }
    }

    private void setComponentDataType(DataTypeComponentImpl comp, DataType newDt, int index) {
        int consumed;
        comp.getDataType().removeParent(this);
        comp.setDataType(newDt);
        newDt.addParent(this);
        if (this.isPackingEnabled()) {
            return;
        }
        int oldLen = comp.getLength();
        int length = this.getPreferredComponentLength(newDt, oldLen, this.getAvailableComponentSpace(index));
        if (length < oldLen) {
            comp.setLength(length);
            this.shiftOffsets(index + 1, oldLen - length, 0);
        } else if (length > oldLen && (consumed = this.consumeBytesAfter(index, length - oldLen)) > 0) {
            this.shiftOffsets(index + 1, -consumed, 0);
        }
    }

    @Override
    public DataTypeComponent[] getDefinedComponents() {
        return this.components.toArray(new DataTypeComponent[this.components.size()]);
    }

    @Override
    public DataTypeComponent[] getComponents() {
        DataTypeComponent[] comps = new DataTypeComponent[this.numComponents];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = this.getComponent(i);
        }
        return comps;
    }

    private DataTypeComponent doComponentReplacement(LinkedList<DataTypeComponentImpl> replacedComponents, int offset, DataType dataType, int length, String componentName, String comment) {
        DataTypeComponentImpl oldComponent = replacedComponents.get(0);
        DataType oldDt = oldComponent.getDataType();
        if (!(replacedComponents.size() != 1 || oldDt == DEFAULT || dataType == DEFAULT || length != oldComponent.getLength() || offset != oldComponent.getOffset() || this.isPackingEnabled() && dataType.getAlignment() != oldDt.getAlignment())) {
            oldComponent.update(componentName, dataType, comment);
            return oldComponent;
        }
        DataTypeComponent replaceComponent = this.replaceComponents(replacedComponents, dataType, offset, length, componentName, comment);
        this.repack(false);
        this.notifySizeChanged();
        return replaceComponent;
    }

    @Override
    public final DataTypeComponent replace(int index, DataType dataType, int length) {
        return this.replace(index, dataType, length, null, null);
    }

    @Override
    public DataTypeComponent replace(int ordinal, DataType dataType, int length, String componentName, String comment) throws IndexOutOfBoundsException, IllegalArgumentException {
        int offset;
        if (ordinal < 0 || ordinal >= this.numComponents) {
            throw new IndexOutOfBoundsException(ordinal);
        }
        dataType = this.validateDataType(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        length = this.getPreferredComponentLength(dataType, length);
        LinkedList<DataTypeComponentImpl> replacedComponents = new LinkedList<DataTypeComponentImpl>();
        int index = ordinal;
        if (!this.isPackingEnabled()) {
            index = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
        }
        if (index >= 0) {
            origDtc = this.components.get(index);
            offset = origDtc.getOffset();
            if (this.isPackingEnabled() || length == 0) {
                replacedComponents.add(origDtc);
            } else {
                if (origDtc.getLength() == 0) {
                    throw new IllegalArgumentException("Zero-length component may only be replaced with another zero-length component");
                }
                if (origDtc.isBitFieldComponent()) {
                    int i;
                    int minOffset = origDtc.getOffset();
                    int maxOffset = origDtc.getEndOffset();
                    replacedComponents.add(origDtc);
                    for (i = index - 1; i >= 0 && (origDtc = this.components.get(i)).getLength() != 0 && origDtc.containsOffset(minOffset); --i) {
                        replacedComponents.add(0, origDtc);
                    }
                    for (i = index + 1; i < this.components.size() && (origDtc = this.components.get(i)).getLength() != 0 && origDtc.containsOffset(maxOffset); ++i) {
                        replacedComponents.add(origDtc);
                    }
                } else {
                    replacedComponents.add(origDtc);
                }
            }
        } else {
            index = -index - 1;
            offset = ordinal;
            if (index > 0) {
                DataTypeComponent dtc = this.components.get(index - 1);
                offset = dtc.getEndOffset() + ordinal - dtc.getOrdinal();
                if (dtc.getLength() == 0) {
                    --offset;
                }
            }
            origDtc = new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
            if (dataType == DataType.DEFAULT) {
                return origDtc;
            }
            replacedComponents.add(origDtc);
        }
        DataTypeComponent replaceComponent = this.doComponentReplacement(replacedComponents, offset, dataType, length, componentName, comment);
        return replaceComponent != null ? replaceComponent : this.getComponent(ordinal);
    }

    @Override
    public DataTypeComponent replaceAtOffset(int offset, DataType dataType, int length, String componentName, String comment) throws IllegalArgumentException {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (offset >= this.structLength) {
            throw new IllegalArgumentException("Offset " + offset + " is beyond end of structure (" + this.structLength + ").");
        }
        dataType = this.validateDataType(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        LinkedList<DataTypeComponentImpl> replacedComponents = new LinkedList<DataTypeComponentImpl>();
        DataTypeComponentImpl origDtc = null;
        int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
        if (index >= 0) {
            origDtc = this.components.get(index = this.advanceToLastComponentContainingOffset(index, offset));
            if (origDtc.getLength() == 0) {
                if (this.isPackingEnabled()) {
                    return this.insert(index + 1, dataType, length, componentName, comment);
                }
                replacedComponents.add(new DataTypeComponentImpl(DataType.DEFAULT, this, 1, origDtc.getOrdinal() + 1, offset));
            } else if (origDtc.isBitFieldComponent()) {
                replacedComponents.add(origDtc);
                for (int i = index - 1; i >= 0 && (origDtc = this.components.get(i)).getLength() != 0 && origDtc.containsOffset(offset); --i) {
                    replacedComponents.add(0, origDtc);
                }
            } else {
                replacedComponents.add(origDtc);
            }
        } else {
            index = -index - 1;
            if (this.isPackingEnabled()) {
                return this.insert(index, dataType, length, componentName, comment);
            }
            int ordinal = offset;
            if (index > 0) {
                DataTypeComponent dtc = this.components.get(index - 1);
                ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
            }
            origDtc = new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
            if (dataType == DataType.DEFAULT) {
                return origDtc;
            }
            replacedComponents.add(origDtc);
        }
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponent replaceComponent = this.doComponentReplacement(replacedComponents, offset, dataType, length, componentName, comment);
        return replaceComponent != null ? replaceComponent : this.getComponentContaining(offset);
    }

    private void checkUndefinedSpaceAvailabilityAfter(int lastOrdinalReplacedOrUpdated, int bytesNeeded, DataType newDataType, int offset) throws IllegalArgumentException {
        if (bytesNeeded <= 0) {
            return;
        }
        int bytesAvailable = this.getNumUndefinedBytes(lastOrdinalReplacedOrUpdated + 1);
        if (bytesAvailable < bytesNeeded) {
            if (lastOrdinalReplacedOrUpdated == this.getLastDefinedComponentOrdinal()) {
                this.growStructure(bytesNeeded - bytesAvailable);
            } else {
                throw new IllegalArgumentException("Not enough undefined bytes to fit " + newDataType.getPathName() + " in structure " + this.getPathName() + " at offset 0x" + Integer.toHexString(offset) + ". It needs " + (bytesNeeded - bytesAvailable) + " more byte(s) to be able to fit.");
            }
        }
    }

    private DataTypeComponent replaceComponents(LinkedList<DataTypeComponentImpl> origComponents, DataType dataType, int newOffset, int length, String fieldName, String comment) throws IllegalArgumentException {
        int index;
        boolean clearOnly = false;
        if (dataType == DataType.DEFAULT) {
            clearOnly = true;
            length = 0;
        }
        DataTypeComponentImpl origFirstDtc = origComponents.getFirst();
        DataTypeComponentImpl origLastDtc = origComponents.getLast();
        int origFirstOrdinal = origFirstDtc.getOrdinal();
        int origLastOrdinal = origLastDtc.getOrdinal();
        int minReplacedOffset = origFirstDtc.getOffset();
        int maxReplacedOffset = origLastDtc.getEndOffset();
        if (newOffset < minReplacedOffset || newOffset > maxReplacedOffset) {
            throw new AssertException("newOffset not contained within origComponents");
        }
        if (origComponents.size() > 1) {
            int checkOrdinal = origFirstOrdinal;
            for (DataTypeComponentImpl origDtc : origComponents) {
                if (origDtc.isUndefined()) {
                    throw new AssertException("undefined component within multi-component sequence");
                }
                if (origDtc.getOrdinal() == checkOrdinal++) continue;
                throw new AssertException("non-sequential components specified");
            }
        }
        int leadingUnusedBytes = newOffset - minReplacedOffset;
        int newOrdinal = origFirstOrdinal;
        if (!this.isPackingEnabled()) {
            newOrdinal += leadingUnusedBytes;
        }
        int origLength = 0;
        if (origLastDtc.getLength() != 0) {
            origLength = maxReplacedOffset - minReplacedOffset + 1;
        }
        if (!clearOnly && !this.isPackingEnabled()) {
            int bytesNeeded = length - origLength + leadingUnusedBytes;
            this.checkUndefinedSpaceAvailabilityAfter(origLastOrdinal, bytesNeeded, dataType, newOffset);
        }
        if ((index = this.isPackingEnabled() ? newOrdinal : Collections.binarySearch(this.components, origFirstOrdinal, CompositeInternal.OrdinalComparator.INSTANCE)) < 0) {
            index = -index - 1;
        } else {
            for (DataTypeComponentImpl origDtc : origComponents) {
                DataTypeComponentImpl dtc = this.doDelete(index);
                if (dtc == origDtc) continue;
                throw new AssertException("component replacement mismatch");
            }
        }
        DataTypeComponentImpl newDtc = null;
        if (!clearOnly) {
            newDtc = new DataTypeComponentImpl(dataType, this, length, newOrdinal, newOffset, fieldName, comment);
            this.components.add(index, newDtc);
        }
        if (!this.isPackingEnabled()) {
            int deltaOrdinal = -origComponents.size() + origLength - length;
            this.shiftOffsets(index + 1, deltaOrdinal, 0);
        }
        return newDtc;
    }

    private int getLastDefinedComponentOrdinal() {
        if (this.components.size() == 0) {
            return 0;
        }
        DataTypeComponent dataTypeComponent = this.components.get(this.components.size() - 1);
        return dataTypeComponent.getOrdinal();
    }

    protected int getNumUndefinedBytes(int index) {
        if (index >= this.numComponents) {
            return 0;
        }
        int idx = Collections.binarySearch(this.components, index, CompositeInternal.OrdinalComparator.INSTANCE);
        DataTypeComponent dtc = null;
        if (idx < 0) {
            if ((idx = -idx - 1) >= this.components.size()) {
                return this.numComponents - index;
            }
            dtc = this.components.get(idx);
            return dtc.getOrdinal() - index;
        }
        return 0;
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public void deleteAll() {
        for (DataTypeComponentImpl dtc : this.components) {
            dtc.getDataType().removeParent(this);
        }
        this.components.clear();
        this.structLength = 0;
        this.numComponents = 0;
        this.notifySizeChanged();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    @Override
    public boolean repack(boolean notify) {
        boolean changed;
        int oldLength = this.structLength;
        int oldAlignment = this.getAlignment();
        if (!this.isPackingEnabled()) {
            changed = this.adjustNonPackedComponents();
        } else {
            AlignedStructurePacker.StructurePackResult packResult = AlignedStructurePacker.packComponents(this, this.components);
            changed = packResult.componentsChanged;
            changed |= this.structLength != packResult.structureLength || this.structAlignment != packResult.alignment || this.numComponents != packResult.numComponents;
            this.structLength = packResult.structureLength;
            this.structAlignment = packResult.alignment;
            this.numComponents = this.components.size();
        }
        if (changed && notify) {
            if (oldLength != this.structLength) {
                this.notifySizeChanged();
            } else if (oldAlignment != this.structAlignment) {
                this.notifyAlignmentChanged();
            }
        }
        return changed;
    }

    private boolean adjustNonPackedComponents() {
        int alignment;
        boolean changed = false;
        int componentCount = 0;
        int currentOffset = 0;
        for (DataTypeComponentImpl dataTypeComponent : this.components) {
            int componentLength = dataTypeComponent.getLength();
            int componentOffset = dataTypeComponent.getOffset();
            int numUndefinedsBefore = componentOffset - currentOffset;
            if (numUndefinedsBefore > 0) {
                componentCount += numUndefinedsBefore;
            }
            currentOffset = componentOffset + componentLength;
            if (dataTypeComponent.getOrdinal() != componentCount) {
                dataTypeComponent.setOrdinal(componentCount);
                changed = true;
            }
            ++componentCount;
        }
        int numUndefinedsAfter = this.structLength - currentOffset;
        if (this.numComponents != (componentCount += numUndefinedsAfter)) {
            this.numComponents = componentCount;
            changed = true;
        }
        if ((alignment = this.getNonPackedAlignment()) != this.structAlignment) {
            this.structAlignment = alignment;
            changed = true;
        }
        return changed;
    }

    private void doGrowStructure(int amount) {
        if (this.isPackingEnabled()) {
            throw new AssertException("only valid for non-packed");
        }
        this.numComponents += amount;
        this.structLength += amount;
    }
}

