/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.gclass;

import ghidra.app.util.SymbolPath;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.gclass.ClassID;

public class ClassUtils {
    public static final String VBPTR = "{vbptr}";
    public static final String VFPTR = "{vfptr}";
    public static final PointerDataType VXPTR_TYPE = new PointerDataType();
    private static final String VTABLE_PREFIX = "VTABLE_";

    private ClassUtils() {
    }

    public static CategoryPath getClassInternalsPath(Composite composite) {
        DataTypePath dtp = composite.getDataTypePath();
        return ClassUtils.getClassInternalsPath(dtp.getCategoryPath(), dtp.getDataTypeName());
    }

    public static CategoryPath getClassInternalsPath(ClassID id) {
        CategoryPath cp = ClassUtils.recurseGetCategoryPath(id.getCategoryPath(), id.getSymbolPath());
        return cp.extend("!internal");
    }

    public static CategoryPath getClassInternalsPath(CategoryPath path, String className) {
        return new CategoryPath(new CategoryPath(path, className), "!internal");
    }

    public static DataTypePath getBaseClassDataTypePath(Composite composite) {
        return new DataTypePath(ClassUtils.getClassInternalsPath(composite), composite.getName());
    }

    public static Composite getSelfBaseType(Composite composite) {
        Structure struct;
        DataTypeComponent component;
        DataType componentType;
        DataTypePath dtp;
        DataTypeManager dtm = composite.getDataTypeManager();
        DataType dt = dtm.getDataType(dtp = ClassUtils.getBaseClassDataTypePath(composite));
        if (dt instanceof Composite) {
            Composite base = (Composite)dt;
            return base;
        }
        if (composite.getNumComponents() > 0 && (componentType = (component = composite.getComponent(0)).getDataType()) instanceof Structure && (struct = (Structure)componentType).getDataTypePath().equals(dtp)) {
            return struct;
        }
        return composite;
    }

    public static String getSpecialVxTableName(long ptrOffsetInClass) {
        return String.format("%s%08x", VTABLE_PREFIX, ptrOffsetInClass);
    }

    public static boolean isVTable(DataType type) {
        if (!(type instanceof Structure)) {
            return false;
        }
        String name = type.getName();
        return ClassUtils.validateVtableNameOffset(name) != null;
    }

    private static Integer validateVtableNameOffset(String name) {
        if (name == null) {
            return null;
        }
        if (!name.startsWith(VTABLE_PREFIX)) {
            return null;
        }
        if (name.length() < VTABLE_PREFIX.length() + 8) {
            return null;
        }
        String sub = name.substring(VTABLE_PREFIX.length(), VTABLE_PREFIX.length() + 8);
        try {
            return Integer.parseInt(sub, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static DataType getVftDefaultEntry(DataTypeManager dtm) {
        return new PointerDataType(dtm);
    }

    public static DataType getVbtDefaultEntry(DataTypeManager dtm) {
        return new IntegerDataType(dtm);
    }

    public static int getVftEntrySize(DataTypeManager dtm) {
        return dtm.getDataOrganization().getPointerSize();
    }

    public static int getVbtEntrySize(DataTypeManager dtm) {
        return dtm.getDataOrganization().getIntegerSize();
    }

    private static CategoryPath recurseGetCategoryPath(CategoryPath category, SymbolPath symbolPath) {
        SymbolPath parent = symbolPath.getParent();
        if (parent != null) {
            category = ClassUtils.recurseGetCategoryPath(category, parent);
        }
        return new CategoryPath(category, symbolPath.getName());
    }
}

