/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.util.ProcessorSymbolType;

public class AddressLabelInfo
implements Comparable<AddressLabelInfo> {
    private Address addr;
    private Address endAddr;
    private String label;
    private String description;
    private boolean isPrimary;
    private boolean isEntry;
    private ProcessorSymbolType processorSymbolType;
    private int sizeInBytes;
    private Boolean isVolatile;

    public AddressLabelInfo(Address addr, Integer sizeInBytes, String label, String description, boolean isPrimary, boolean isEntry, ProcessorSymbolType type, Boolean isVolatile) throws AddressOverflowException {
        this.addr = addr;
        this.sizeInBytes = sizeInBytes == null || sizeInBytes <= 0 ? addr.getAddressSpace().getAddressableUnitSize() : sizeInBytes.intValue();
        this.endAddr = this.addr.addNoWrap(this.sizeInBytes - 1);
        this.label = label;
        this.description = description;
        this.isPrimary = isPrimary;
        this.isEntry = isEntry;
        this.processorSymbolType = type;
        this.isVolatile = isVolatile;
    }

    public final Address getAddress() {
        return this.addr;
    }

    public final Address getEndAddress() {
        return this.endAddr;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getByteSize() {
        return this.sizeInBytes;
    }

    public final boolean isPrimary() {
        return this.isPrimary;
    }

    public final Boolean isVolatile() {
        return this.isVolatile;
    }

    public ProcessorSymbolType getProcessorSymbolType() {
        return this.processorSymbolType;
    }

    @Override
    public int compareTo(AddressLabelInfo info) {
        if (info == null) {
            return 1;
        }
        String addrStr = info.getAddress().toString();
        String thisStr = this.getAddress().toString();
        int stringCompare = thisStr.compareTo(addrStr);
        if (stringCompare != 0) {
            return stringCompare;
        }
        String addrLabel = info.getLabel();
        String thisLabel = this.getLabel();
        if (addrLabel == null) {
            if (thisLabel == null) {
                return 0;
            }
            return 1;
        }
        if (thisLabel == null) {
            return -1;
        }
        return thisLabel.compareTo(addrLabel);
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LABEL INFO NAME=");
        buf.append(this.label);
        buf.append(", ");
        buf.append("ADDR=" + String.valueOf(this.addr));
        buf.append(", ");
        buf.append("isEntry = " + this.isEntry);
        buf.append(", ");
        buf.append("type = " + String.valueOf((Object)this.processorSymbolType));
        if (this.description != null) {
            buf.append("description = " + this.description);
        }
        return buf.toString();
    }
}

