/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;

public final class ContextSetting {
    private Register register;
    private BigInteger value;
    private Address startAddr;
    private Address endAddr;

    public ContextSetting(Register register, BigInteger value, Address startAddr, Address endAddr) {
        this.value = value;
        this.register = register;
        this.startAddr = startAddr;
        this.endAddr = endAddr;
    }

    private ContextSetting(XmlElement el, CompilerSpec cspec, boolean isContextReg, Address first, Address last) throws SleighException {
        this.startAddr = first;
        this.endAddr = last;
        String name = el.getAttribute("name");
        this.value = this.getBigInteger(el.getAttribute("val"), 0L);
        this.register = cspec.getLanguage().getRegister(name);
        if (this.register == null) {
            throw new SleighException("Unknown register: " + name);
        }
        if (isContextReg) {
            if (!this.register.isProcessorContext()) {
                throw new SleighException("Register " + name + " is not a context register");
            }
        } else if (this.register.isProcessorContext()) {
            throw new SleighException("Unexpected context register " + name);
        }
    }

    public Register getRegister() {
        return this.register;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public Address getStartAddress() {
        return this.startAddr;
    }

    public Address getEndAddress() {
        return this.endAddr;
    }

    private BigInteger getBigInteger(String valStr, long defaultValue) {
        int radix = 10;
        if (valStr.startsWith("0x") || valStr.startsWith("0X")) {
            valStr = valStr.substring(2);
            radix = 16;
        }
        try {
            return new BigInteger(valStr, radix);
        }
        catch (Exception e) {
            return BigInteger.valueOf(defaultValue);
        }
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_SET);
        encoder.writeString(AttributeId.ATTRIB_NAME, this.register.getName());
        encoder.writeString(AttributeId.ATTRIB_VAL, this.value.toString());
        encoder.closeElement(ElementId.ELEM_SET);
    }

    public boolean isEquivalent(ContextSetting obj) {
        if (!this.startAddr.equals(obj.startAddr)) {
            return false;
        }
        if (!this.endAddr.equals(obj.endAddr)) {
            return false;
        }
        if (!this.register.equals(obj.register)) {
            return false;
        }
        return this.value.equals(obj.value);
    }

    public static void parseContextSet(List<ContextSetting> resList, XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        boolean isContextReg;
        XmlElement el = parser.start(new String[0]);
        if (el.getName().equals("context_set")) {
            isContextReg = true;
        } else if (el.getName().equals("tracked_set")) {
            isContextReg = false;
        } else {
            throw new XmlParseException("Unknown context setting tag: " + el.getName());
        }
        AddressXML range = AddressXML.restoreRangeXml(el, cspec);
        Address firstAddr = range.getFirstAddress();
        Address lastAddr = range.getLastAddress();
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            ContextSetting ctxSetting = new ContextSetting(subel, cspec, isContextReg, firstAddr, lastAddr);
            parser.end(subel);
            resList.add(ctxSetting);
        }
        parser.end(el);
    }

    public static void parseContextData(List<ContextSetting> resList, XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            ContextSetting.parseContextSet(resList, parser, cspec);
        }
        parser.end();
    }

    public static void encodeContextData(Encoder encoder, List<ContextSetting> ctxList) throws IOException {
        if (ctxList.isEmpty()) {
            return;
        }
        encoder.openElement(ElementId.ELEM_CONTEXT_DATA);
        Iterator<ContextSetting> iter = ctxList.iterator();
        ContextSetting startContext = iter.next();
        boolean isContextReg = startContext.register.isProcessorContext();
        Address firstAddr = startContext.startAddr;
        Address lastAddr = startContext.endAddr;
        while (iter.hasNext()) {
            encoder.openElement(isContextReg ? ElementId.ELEM_CONTEXT_SET : ElementId.ELEM_TRACKED_SET);
            AddressXML.encodeAttributes(encoder, firstAddr, lastAddr);
            startContext.encode(encoder);
            while (iter.hasNext()) {
                startContext = iter.next();
                boolean nextIsContext = startContext.register.isProcessorContext();
                boolean shouldBreak = false;
                if (isContextReg != nextIsContext) {
                    isContextReg = nextIsContext;
                    shouldBreak = true;
                }
                if (!firstAddr.equals(startContext.startAddr)) {
                    firstAddr = startContext.startAddr;
                    shouldBreak = true;
                }
                if (!lastAddr.equals(startContext.endAddr)) {
                    lastAddr = startContext.endAddr;
                    shouldBreak = true;
                }
                if (shouldBreak) break;
                startContext.encode(encoder);
            }
            encoder.closeElement(isContextReg ? ElementId.ELEM_CONTEXT_SET : ElementId.ELEM_TRACKED_SET);
        }
        encoder.closeElement(ElementId.ELEM_CONTEXT_DATA);
    }
}

