/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;

public class DynamicVariableStorage
extends VariableStorage {
    public static final DynamicVariableStorage INDIRECT_VOID_STORAGE = new DynamicVariableStorage();
    private AutoParameterType autoParamType;
    private boolean forcedIndirect;
    private boolean isUnassigned = false;
    private boolean isVoid = false;

    private DynamicVariableStorage() {
        this.forcedIndirect = true;
        this.isVoid = true;
    }

    private DynamicVariableStorage(AutoParameterType autoParamType) {
        this.autoParamType = autoParamType;
        this.isUnassigned = true;
    }

    private DynamicVariableStorage(boolean forcedIndirect) {
        this.forcedIndirect = forcedIndirect;
        this.isUnassigned = true;
    }

    public DynamicVariableStorage(ProgramArchitecture program, AutoParameterType autoParamType, Address address, int size) throws InvalidInputException {
        super(program, address, size);
        this.autoParamType = autoParamType;
    }

    public DynamicVariableStorage(ProgramArchitecture program, AutoParameterType autoParamType, Varnode ... varnodes) throws InvalidInputException {
        super(program, varnodes);
        this.autoParamType = autoParamType;
    }

    public DynamicVariableStorage(ProgramArchitecture program, boolean forcedIndirect, Address address, int size) throws InvalidInputException {
        super(program, address, size);
        this.forcedIndirect = forcedIndirect;
    }

    public DynamicVariableStorage(ProgramArchitecture program, boolean forcedIndirect, Varnode ... varnodes) throws InvalidInputException {
        super(program, varnodes);
        this.forcedIndirect = forcedIndirect;
    }

    @Override
    public boolean isForcedIndirect() {
        return this.forcedIndirect;
    }

    @Override
    public boolean isAutoStorage() {
        return this.autoParamType != null;
    }

    @Override
    public boolean isUnassignedStorage() {
        return this.isUnassigned;
    }

    @Override
    public boolean isVoidStorage() {
        return this.isVoid;
    }

    @Override
    public AutoParameterType getAutoParameterType() {
        return this.autoParamType;
    }

    @Override
    public String toString() {
        Object str = super.toString();
        if (this.forcedIndirect && this.varnodes != null) {
            str = (String)str + " (ptr)";
        }
        if (this.autoParamType != null) {
            str = (String)str + " (auto)";
        }
        return str;
    }

    public static DynamicVariableStorage getUnassignedDynamicStorage(AutoParameterType autoParamType) {
        return new DynamicVariableStorage(autoParamType);
    }

    public static DynamicVariableStorage getUnassignedDynamicStorage(boolean forcedIndirect) {
        return new DynamicVariableStorage(forcedIndirect);
    }
}

