/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import generic.stl.VectorSTL;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolTable;
import ghidra.app.plugin.processors.sleigh.symbol.UseropSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.HandleTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.pcode.utils.MessageFormattingUtils;
import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slgh_compile.ExprTree;
import ghidra.pcodeCPort.slgh_compile.PcodeCompile;
import ghidra.pcodeCPort.slgh_compile.SectionVector;
import ghidra.pcodeCPort.slghsymbol.EndSymbol;
import ghidra.pcodeCPort.slghsymbol.FlowDestSymbol;
import ghidra.pcodeCPort.slghsymbol.FlowRefSymbol;
import ghidra.pcodeCPort.slghsymbol.LabelSymbol;
import ghidra.pcodeCPort.slghsymbol.MacroSymbol;
import ghidra.pcodeCPort.slghsymbol.Next2Symbol;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SectionSymbol;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.SpaceSymbol;
import ghidra.pcodeCPort.slghsymbol.StartSymbol;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.ConstantSpace;
import ghidra.pcodeCPort.space.OtherSpace;
import ghidra.pcodeCPort.space.UniqueSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.sleigh.grammar.BailoutException;
import ghidra.sleigh.grammar.LineArrayListWriter;
import ghidra.sleigh.grammar.Location;
import ghidra.sleigh.grammar.ParsingEnvironment;
import ghidra.sleigh.grammar.SleighCompiler;
import ghidra.sleigh.grammar.SleighLexer;
import ghidra.sleigh.grammar.SleighParser;
import ghidra.sleigh.grammar.SleighParser_SemanticParser;
import ghidra.util.exception.AssertException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.UnbufferedTokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;

public class PcodeParser
extends PcodeCompile {
    private SleighBase sleigh;
    private AddressFactory addrFactory;
    private long tempbase;
    private HashMap<String, SleighSymbol> symbolMap = new HashMap();
    private HashSet<String> currentSymbols = new HashSet();

    protected PcodeParser(SleighBase sleigh) {
        this.sleigh = sleigh;
        this.initializeSymbols();
    }

    public PcodeParser(SleighLanguage language, long ubase) {
        this.addrFactory = language.getAddressFactory();
        this.sleigh = new PcodeTranslate(language, ubase);
        this.initializeSymbols();
    }

    private void initializeSymbols() {
        this.tempbase = this.sleigh.getUniqueBase();
        Location internalLoc = Location.INTERNALLY_DEFINED;
        this.symbolMap.put("inst_start", new StartSymbol(internalLoc, "inst_start", this.getConstantSpace()));
        this.symbolMap.put("inst_next", new EndSymbol(internalLoc, "inst_next", this.getConstantSpace()));
        this.symbolMap.put("inst_next2", new Next2Symbol(internalLoc, "inst_next2", this.getConstantSpace()));
        this.symbolMap.put("inst_ref", new FlowRefSymbol(internalLoc, "inst_ref", this.getConstantSpace()));
        this.symbolMap.put("inst_dest", new FlowDestSymbol(internalLoc, "inst_dest", this.getConstantSpace()));
    }

    public void addOperand(Location loc, String name, int index) {
        OperandSymbol sym = new OperandSymbol(loc, name, index, null);
        this.addSymbol(sym);
    }

    @Override
    public void addSymbol(SleighSymbol sym) {
        SleighSymbol s = this.sleigh.findSymbol(sym.getName());
        if (s == null) {
            s = this.symbolMap.get(sym.getName());
        }
        if (s != null) {
            if (s != sym) {
                throw new SleighError("Duplicate symbol name: " + sym.getName() + " (previously defined at " + String.valueOf(s.location) + ")", sym.getLocation());
            }
        } else {
            this.symbolMap.put(sym.getName(), sym);
            this.currentSymbols.add(sym.getName());
        }
    }

    public void clearSymbols() {
        for (String symbol : this.currentSymbols) {
            this.symbolMap.remove(symbol);
        }
        this.currentSymbols.clear();
    }

    public long getNextTempOffset() {
        return this.tempbase;
    }

    @Override
    public long allocateTemp() {
        long base = this.tempbase;
        this.tempbase = base + 128L;
        return base;
    }

    @Override
    public VectorSTL<OpTpl> createMacroUse(Location location, MacroSymbol sym, VectorSTL<ExprTree> param) {
        throw new SleighError("Pcode snippet parsing does not support use of macros", location);
    }

    @Override
    public SleighSymbol findSymbol(String nm) {
        SleighSymbol sym = this.symbolMap.get(nm);
        if (sym != null) {
            return sym;
        }
        return this.sleigh.findSymbol(nm);
    }

    public SleighBase getSleigh() {
        return this.sleigh;
    }

    @Override
    public AddrSpace getConstantSpace() {
        return this.sleigh.getConstantSpace();
    }

    @Override
    public AddrSpace getDefaultSpace() {
        return this.sleigh.getDefaultSpace();
    }

    @Override
    public AddrSpace getUniqueSpace() {
        return this.sleigh.getUniqueSpace();
    }

    @Override
    public void recordNop(Location location) {
    }

    private String checkLabels() {
        ArrayList<String> errors = new ArrayList<String>();
        for (SleighSymbol sym : this.symbolMap.values()) {
            if (sym.getType() != symbol_type.label_symbol) continue;
            LabelSymbol labsym = (LabelSymbol)sym;
            if (labsym.getRefCount() == 0) {
                errors.add(MessageFormattingUtils.format(labsym.location, String.format("Label <%s> was placed but never used", sym.getName())));
                continue;
            }
            if (labsym.isPlaced()) continue;
            errors.add(MessageFormattingUtils.format(labsym.location, String.format("Label <%s> was referenced but never placed", sym.getName())));
        }
        return errors.stream().collect(Collectors.joining("  "));
    }

    private ConstructTpl buildConstructor(ghidra.pcodeCPort.semantics.ConstructTpl rtl) {
        String errstring = "";
        if (rtl != null) {
            errstring = this.checkLabels();
            if (errstring.length() == 0 && !this.propagateSize(rtl)) {
                errstring = "   Could not resolve at least 1 variable size";
            }
            if (errstring.length() == 0 && rtl.delaySlot() != 0) {
                errstring = "   delayslot not permitted in pcode fragment";
            }
            if (rtl.getResult() != null) {
                errstring = "   export not permitted in pcode fragment";
            }
        }
        if (errstring.length() != 0) {
            throw new SleighException(errstring);
        }
        return this.translateConstructTpl(rtl);
    }

    public ConstructTpl translateConstructTpl(ghidra.pcodeCPort.semantics.ConstructTpl constructTpl) {
        HandleTpl handle = null;
        if (constructTpl.getResult() != null) {
            handle = this.translateHandleTpl(constructTpl.getResult());
        }
        ghidra.app.plugin.processors.sleigh.template.OpTpl[] vec = new ghidra.app.plugin.processors.sleigh.template.OpTpl[constructTpl.getOpvec().size()];
        for (int i = 0; i < vec.length; ++i) {
            vec[i] = this.translateOpTpl((OpTpl)constructTpl.getOpvec().get(i));
        }
        return new ConstructTpl(vec, handle, constructTpl.numLabels());
    }

    public HandleTpl translateHandleTpl(ghidra.pcodeCPort.semantics.HandleTpl handleTpl) {
        return new HandleTpl(this.translateConstTpl(handleTpl.getSpace()), this.translateConstTpl(handleTpl.getSize()), this.translateConstTpl(handleTpl.getPtrSpace()), this.translateConstTpl(handleTpl.getPtrOffset()), this.translateConstTpl(handleTpl.getPtrSize()), this.translateConstTpl(handleTpl.getTempSpace()), this.translateConstTpl(handleTpl.getTempOffset()));
    }

    public ghidra.app.plugin.processors.sleigh.template.OpTpl translateOpTpl(OpTpl opTpl) {
        VarnodeTpl output = null;
        if (opTpl.getOut() != null) {
            output = this.translateVarnodeTpl(opTpl.getOut());
        }
        VarnodeTpl[] input = new VarnodeTpl[opTpl.numInput()];
        for (int i = 0; i < input.length; ++i) {
            input[i] = this.translateVarnodeTpl(opTpl.getIn(i));
        }
        return new ghidra.app.plugin.processors.sleigh.template.OpTpl(opTpl.getOpcode().ordinal(), output, input);
    }

    public VarnodeTpl translateVarnodeTpl(ghidra.pcodeCPort.semantics.VarnodeTpl varnodeTpl) {
        return new VarnodeTpl(this.translateConstTpl(varnodeTpl.getSpace()), this.translateConstTpl(varnodeTpl.getOffset()), this.translateConstTpl(varnodeTpl.getSize()));
    }

    public ConstTpl translateConstTpl(ghidra.pcodeCPort.semantics.ConstTpl constTpl) {
        AddrSpace spc = constTpl.getSpace();
        AddressSpace resSpace = null;
        if (spc != null) {
            resSpace = this.addrFactory.getAddressSpace(spc.getName());
        }
        int select = 0;
        ConstTpl.v_field field = constTpl.getSelect();
        if (field != null) {
            select = field.ordinal();
        }
        return new ConstTpl(constTpl.getType().ordinal(), constTpl.getReal(), resSpace, constTpl.getHandleIndex(), select);
    }

    public ConstructTpl compilePcode(String pcodeStatements, String srcFile, int srcLine) throws SleighException {
        ConstructTpl constructTpl;
        LineArrayListWriter writer = null;
        try {
            String line;
            writer = new LineArrayListWriter();
            ParsingEnvironment env = new ParsingEnvironment(writer);
            BufferedReader r = new BufferedReader(new StringReader(pcodeStatements));
            while ((line = r.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
            ANTLRStringStream input = new ANTLRStringStream(writer.toString());
            env.getLocator().registerLocation(input.getLine(), new Location(srcFile, srcLine));
            SleighLexer lex = new SleighLexer((CharStream)input);
            lex.setEnv(env);
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lex);
            SleighParser parser = new SleighParser((TokenStream)tokens);
            parser.setEnv(env);
            parser.setLexer(lex);
            lex.pushMode(2);
            SleighParser_SemanticParser.semantic_return semantic = parser.semantic();
            lex.popMode();
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)semantic.getTree());
            nodes.setTokenStream((TokenStream)tokens);
            SleighCompiler walker = new SleighCompiler((TreeNodeStream)nodes);
            SectionVector rtl = walker.semantic(env, null, this, (Tree)semantic.getTree(), false, false);
            if (this.getErrors() != 0) {
                ConstructTpl constructTpl2 = null;
                return constructTpl2;
            }
            ConstructTpl result = null;
            if (rtl != null) {
                result = this.buildConstructor(rtl.getMainSection());
            }
            constructTpl = result;
        }
        catch (IOException e) {
            throw new AssertException();
        }
        catch (RecognitionException e) {
            throw new SleighException("Semantic compilation error: " + e.getMessage(), e);
        }
        catch (BailoutException e) {
            throw new SleighException("Unrecoverable error(s), halting compilation", e);
        }
        catch (NullPointerException e) {
            throw new SleighException("Unrecoverable error(s), halting compilation", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return constructTpl;
    }

    @Override
    public SectionSymbol newSectionSymbol(Location where, String text) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", where);
    }

    @Override
    public VectorSTL<OpTpl> createCrossBuild(Location where, ghidra.pcodeCPort.semantics.VarnodeTpl v, SectionSymbol second) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", where);
    }

    @Override
    public SectionVector standaloneSection(ghidra.pcodeCPort.semantics.ConstructTpl main) {
        SectionVector res = new SectionVector(main, null);
        return res;
    }

    @Override
    public SectionVector firstNamedSection(ghidra.pcodeCPort.semantics.ConstructTpl main, SectionSymbol sym) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", sym.location);
    }

    @Override
    public SectionVector nextNamedSection(SectionVector vec, ghidra.pcodeCPort.semantics.ConstructTpl section, SectionSymbol sym) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", sym.location);
    }

    @Override
    public SectionVector finalNamedSection(SectionVector vec, ghidra.pcodeCPort.semantics.ConstructTpl section) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", null);
    }

    public static class PcodeTranslate
    extends SleighBase {
        private void copySpaces(SleighLanguage language) {
            AddressSpace[] spaces;
            this.insertSpace(new ConstantSpace(this));
            this.insertSpace(new OtherSpace(this, "OTHER", 1));
            for (AddressSpace spc : spaces = language.getAddressFactory().getAllAddressSpaces()) {
                if (spc.getUnique() < 2) continue;
                int sz = spc.getSize();
                if (spc instanceof SegmentedAddressSpace) {
                    sz = 32;
                }
                if (sz > 64) {
                    sz = 64;
                }
                int bytesize = (sz + 7) / 8;
                AddrSpace resSpace = switch (spc.getType()) {
                    case 3 -> new UniqueSpace(this, spc.getUnique(), 0);
                    case 7 -> new OtherSpace(this, spc.getName(), spc.getUnique());
                    case 1 -> new AddrSpace(this, spacetype.IPTR_PROCESSOR, spc.getName(), bytesize, spc.getAddressableUnitSize(), spc.getUnique(), 256, 1);
                    case 4 -> new AddrSpace(this, spacetype.IPTR_PROCESSOR, spc.getName(), bytesize, spc.getAddressableUnitSize(), spc.getUnique(), 256, 0);
                    default -> null;
                };
                if (resSpace == null) break;
                this.insertSpace(resSpace);
            }
            this.setDefaultSpace(language.getDefaultSpace().getUnique());
        }

        private void copySymbols(SleighLanguage language) {
            SymbolTable langTable = language.getSymbolTable();
            this.symtab.addScope();
            for (Symbol sym : langTable.getSymbolList()) {
                if (sym instanceof UseropSymbol) {
                    UserOpSymbol cloneSym = new UserOpSymbol(null, sym.getName());
                    cloneSym.setIndex(((UseropSymbol)sym).getIndex());
                    this.symtab.addSymbol(cloneSym);
                    continue;
                }
                if (!(sym instanceof VarnodeSymbol)) continue;
                VarnodeData vData = ((VarnodeSymbol)sym).getFixedVarnode();
                if ("contextreg".equals(sym.getName())) continue;
                AddrSpace base = this.getSpace(vData.space.getUnique());
                ghidra.pcodeCPort.slghsymbol.VarnodeSymbol cloneSym = new ghidra.pcodeCPort.slghsymbol.VarnodeSymbol(null, sym.getName(), base, vData.offset, vData.size);
                this.symtab.addSymbol(cloneSym);
            }
        }

        public PcodeTranslate(SleighLanguage language, long ubase) {
            this.target_endian = language.isBigEndian() ? 1 : 0;
            this.alignment = 0;
            this.setUniqueBase(ubase);
            this.copySpaces(language);
            this.copySymbols(language);
            for (int i = 0; i < this.numSpaces(); ++i) {
                AddrSpace space = this.getSpace(i);
                this.symtab.addSymbol(new SpaceSymbol(null, space));
            }
        }

        @Override
        public int printAssembly(PrintStream s, int size, Address baseaddr) {
            return 0;
        }

        @Override
        public int instructionLength(Address baseaddr) {
            return 0;
        }
    }
}

