/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.listing.Data;
import java.util.Arrays;
import java.util.Iterator;

public interface DataIterator
extends Iterator<Data>,
Iterable<Data> {
    public static final DataIterator EMPTY = DataIterator.of(new Data[0]);

    public static DataIterator of(Data ... dataInstances) {
        return new IteratorWrapper(Arrays.asList(dataInstances).iterator());
    }

    @Override
    public boolean hasNext();

    @Override
    public Data next();

    @Override
    default public Iterator<Data> iterator() {
        return this;
    }

    public static class IteratorWrapper
    implements DataIterator {
        private Iterator<Data> it;

        IteratorWrapper(Iterator<Data> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Data next() {
            return this.it.next();
        }
    }
}

