/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;

public interface VariableFilter {
    public static final VariableFilter PARAMETER_FILTER = new ParameterFilter(true);
    public static final VariableFilter NONAUTO_PARAMETER_FILTER = new ParameterFilter(false);
    public static final VariableFilter LOCAL_VARIABLE_FILTER = new LocalVariableFilter();
    public static final VariableFilter STACK_VARIABLE_FILTER = new StackVariableFilter();
    public static final VariableFilter COMPOUND_STACK_VARIABLE_FILTER = new CompoundStackVariableFilter();
    public static final VariableFilter REGISTER_VARIABLE_FILTER = new RegisterVariableFilter();
    public static final VariableFilter MEMORY_VARIABLE_FILTER = new MemoryVariableFilter();
    public static final VariableFilter UNIQUE_VARIABLE_FILTER = new UniqueVariableFilter();

    public boolean matches(Variable var1);

    public static class ParameterFilter
    implements VariableFilter {
        private final boolean allowAutoParams;

        public ParameterFilter(boolean allowAutoParams) {
            this.allowAutoParams = allowAutoParams;
        }

        @Override
        public boolean matches(Variable variable) {
            if (variable instanceof Parameter) {
                Parameter p = (Parameter)variable;
                return !p.isAutoParameter() || this.allowAutoParams;
            }
            return false;
        }
    }

    public static class LocalVariableFilter
    implements VariableFilter {
        @Override
        public boolean matches(Variable variable) {
            return !(variable instanceof Parameter);
        }
    }

    public static class StackVariableFilter
    implements VariableFilter {
        @Override
        public boolean matches(Variable variable) {
            return variable.isStackVariable();
        }
    }

    public static class CompoundStackVariableFilter
    implements VariableFilter {
        @Override
        public boolean matches(Variable variable) {
            return variable.hasStackStorage();
        }
    }

    public static class RegisterVariableFilter
    implements VariableFilter {
        @Override
        public boolean matches(Variable variable) {
            return variable.isRegisterVariable();
        }
    }

    public static class MemoryVariableFilter
    implements VariableFilter {
        @Override
        public boolean matches(Variable variable) {
            return variable.isMemoryVariable();
        }
    }

    public static class UniqueVariableFilter
    implements VariableFilter {
        @Override
        public boolean matches(Variable variable) {
            return variable.isUniqueVariable();
        }
    }
}

