/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeBlock;
import java.io.IOException;
import java.util.ArrayList;

public class BlockMultiGoto
extends BlockGraph {
    protected ArrayList<PcodeBlock> targets = new ArrayList();

    public BlockMultiGoto() {
        this.blocktype = 5;
    }

    public void addGotoTarget(PcodeBlock target) {
        this.targets.add(target);
    }

    @Override
    protected void encodeBody(Encoder encoder) throws IOException {
        super.encodeBody(encoder);
        for (PcodeBlock gototarget : this.targets) {
            encoder.openElement(ElementId.ELEM_TARGET);
            PcodeBlock leaf = gototarget.getFrontLeaf();
            int depth = gototarget.calcDepth(leaf);
            encoder.writeSignedInteger(AttributeId.ATTRIB_INDEX, leaf.getIndex());
            encoder.writeSignedInteger(AttributeId.ATTRIB_DEPTH, depth);
            encoder.closeElement(ElementId.ELEM_TARGET);
        }
    }

    @Override
    protected void decodeBody(Decoder decoder, BlockMap resolver) throws DecoderException {
        int el;
        super.decodeBody(decoder, resolver);
        while ((el = decoder.peekElement()) == ElementId.ELEM_TARGET.id()) {
            decoder.openElement();
            int target = (int)decoder.readSignedInteger(AttributeId.ATTRIB_INDEX);
            int depth = (int)decoder.readSignedInteger(AttributeId.ATTRIB_DEPTH);
            decoder.closeElement(el);
            resolver.addGotoRef(this, target, depth);
        }
    }
}

