/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;

public class SequenceNumber
implements Comparable<SequenceNumber> {
    private Address pc;
    private int uniq;
    private int order;

    public SequenceNumber(Address instrAddr, int sequenceNum) {
        this.pc = instrAddr;
        this.uniq = sequenceNum;
    }

    public Address getTarget() {
        return this.pc;
    }

    public int getTime() {
        return this.uniq;
    }

    public void setTime(int t) {
        this.uniq = t;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int o) {
        this.order = o;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SequenceNumber)) {
            return false;
        }
        SequenceNumber sq = (SequenceNumber)o;
        return this.pc.equals(sq.pc) && this.uniq == sq.uniq;
    }

    @Override
    public int compareTo(SequenceNumber sq) {
        int val = this.pc.compareTo(sq.pc);
        if (val != 0) {
            return val;
        }
        if (this.uniq < sq.uniq) {
            return -1;
        }
        if (sq.uniq < this.uniq) {
            return 1;
        }
        return 0;
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_SEQNUM);
        AddressSpace space = this.pc.getAddressSpace();
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, space);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_OFFSET, this.pc.getOffset());
        if (this.uniq != -1) {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_UNIQ, this.uniq);
        }
        encoder.closeElement(ElementId.ELEM_SEQNUM);
    }

    public static SequenceNumber decode(Decoder decoder) throws DecoderException {
        int attribId;
        int el = decoder.openElement(ElementId.ELEM_SEQNUM);
        int uniq = -1;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId != AttributeId.ATTRIB_UNIQ.id()) continue;
            uniq = (int)decoder.readUnsignedInteger();
        }
        AddressSpace spc = decoder.readSpace(AttributeId.ATTRIB_SPACE);
        long offset = decoder.readUnsignedInteger(AttributeId.ATTRIB_OFFSET);
        decoder.closeElement(el);
        return new SequenceNumber(spc.getAddress(offset), uniq);
    }

    public String toString() {
        return "(" + this.pc.getAddressSpace().getName() + ", 0x" + Long.toHexString(this.pc.getOffset()) + ", " + this.uniq + ", " + this.order + ")";
    }

    public int hashCode() {
        return this.pc.hashCode() + this.uniq;
    }
}

