/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import ghidra.sleigh.grammar.Location;
import ghidra.sleigh.grammar.ParsingEnvironment;
import ghidra.sleigh.grammar.SleighRecognizerConstants;
import ghidra.sleigh.grammar.SleighToken;
import ghidra.util.Msg;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;

public abstract class AbstractSleighLexer
extends Lexer
implements SleighRecognizerConstants {
    protected ParsingEnvironment env = null;

    public AbstractSleighLexer() {
    }

    public AbstractSleighLexer(CharStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public Token emit() {
        SleighToken t = new SleighToken(this.input, this.state.type, this.state.channel, this.state.tokenStartCharIndex, this.getCharIndex() - 1);
        Location location = this.env.getLocator().getLocation(this.state.tokenStartLine);
        t.setLocation(location);
        t.setLine(this.state.tokenStartLine);
        t.setText(this.state.text);
        t.setCharPositionInLine(this.state.tokenStartCharPositionInLine);
        this.emit((Token)t);
        return t;
    }

    public void emitErrorMessage(String msg) {
        Msg.error((Object)this, (Object)msg);
    }

    public String getErrorHeader(RecognitionException e) {
        return this.env.getErrorHeader(e);
    }

    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        return this.env.getLexerErrorMessage(e, tokenNames);
    }

    public String getTokenErrorDisplay(Token t) {
        return this.env.getTokenErrorDisplay(t);
    }

    protected void preprocess(String text) {
        String[] split = text.split("###");
        if (split.length == 2) {
            this.env.getLocator().registerLocation(this.input.getLine(), new Location(split[0], Integer.parseInt(split[1])));
        }
        this.input.setCharPositionInLine(this.input.getCharPositionInLine() - (text.length() + 2));
    }

    public void setEnv(ParsingEnvironment env) {
        this.env = env;
    }
}

