/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import generic.stl.Pair;
import ghidra.pcodeCPort.slgh_compile.PreprocessorDefinitions;
import ghidra.sleigh.grammar.BooleanExpressionLexer;
import ghidra.sleigh.grammar.BooleanExpressionParser;
import ghidra.sleigh.grammar.ConditionalHelper;
import ghidra.sleigh.grammar.ExpressionEnvironment;
import ghidra.sleigh.grammar.FakeLineArrayListWriter;
import ghidra.sleigh.grammar.LineArrayListWriter;
import ghidra.sleigh.grammar.Location;
import ghidra.sleigh.grammar.PreprocessorException;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import utilities.util.FileResolutionResult;
import utilities.util.FileUtilities;

public class SleighPreprocessor
implements ExpressionEnvironment {
    private static final Logger log = LogManager.getLogger(SleighPreprocessor.class);
    private static final Pattern INCLUDE;
    private static final Pattern DEFINE1;
    private static final Pattern DEFINE2;
    private static final Pattern DEFINE3;
    private static final Pattern UNDEF;
    private static final Pattern IFDEF;
    private static final Pattern IFNDEF;
    private static final Pattern IF;
    private static final Pattern ELIF;
    private static final Pattern ENDIF;
    private static final Pattern ELSE;
    private final PreprocessorDefinitions definitions;
    private boolean compatible = false;
    BooleanExpressionLexer lexer = null;
    BooleanExpressionParser parser = null;
    ArrayList<ConditionalHelper> ifstack;
    SleighPreprocessor myParent = null;
    long myLatestTimestamp = 0L;
    int errorCount = 0;
    private final File file;
    private String line;
    private int lineno;
    private int overallLineno;
    private static final Pattern EXPANSION;

    public SleighPreprocessor(PreprocessorDefinitions definitions, File inputFile) {
        this.definitions = definitions;
        this.file = inputFile;
        this.updateLatestDate(inputFile);
    }

    SleighPreprocessor(SleighPreprocessor parent, File inputFile) {
        this.definitions = parent.definitions;
        this.compatible = parent.compatible;
        this.file = inputFile;
        this.myParent = parent;
        this.updateLatestDate(inputFile);
    }

    public void process(LineArrayListWriter writer) throws IOException, PreprocessorException, RecognitionException {
        this.processInternal(writer, 1);
    }

    public long scanForTimestamp() throws IOException, PreprocessorException, RecognitionException {
        this.processInternal(new FakeLineArrayListWriter(), 1);
        return this.myLatestTimestamp;
    }

    public void setCompatible(boolean compatible) {
        this.compatible = compatible;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    private void processInternal(LineArrayListWriter writer, int overallLine) throws IOException, PreprocessorException, RecognitionException {
        this.lineno = 1;
        this.overallLineno = overallLine;
        this.ifstack = new ArrayList();
        this.ifstack.add(new ConditionalHelper(false, false, false, true));
        FileInputStream fis = new FileInputStream(this.file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
        try (BufferedReader in = new BufferedReader(isr);){
            this.outputPosition(writer);
            log.trace("enter SleighPreprocessor");
            while ((this.line = in.readLine()) != null) {
                log.trace("top of while, state: " + this.toString());
                log.trace("got line: " + this.line);
                String origLine = this.line;
                this.line = this.line.replaceFirst("^\\s*#.*", "");
                if (this.line.length() > 0 && this.line.charAt(0) == '@') {
                    this.line = this.line.replaceFirst("#.*", "");
                    Matcher m = INCLUDE.matcher(this.line);
                    if (m.matches()) {
                        if (this.isCopy()) {
                            String includeFileName = this.handleVariables(m.group(1), true);
                            boolean isAbsolute = false;
                            if (includeFileName.startsWith("/")) {
                                isAbsolute = true;
                            } else if (includeFileName.startsWith("\\")) {
                                isAbsolute = true;
                            } else if (includeFileName.matches("^[a-zA-Z_0-9]+:.*")) {
                                isAbsolute = true;
                            }
                            File includeFile = isAbsolute ? new File(includeFileName) : new File(this.file.getParent(), includeFileName);
                            FileResolutionResult result = FileUtilities.existsAndIsCaseDependent((File)includeFile);
                            if (!result.isOk()) {
                                throw new PreprocessorException("included file \"" + String.valueOf(includeFile) + "\": " + result.getMessage(), this.file.getName(), this.lineno, this.overallLineno, this.line);
                            }
                            SleighPreprocessor preprocessor = new SleighPreprocessor(this, includeFile);
                            preprocessor.processInternal(writer, this.overallLineno);
                            ++this.lineno;
                            ++this.overallLineno;
                            this.outputPosition(writer);
                            continue;
                        }
                    } else {
                        m = DEFINE1.matcher(this.line);
                        if (m.matches()) {
                            if (this.isCopy()) {
                                this.define(m.group(1), m.group(2));
                            }
                        } else {
                            m = DEFINE2.matcher(this.line);
                            if (m.matches()) {
                                if (this.isCopy()) {
                                    this.define(m.group(1), m.group(2));
                                }
                            } else {
                                m = DEFINE3.matcher(this.line);
                                if (m.matches()) {
                                    if (this.isCopy()) {
                                        this.define(m.group(1), "");
                                    }
                                } else {
                                    m = UNDEF.matcher(this.line);
                                    if (m.matches()) {
                                        if (this.isCopy()) {
                                            this.undefine(m.group(1));
                                        }
                                    } else {
                                        m = IFDEF.matcher(this.line);
                                        if (m.matches()) {
                                            this.enterif();
                                            pair = this.definitions.lookup(m.group(1));
                                            containsKey = (Boolean)pair.first;
                                            if (!containsKey) {
                                                this.setCopy(false);
                                                log.trace("@ifdef " + m.group(1) + ": NO");
                                            } else {
                                                this.setHandled(true);
                                                log.trace("@ifdef " + m.group(1) + ": yes");
                                            }
                                        } else {
                                            m = IFNDEF.matcher(this.line);
                                            if (m.matches()) {
                                                this.enterif();
                                                pair = this.definitions.lookup(m.group(1));
                                                containsKey = (Boolean)pair.first;
                                                if (containsKey) {
                                                    this.setCopy(false);
                                                    log.trace("@ifndef " + m.group(1) + ": NO");
                                                } else {
                                                    this.setHandled(true);
                                                    log.trace("@ifndef " + m.group(1) + ": yes");
                                                }
                                            } else {
                                                m = IF.matcher(this.line);
                                                if (m.matches()) {
                                                    this.enterif();
                                                    log.trace("@if...");
                                                    this.handleExpression(m.group(1));
                                                } else {
                                                    m = ELIF.matcher(this.line);
                                                    if (m.matches()) {
                                                        this.enterelif();
                                                        log.trace("@elif...");
                                                        this.handleExpression(m.group(1));
                                                    } else {
                                                        m = ENDIF.matcher(this.line);
                                                        if (m.matches()) {
                                                            this.leaveif();
                                                            log.trace("@endif");
                                                        } else {
                                                            m = ELSE.matcher(this.line);
                                                            if (m.matches()) {
                                                                this.enterelse();
                                                                this.setCopy(!this.isHandled());
                                                                log.trace("@else");
                                                            } else {
                                                                throw new PreprocessorException("unrecognized preprocessor directive", this.file.getName(), this.lineno, this.overallLineno, this.line);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    log.trace("PRINT " + this.lineno() + ": commenting directive out");
                    writer.write("#" + origLine);
                    writer.newLine();
                } else if (this.isCopy()) {
                    log.trace("PRINT " + this.lineno() + ": printing text");
                    writer.write(this.handleVariables(this.line, this.compatible));
                    writer.newLine();
                } else {
                    log.trace("PRINT " + this.lineno() + ": replacing text with non-copied blank line");
                    writer.write("#" + this.line);
                    writer.newLine();
                }
                ++this.lineno;
                ++this.overallLineno;
            }
        }
        writer.flush();
        if (this.errorCount > 0) {
            throw new PreprocessorException("Errors during preprocessing", this.file.getName(), overallLine, 0, "");
        }
        log.trace("leave SleighPreprocessor");
    }

    void updateLatestDate(File possibleNewDateFile) {
        if (possibleNewDateFile != null && possibleNewDateFile.exists()) {
            long lastModified = possibleNewDateFile.lastModified();
            if (lastModified > this.myLatestTimestamp) {
                this.myLatestTimestamp = lastModified;
            }
            if (this.myParent != null) {
                this.myParent.updateLatestDate(possibleNewDateFile);
            }
        }
    }

    private String lineno() {
        return this.file.getName() + ":" + this.lineno + "(" + this.overallLineno + ")";
    }

    private void outputPosition(LineArrayListWriter out) throws IOException {
        if (!this.compatible) {
            String position = "\b" + this.file.getName() + "###" + this.lineno + "\b";
            out.write(position);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lineno:");
        sb.append(this.lineno);
        sb.append(" ");
        sb.append(this.ifstack);
        return sb.toString();
    }

    private void handleExpression(String expression) throws RecognitionException, IOException {
        this.initParser(new StringReader(expression));
        if (this.isHandled()) {
            this.setCopy(false);
            log.trace("already handled");
        } else if (!this.parser.expression()) {
            this.setCopy(false);
            log.trace("expression '" + expression + "' is FALSE");
        } else {
            this.setCopy(true);
            this.setHandled(true);
            log.trace("expression '" + expression + "' is true");
        }
    }

    private void initParser(Reader reader) throws IOException {
        ANTLRReaderStream charStream = new ANTLRReaderStream(reader);
        this.lexer = new BooleanExpressionLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        this.parser = new BooleanExpressionParser((TokenStream)tokenStream);
        this.parser.env = this;
    }

    private void enterelse() throws PreprocessorException {
        if (!this.isInif()) {
            throw new PreprocessorException("else outside of IF* directive", this.file.getName(), this.lineno, this.overallLineno, this.line);
        }
        if (this.isSawelse()) {
            throw new PreprocessorException("duplicate else directive", this.file.getName(), this.lineno, this.overallLineno, this.line);
        }
        this.setSawelse(true);
    }

    private void enterelif() throws PreprocessorException {
        if (!this.isInif()) {
            throw new PreprocessorException("elif outside of IF* directive", this.file.getName(), this.lineno, this.overallLineno, this.line);
        }
        if (this.isSawelse()) {
            throw new PreprocessorException("already saw else directive", this.file.getName(), this.lineno, this.overallLineno, this.line);
        }
    }

    private void enterif() {
        this.push(new ConditionalHelper(true, false, false, this.isCopy()));
    }

    private void leaveif() throws PreprocessorException {
        if (!this.isInif()) {
            throw new PreprocessorException("not in IF* directive", this.file.getName(), this.lineno, this.overallLineno, this.line);
        }
        this.pop();
    }

    private void undefine(String key) {
        log.trace("@undef " + key);
        this.definitions.undefine(key);
    }

    private void define(String key, String value) {
        log.trace("@define " + key + " " + value);
        this.definitions.set(key, value);
    }

    private String handleVariables(String input, boolean beCompatible) throws PreprocessorException {
        Matcher m;
        log.trace("handling line '" + input + "'");
        StringBuilder sb = new StringBuilder();
        while ((m = EXPANSION.matcher(input)).find()) {
            log.trace("found expansion: " + m.group());
            String variable = m.group(2);
            Pair<Boolean, String> pair = this.definitions.lookup(variable);
            boolean containsKey = (Boolean)pair.first;
            if (!containsKey) {
                throw new PreprocessorException("unknown variable: " + variable, this.file.getName(), this.lineno, this.overallLineno, this.line);
            }
            sb.append(input.substring(0, m.start(1)));
            if (!beCompatible) {
                sb.append("\b");
                sb.append(m.group());
                sb.append("\b");
            }
            sb.append((String)pair.second);
            input = input.substring(m.end(1));
        }
        sb.append(input);
        return sb.toString();
    }

    @Override
    public boolean equals(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.equals(rhs);
    }

    @Override
    public String lookup(String variable) {
        Pair<Boolean, String> pair = this.definitions.lookup(variable);
        if (((Boolean)pair.first).booleanValue()) {
            return (String)pair.second;
        }
        return null;
    }

    @Override
    public void reportError(String msg) {
        ++this.errorCount;
        Location location = new Location(this.file.getName(), this.lineno);
        Msg.error((Object)this, (Object)(String.valueOf(location) + ": " + msg));
    }

    private void push(ConditionalHelper conditionalHelper) {
        this.ifstack.add(conditionalHelper);
    }

    private void pop() {
        this.ifstack.remove(this.ifstack.size() - 1);
    }

    private ConditionalHelper top() {
        return this.ifstack.get(this.ifstack.size() - 1);
    }

    private boolean isInif() {
        return this.top().isInif();
    }

    private void setSawelse(boolean sawelse) {
        this.top().setSawelse(sawelse);
    }

    private boolean isSawelse() {
        return this.top().isSawelse();
    }

    private void setHandled(boolean handled) {
        this.top().setHandled(handled);
    }

    private boolean isHandled() {
        return this.top().isHandled();
    }

    private void setCopy(boolean copy) {
        this.top().setCopy(copy);
    }

    private boolean isCopy() {
        for (int ii = this.ifstack.size() - 1; ii >= 0; --ii) {
            if (this.ifstack.get(ii).isCopy()) continue;
            return false;
        }
        return true;
    }

    static {
        Configurator.setLevel((String)log.getName(), (Level)Level.INFO);
        INCLUDE = Pattern.compile("^\\s*@include\\s+\\\"(.*)\\\"\\s*$");
        DEFINE1 = Pattern.compile("^\\s*@define\\s+([0-9A-Z_a-z]+)\\s+\\\"(.*)\\\"\\s*$");
        DEFINE2 = Pattern.compile("^\\s*@define\\s+([0-9A-Z_a-z]+)\\s+(\\S+)\\s*$");
        DEFINE3 = Pattern.compile("^\\s*@define\\s+([0-9A-Z_a-z]+)\\s*$");
        UNDEF = Pattern.compile("^\\s*@undef\\s+([0-9A-Z_a-z]+)\\s*$");
        IFDEF = Pattern.compile("^\\s*@ifdef\\s+([0-9A-Z_a-z]+)\\s*$");
        IFNDEF = Pattern.compile("^\\s*@ifndef\\s+([0-9A-Z_a-z]+)\\s*$");
        IF = Pattern.compile("^\\s*@if\\s+(.*)");
        ELIF = Pattern.compile("^\\s*@elif\\s+(.*)");
        ENDIF = Pattern.compile("^\\s*@endif\\s*$");
        ELSE = Pattern.compile("^\\s*@else\\s*$");
        EXPANSION = Pattern.compile("(\\$\\(([0-9A-Z_a-z]+)\\))");
    }
}

