/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.GhidraDataConverter;
import ghidra.util.LittleEndianDataConverter;
import java.math.BigInteger;

public class GhidraLittleEndianDataConverter
extends LittleEndianDataConverter
implements GhidraDataConverter {
    public static final GhidraLittleEndianDataConverter INSTANCE = new GhidraLittleEndianDataConverter();

    @Override
    public final short getShort(MemBuffer buf, int offset) throws MemoryAccessException {
        byte[] bytes = new byte[2];
        if (buf.getBytes(bytes, offset) != 2) {
            throw new MemoryAccessException();
        }
        return this.getShort(bytes, 0);
    }

    @Override
    public final int getInt(MemBuffer buf, int offset) throws MemoryAccessException {
        byte[] bytes = new byte[4];
        if (buf.getBytes(bytes, offset) != 4) {
            throw new MemoryAccessException();
        }
        return this.getInt(bytes, 0);
    }

    @Override
    public final long getLong(MemBuffer buf, int offset) throws MemoryAccessException {
        byte[] bytes = new byte[8];
        if (buf.getBytes(bytes, offset) != 8) {
            throw new MemoryAccessException();
        }
        return this.getLong(bytes, 0);
    }

    @Override
    public final BigInteger getBigInteger(MemBuffer buf, int offset, int size, boolean signed) throws MemoryAccessException {
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, offset) != size) {
            throw new MemoryAccessException();
        }
        return this.getBigInteger(bytes, size, signed);
    }
}

