/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.actions.KeyBindingUtils;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.ToolOptions;
import gui.event.MouseBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.KeyStroke;
import util.CollectionUtils;

public class KeyBindings {
    private Tool tool;
    private ToolOptions keyBindingOptions;
    private List<DockingActionIf> uniqueActions = new ArrayList<DockingActionIf>();
    private Map<KeyStroke, List<String>> actionNamesByKeyStroke = new HashMap<KeyStroke, List<String>>();
    private Map<MouseBinding, String> actionNameByMouseBinding = new HashMap<MouseBinding, String>();
    private Map<String, ActionKeyBindingState> actionInfoByFullName = new HashMap<String, ActionKeyBindingState>();
    private String longestActionName = "";

    public KeyBindings(Tool tool) {
        this.tool = tool;
        this.keyBindingOptions = tool.getOptions("Key Bindings");
        this.init();
    }

    public List<DockingActionIf> getUniqueActions() {
        return Collections.unmodifiableList(this.uniqueActions);
    }

    public Map<String, KeyStroke> getKeyStrokesByFullActionName() {
        HashMap<String, KeyStroke> result = new HashMap<String, KeyStroke>();
        Set<Map.Entry<String, ActionKeyBindingState>> entries = this.actionInfoByFullName.entrySet();
        for (Map.Entry<String, ActionKeyBindingState> entry : entries) {
            String key = entry.getKey();
            KeyStroke value = entry.getValue().getCurrentKeyStroke();
            result.put(key, value);
        }
        return result;
    }

    public boolean containsAction(String fullName) {
        return this.actionInfoByFullName.containsKey(fullName);
    }

    public KeyStroke getKeyStroke(String fullName) {
        ActionKeyBindingState info = this.actionInfoByFullName.get(fullName);
        return info.getCurrentKeyStroke();
    }

    public MouseBinding getMouseBinding(String fullName) {
        ActionKeyBindingState info = this.actionInfoByFullName.get(fullName);
        return info.getCurrentMouseBinding();
    }

    public String getActionForMouseBinding(MouseBinding mouseBinding) {
        return this.actionNameByMouseBinding.get(mouseBinding);
    }

    public String getActionsForKeyStrokeText(KeyStroke keyStroke) {
        StringBuffer sb = new StringBuffer();
        List<String> names = this.actionNamesByKeyStroke.get(keyStroke);
        if (CollectionUtils.isBlank(names)) {
            return sb.toString();
        }
        names.sort((n1, n2) -> n1.compareToIgnoreCase((String)n2));
        String ksName = KeyBindingUtils.parseKeyStroke(keyStroke);
        sb.append("Actions mapped to key " + ksName + ":\n");
        for (int i = 0; i < names.size(); ++i) {
            sb.append("  ");
            String name = names.get(i);
            ActionKeyBindingState info = this.actionInfoByFullName.get(name);
            DockingActionIf action = info.getRepresentativeAction();
            String shortName = action.getName();
            sb.append(shortName);
            sb.append(" (").append(action.getOwnerDescription()).append(')');
            if (i >= names.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getLongestActionName() {
        return this.longestActionName;
    }

    public boolean isMouseBindingInUse(String fullName, MouseBinding newBinding) {
        String existingName = this.actionNameByMouseBinding.get(newBinding);
        if (existingName == null || newBinding == null) {
            return false;
        }
        return !Objects.equals(existingName, fullName);
    }

    public boolean setActionMouseBinding(String fullName, MouseBinding newBinding) {
        MouseBinding currentBinding = this.getMouseBinding(fullName);
        if (currentBinding != null) {
            if (currentBinding.equals((Object)newBinding)) {
                return false;
            }
            this.actionNameByMouseBinding.remove(currentBinding);
        }
        if (newBinding != null) {
            this.actionNameByMouseBinding.put(newBinding, fullName);
        }
        ActionKeyBindingState info = this.actionInfoByFullName.get(fullName);
        info.setCurrentMouseBinding(newBinding);
        return true;
    }

    public boolean setActionKeyStroke(String fullName, KeyStroke newKs) {
        String newKsName = KeyBindingUtils.parseKeyStroke(newKs);
        KeyStroke currentKs = this.getKeyStroke(fullName);
        if (currentKs != null) {
            String currentName = KeyBindingUtils.parseKeyStroke(currentKs);
            if (currentName.equals(newKsName)) {
                return false;
            }
            this.removeFromKeyMap(fullName, currentKs);
        }
        this.addActionKeyStroke(fullName, newKs);
        ActionKeyBindingState info = this.actionInfoByFullName.get(fullName);
        info.setCurrentKeyStroke(newKs);
        return true;
    }

    public boolean removeKeyStroke(String fullName) {
        ActionKeyBindingState info = this.actionInfoByFullName.get(fullName);
        if (info == null) {
            return false;
        }
        KeyStroke currentKeyStroke = info.getCurrentKeyStroke();
        if (currentKeyStroke == null) {
            return false;
        }
        this.removeFromKeyMap(fullName, currentKeyStroke);
        info.setCurrentKeyStroke(null);
        return true;
    }

    public void restoreOptions() {
        for (ActionKeyBindingState info : this.actionInfoByFullName.values()) {
            info.restore(this.keyBindingOptions);
        }
    }

    public void cancelChanges() {
        for (ActionKeyBindingState info : this.actionInfoByFullName.values()) {
            info.cancelChanges();
        }
    }

    public void applyChanges() {
        for (ActionKeyBindingState info : this.actionInfoByFullName.values()) {
            info.apply(this.keyBindingOptions);
        }
    }

    private void removeFromKeyMap(String actionName, KeyStroke ks) {
        if (ks == null) {
            return;
        }
        List<String> list = this.actionNamesByKeyStroke.get(ks);
        if (list != null) {
            list.remove(actionName);
            if (list.isEmpty()) {
                this.actionNamesByKeyStroke.remove(ks);
            }
        }
    }

    private void init() {
        this.actionInfoByFullName = new HashMap<String, ActionKeyBindingState>();
        Map<String, List<DockingActionIf>> actionsByFullName = KeyBindingUtils.getAllActionsByFullName(this.tool);
        Set<Map.Entry<String, List<DockingActionIf>>> entries = actionsByFullName.entrySet();
        for (Map.Entry<String, List<DockingActionIf>> entry : entries) {
            List<DockingActionIf> actions = entry.getValue();
            String fullName = entry.getKey();
            ActionTrigger trigger = this.keyBindingOptions.getActionTrigger(fullName, null);
            KeyStroke ks = null;
            MouseBinding mb = null;
            if (trigger != null) {
                ks = trigger.getKeyStroke();
                mb = trigger.getMouseBinding();
            }
            ActionKeyBindingState info = new ActionKeyBindingState(this, actions, ks, mb);
            this.actionInfoByFullName.put(fullName, info);
            this.uniqueActions.add(info.getRepresentativeAction());
            this.addActionKeyStroke(fullName, ks);
            String shortName = info.getShortName();
            if (shortName.length() <= this.longestActionName.length()) continue;
            this.longestActionName = shortName;
        }
    }

    private void addActionKeyStroke(String actionName, KeyStroke ks) {
        if (ks == null) {
            return;
        }
        List<String> list = this.actionNamesByKeyStroke.get(ks);
        if (list == null) {
            list = new ArrayList<String>();
            this.actionNamesByKeyStroke.put(ks, list);
        }
        if (!list.contains(actionName)) {
            list.add(actionName);
        }
    }

    private class ActionKeyBindingState {
        private List<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        private KeyStroke originalKeyStroke;
        private KeyStroke currentKeyStroke;
        private MouseBinding originalMouseBinding;
        private MouseBinding currentMouseBinding;

        ActionKeyBindingState(KeyBindings keyBindings, List<DockingActionIf> actions, KeyStroke ks, MouseBinding mb) {
            this.actions.addAll(actions);
            this.originalKeyStroke = ks;
            this.currentKeyStroke = ks;
            this.originalMouseBinding = mb;
            this.currentMouseBinding = mb;
        }

        public DockingActionIf getRepresentativeAction() {
            return this.actions.get(0);
        }

        String getShortName() {
            return this.actions.get(0).getName();
        }

        String getFullName() {
            return this.getRepresentativeAction().getFullName();
        }

        public MouseBinding getCurrentMouseBinding() {
            return this.currentMouseBinding;
        }

        public void setCurrentMouseBinding(MouseBinding newMouseBinding) {
            this.currentMouseBinding = newMouseBinding;
        }

        public KeyStroke getCurrentKeyStroke() {
            return this.currentKeyStroke;
        }

        public void setCurrentKeyStroke(KeyStroke newKeyStroke) {
            this.currentKeyStroke = newKeyStroke;
        }

        public void cancelChanges() {
            this.currentKeyStroke = this.originalKeyStroke;
            this.currentMouseBinding = this.originalMouseBinding;
        }

        public void apply(ToolOptions keyStrokeOptions) {
            if (!this.hasChanged()) {
                return;
            }
            KeyBindingData kbd = this.getCurrentKeyBindingData();
            this.apply(keyStrokeOptions, kbd);
        }

        private void apply(ToolOptions keyStrokeOptions, KeyBindingData keyBinding) {
            if (keyBinding == null) {
                for (DockingActionIf action : this.actions) {
                    action.setUnvalidatedKeyBindingData(null);
                }
                return;
            }
            ActionTrigger newTrigger = keyBinding.getActionTrigger();
            String fullName = this.getFullName();
            keyStrokeOptions.setActionTrigger(fullName, newTrigger);
            this.currentKeyStroke = newTrigger.getKeyStroke();
            this.currentMouseBinding = newTrigger.getMouseBinding();
        }

        private boolean hasChanged() {
            return !Objects.equals(this.originalKeyStroke, this.currentKeyStroke) || !Objects.equals(this.originalMouseBinding, this.currentMouseBinding);
        }

        private boolean matches(KeyBindingData kbData) {
            if (CollectionUtils.isAllNull((Object[])new Object[]{kbData, this.currentKeyStroke, this.currentMouseBinding})) {
                return true;
            }
            if (kbData == null) {
                return false;
            }
            KeyStroke otherKs = kbData.getKeyBinding();
            if (!Objects.equals(otherKs, this.currentKeyStroke)) {
                return false;
            }
            MouseBinding otherMb = kbData.getMouseBinding();
            return Objects.equals(otherMb, this.currentMouseBinding);
        }

        private KeyBindingData getCurrentKeyBindingData() {
            if (this.currentKeyStroke == null && this.currentMouseBinding == null) {
                return null;
            }
            DockingActionIf action = this.getRepresentativeAction();
            KeyBindingData kbData = action.getKeyBindingData();
            ActionTrigger trigger = new ActionTrigger(this.currentKeyStroke, this.currentMouseBinding);
            return KeyBindingData.update(kbData, trigger);
        }

        public void restore(ToolOptions options) {
            DockingActionIf action = this.getRepresentativeAction();
            KeyBindingData defaultBinding = action.getDefaultKeyBindingData();
            this.cancelChanges();
            if (!this.matches(defaultBinding)) {
                this.apply(options, defaultBinding);
            }
        }
    }
}

