/*
 * Decompiled with CFR 0.152.
 */
package docking.actions.dialog;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingActionIf;
import docking.action.ToolBarData;
import docking.actions.KeyBindingUtils;
import docking.actions.dialog.ActionDisplayLevel;
import docking.actions.dialog.ActionGroup;
import docking.actions.dialog.ActionsModel;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.searchlist.SearchList;
import docking.widgets.searchlist.SearchListEntry;
import docking.widgets.searchlist.SearchListModel;
import generic.theme.GThemeDefaults;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import resources.Icons;

public class ActionChooserDialog
extends DialogComponentProvider {
    private ActionsModel model;
    private SearchList<DockingActionIf> searchList;
    private ActionRunner actionRunner;

    public ActionChooserDialog(ActionsModel model) {
        super("Action Chooser Dialog");
        this.model = model;
        this.addWorkPanel(this.buildMainPanel());
        this.setPreferredSize(600, 600);
        this.addOKButton();
        this.addCancelButton();
        this.updateTitle();
        this.setAccessibleDescription("This dialog initialy shows only locally relevant actions. Repeat initial keybinding to show More. Use up down arrows to scroll through list of actions and press enter to invoke selected action. Type text to filter list.");
        this.setOkEnabled(false);
    }

    @Override
    protected void dialogShown() {
        Swing.runLater(() -> DockingWindowManager.setMouseOverAction(this.searchList.getSelectedItem()));
    }

    public ActionChooserDialog(Tool tool, ComponentProvider provider, ActionContext context) {
        this(provider.getLocalActions(), tool.getGlobalActions(), context);
    }

    public ActionChooserDialog(Tool tool, DialogComponentProvider dialog, ActionContext context) {
        this(dialog.getActions(), new HashSet<DockingActionIf>(), context);
    }

    private ActionChooserDialog(Set<DockingActionIf> localActions, Set<DockingActionIf> globalActions, ActionContext context) {
        this(new ActionsModel(localActions, globalActions, context));
    }

    public ActionDisplayLevel getActionDisplayLevel() {
        return this.model.getActionDisplayLevel();
    }

    public void setActionDisplayLevel(ActionDisplayLevel level) {
        this.model.setDisplayLevel(level);
        this.updateTitle();
    }

    @Override
    protected void okCallback() {
        DockingActionIf action = this.searchList.getSelectedItem();
        if (action != null) {
            this.actionChosen(action);
        }
    }

    private void updateTitle() {
        switch (this.model.getActionDisplayLevel()) {
            case LOCAL: {
                this.setTitle("Relevant Actions (" + this.model.getSize() + ")");
                break;
            }
            case GLOBAL: {
                this.setTitle("All Valid Local and Global Actions (" + this.model.getSize() + ")");
                break;
            }
            case ALL: {
                this.setTitle("All Local and Global Actions (" + this.model.getSize() + ")");
            }
        }
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 2, 0, 2));
        this.searchList = new SearchList<DockingActionIf>((SearchListModel)this.model, (a, c) -> this.actionChosen((DockingActionIf)a)){

            @Override
            protected BiPredicate<DockingActionIf, String> createFilter(String text) {
                return new ActionsFilter(text);
            }
        };
        this.searchList.setSelectionCallback(this::itemSelected);
        this.searchList.setInitialSelection();
        this.searchList.setItemRenderer(new ActionRenderer());
        this.searchList.setDisplayNameFunction((t, c) -> ActionChooserDialog.getActionDisplayName(t, c) + " " + ActionChooserDialog.getKeyBindingString(t));
        panel.add(this.searchList);
        return panel;
    }

    private void actionChosen(DockingActionIf action) {
        if (!this.canPerformAction(action)) {
            return;
        }
        ActionContext context = this.model.getContext();
        this.close();
        this.scheduleActionAfterFocusRestored(action, context);
    }

    private void scheduleActionAfterFocusRestored(DockingActionIf action, ActionContext context) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.actionRunner = new ActionRunner(this, action, context);
        kfm.addPropertyChangeListener("permanentFocusOwner", this.actionRunner);
    }

    ActionRunner getActionRunner() {
        return this.actionRunner;
    }

    void selectAction(DockingActionIf action) {
        this.searchList.setSelectedItem(action);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.searchList.dispose();
    }

    private boolean canPerformAction(DockingActionIf action) {
        if (action == null) {
            return false;
        }
        ActionContext context = this.model.getContext();
        return action.isValidContext(context) && action.isEnabledForContext(context);
    }

    private void itemSelected(DockingActionIf action) {
        DockingWindowManager.setMouseOverAction(action);
        this.setOkEnabled(this.canPerformAction(action));
    }

    private static String getActionsDisplayMenuName(DockingActionIf action, MenuData menuData) {
        return menuData.getMenuPathDisplayString();
    }

    private static String colorKeyBindingString(Color color, DockingActionIf action) {
        String keyStroke = ActionChooserDialog.getKeyBindingString(action);
        String keyBindingString = HTMLUtilities.escapeHTML((String)keyStroke);
        String coloredString = HTMLUtilities.colorString((Color)color, (String)keyBindingString);
        return "&nbsp;&nbsp;" + coloredString;
    }

    private static String getKeyBindingString(DockingActionIf action) {
        KeyStroke keyBinding = action.getKeyBinding();
        if (keyBinding == null) {
            return "";
        }
        return "(" + KeyBindingUtils.parseKeyStroke(keyBinding) + ")";
    }

    private static String getActionDisplayName(DockingActionIf action, String category) {
        ActionGroup group = ActionGroup.getActionByDisplayName(category);
        switch (group) {
            case LOCAL_MENU: 
            case GLOBAL_MENU: {
                return ActionChooserDialog.getActionsDisplayMenuName(action, action.getMenuBarData());
            }
            case POPUP: {
                return ActionChooserDialog.getActionsDisplayMenuName(action, action.getPopupMenuData());
            }
        }
        return action.getName();
    }

    void setFilterText(String string) {
        this.searchList.setFilterText(string);
    }

    private class ActionRenderer
    extends GListCellRenderer<SearchListEntry<DockingActionIf>> {
        private ActionRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SearchListEntry<DockingActionIf>> list, SearchListEntry<DockingActionIf> value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
            if (ActionChooserDialog.this.model.isDisposed()) {
                return this;
            }
            DockingActionIf action = value.value();
            String category = value.category();
            Icon icon = this.getIcon(action, category);
            this.setText(this.getHtmlText(action, category, isSelected));
            this.setIcon(icon != null ? icon : Icons.EMPTY_ICON);
            return this;
        }

        private String getHtmlText(DockingActionIf action, String category, boolean isSelected) {
            String actionDisplayName = ActionChooserDialog.getActionDisplayName(action, category);
            String escapedActionName = HTMLUtilities.escapeHTML((String)actionDisplayName);
            String disabledText = "";
            StringBuilder builder = new StringBuilder("<html>");
            Color fgName = this.getForeground();
            Object fgKeyBinding = isSelected ? this.getForeground() : GThemeDefaults.Colors.Messages.HINT;
            ActionContext context = ActionChooserDialog.this.model.getContext();
            if (!action.isValidContext(context) || !action.isEnabledForContext(context)) {
                fgName = isSelected ? this.getForeground() : GThemeDefaults.Colors.FOREGROUND_DISABLED;
                fgKeyBinding = isSelected ? this.getForeground() : GThemeDefaults.Colors.FOREGROUND_DISABLED;
                disabledText = isSelected ? " <I>disabled</I>" : "";
            }
            builder.append(HTMLUtilities.colorString((Color)fgName, (String)escapedActionName));
            builder.append(ActionChooserDialog.colorKeyBindingString((Color)fgKeyBinding, action));
            builder.append(disabledText);
            return builder.toString();
        }

        private Icon getIcon(DockingActionIf action, String category) {
            ActionGroup group = ActionGroup.getActionByDisplayName(category);
            switch (group) {
                case LOCAL_TOOLBAR: 
                case GLOBAL_TOOLBAR: {
                    ToolBarData toolBarData = action.getToolBarData();
                    return toolBarData != null ? toolBarData.getIcon() : null;
                }
                case LOCAL_MENU: 
                case GLOBAL_MENU: {
                    MenuData menuBarData = action.getMenuBarData();
                    return menuBarData != null ? menuBarData.getMenuIcon() : null;
                }
                case POPUP: {
                    MenuData menuBarData = action.getPopupMenuData();
                    return menuBarData != null ? menuBarData.getMenuIcon() : null;
                }
            }
            return null;
        }
    }

    class ActionRunner
    implements PropertyChangeListener {
        private DockingActionIf action;
        private ActionContext context;

        ActionRunner(ActionChooserDialog this$0, DockingActionIf action, ActionContext context) {
            this.action = action;
            this.context = context;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.removePropertyChangeListener("permanentFocusOwner", this);
            Swing.runLater(() -> this.activateAction());
        }

        private void activateAction() {
            DockingActionIf dockingActionIf = this.action;
            if (dockingActionIf instanceof ToggleDockingActionIf) {
                ToggleDockingActionIf toggleAction;
                toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)dockingActionIf).isSelected());
            }
            this.action.actionPerformed(this.context);
        }
    }

    private static class ActionsFilter
    implements BiPredicate<DockingActionIf, String> {
        private String filterText;

        ActionsFilter(String filterText) {
            this.filterText = filterText.toLowerCase();
        }

        @Override
        public boolean test(DockingActionIf t, String category) {
            return ActionChooserDialog.getActionDisplayName(t, category).toLowerCase().contains(this.filterText) || ActionChooserDialog.getKeyBindingString(t).toLowerCase().contains(this.filterText);
        }
    }
}

