/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.ActionContext;
import docking.action.ActionContextProvider;
import docking.theme.gui.ColorSorter;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import generic.theme.ColorValue;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.theme.GThemeValueMap;
import generic.theme.ThemeManager;
import ghidra.util.WebColors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ThemeColorTree
extends JPanel
implements ActionContextProvider {
    private ColorRootNode root;
    private GTree tree;
    private JComboBox<GroupingStrategy> groupingCombo;
    private JComboBox<ColorSorter> colorSortCombo;
    private ThemeManager themeManager;

    public ThemeColorTree(ThemeManager themeManager) {
        this.themeManager = themeManager;
        this.buildBinCombo();
        this.buildSortCombo();
        this.root = new ColorRootNode();
        this.tree = new GTree(this.root);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
        this.add(this.buildControls(), "South");
    }

    private Component buildControls() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Group By: "));
        panel.add(this.groupingCombo);
        panel.add(new JLabel("Sort Order: "));
        panel.add(this.colorSortCombo);
        return panel;
    }

    private Component buildBinCombo() {
        this.groupingCombo = new JComboBox<GroupingStrategy>(GroupingStrategy.values());
        this.groupingCombo.setSelectedItem((Object)GroupingStrategy.BIN_64);
        this.groupingCombo.addItemListener(this::comboChanged);
        return this.groupingCombo;
    }

    private void comboChanged(ItemEvent ev) {
        this.rebuild();
    }

    private Component buildSortCombo() {
        ColorSorter[] sorters = new ColorSorter[]{ColorSorter.RGB, ColorSorter.RBG, ColorSorter.GRB, ColorSorter.GBR, ColorSorter.BRG, ColorSorter.BGR};
        this.colorSortCombo = new JComboBox<ColorSorter>(sorters);
        this.colorSortCombo.addItemListener(this::comboChanged);
        return this.colorSortCombo;
    }

    public void rebuild() {
        this.root = new ColorRootNode();
        this.tree.setRootNode(this.root);
    }

    @Override
    public ActionContext getActionContext(MouseEvent e) {
        return null;
    }

    private class ColorRootNode
    extends GTreeNode {
        int uniqueColors = 0;

        public ColorRootNode() {
            List<GTreeNode> children = this.buildChildren();
            this.setChildren(children);
            this.uniqueColors = this.countUniqueColors(children);
            this.sortChildren();
        }

        private void sortChildren() {
            ColorSorter sorter = (ColorSorter)ThemeColorTree.this.colorSortCombo.getSelectedItem();
            ArrayList<GTreeNode> children = new ArrayList<GTreeNode>(this.getChildren());
            if (children.isEmpty()) {
                return;
            }
            for (GTreeNode node : children) {
                ((ColorNode)node).sort(sorter);
            }
            if (children.get(0) instanceof ColorValueNode) {
                Collections.sort(children);
            } else {
                Collections.sort(children, (a, b) -> sorter.compare(((ColorNode)a).getColor(), ((ColorNode)b).getColor()));
            }
            this.setChildren(children);
        }

        private int countUniqueColors(List<GTreeNode> children) {
            Iterator<GTreeNode> iterator = this.iterator(true);
            HashSet<Color> set = new HashSet<Color>();
            while (iterator.hasNext()) {
                GTreeNode node = iterator.next();
                if (!(node instanceof ColorNode)) continue;
                ColorNode colorNode = (ColorNode)node;
                set.add(colorNode.getColor());
            }
            return set.size();
        }

        private List<GTreeNode> buildChildren() {
            List<ColorValueNode> nodes = new ArrayList<ColorValueNode>();
            GThemeValueMap currentValues = ThemeColorTree.this.themeManager.getCurrentValues();
            List colors = currentValues.getColors();
            for (ColorValue colorValue : colors) {
                nodes.add(new ColorValueNode(ThemeColorTree.this, colorValue));
            }
            nodes = this.organizeByIdRefs(nodes);
            int bins = 1;
            GroupingStrategy grouping = (GroupingStrategy)((Object)ThemeColorTree.this.groupingCombo.getSelectedItem());
            switch (grouping.ordinal()) {
                case 0: {
                    return new ArrayList<GTreeNode>(nodes);
                }
                case 1: {
                    List<ColorNode> grouped = this.groupSameColors(nodes);
                    return new ArrayList<GTreeNode>(grouped);
                }
                case 2: {
                    bins = 8;
                    List<ColorNode> grouped = this.groupSameColors(nodes);
                    List<ColorNode> binned = this.binColors(grouped, bins);
                    return new ArrayList<GTreeNode>(binned);
                }
                case 3: {
                    bins = 64;
                    List<ColorNode> grouped = this.groupSameColors(nodes);
                    List<ColorNode> binned = this.binColors(grouped, bins);
                    return new ArrayList<GTreeNode>(binned);
                }
                case 4: {
                    bins = 512;
                    List<ColorNode> grouped = this.groupSameColors(nodes);
                    List<ColorNode> binned = this.binColors(grouped, bins);
                    return new ArrayList<GTreeNode>(binned);
                }
            }
            return new ArrayList<GTreeNode>();
        }

        private List<ColorValueNode> organizeByIdRefs(List<ColorValueNode> nodes) {
            ArrayList<ColorValueNode> results = new ArrayList<ColorValueNode>();
            HashMap<String, ColorValueNode> idMap = new HashMap<String, ColorValueNode>();
            for (ColorValueNode node : nodes) {
                idMap.put(node.getId(), node);
            }
            for (ColorValueNode colorNode : nodes) {
                if (colorNode.isIndirect()) {
                    String refId = colorNode.getReferenceId();
                    ColorValueNode parent = (ColorValueNode)idMap.get(refId);
                    if (parent == null) continue;
                    parent.addNode(colorNode);
                    continue;
                }
                results.add(colorNode);
            }
            return results;
        }

        private List<ColorNode> groupSameColors(List<ColorValueNode> nodes) {
            HashMap<Color, ColorNode> colorMap = new HashMap<Color, ColorNode>();
            for (ColorNode colorNode : nodes) {
                Color color = colorNode.getColor();
                ColorNode group = colorMap.computeIfAbsent(color, k -> new SameColorGroupNode(ThemeColorTree.this, (Color)k));
                group.addNode(colorNode);
            }
            return new ArrayList<ColorNode>(colorMap.values());
        }

        private List<ColorNode> binColors(List<ColorNode> nodes, int bins) {
            int shift = this.computeShift(bins);
            HashMap<Color, ColorNode> binnedColorMap = new HashMap<Color, ColorNode>();
            for (ColorNode node : nodes) {
                Color binnedColor = this.binColor(node, shift);
                ColorNode group = binnedColorMap.computeIfAbsent(binnedColor, k -> new ColorNode(ThemeColorTree.this, (Color)k, "Bin "));
                group.addNode(node);
            }
            return new ArrayList<ColorNode>(binnedColorMap.values());
        }

        private int computeShift(int bins) {
            switch (bins) {
                case 8: {
                    return 7;
                }
                case 64: {
                    return 6;
                }
                case 512: {
                    return 5;
                }
            }
            return 7;
        }

        private Color binColor(ColorNode node, int shift) {
            Color color = node.getColor();
            int redValue = color.getRed() >> shift << shift;
            int greenValue = color.getGreen() >> shift << shift;
            int blueValue = color.getBlue() >> shift << shift;
            return new Color(redValue, greenValue, blueValue);
        }

        @Override
        public String getName() {
            return "Colors";
        }

        @Override
        public String getDisplayText() {
            return "Colors (" + this.uniqueColors + " unique colors)";
        }

        @Override
        public Icon getIcon(boolean expanded) {
            return null;
        }

        @Override
        public String getToolTip() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    static enum GroupingStrategy {
        REF("Reference"),
        SAME_COLORS("Same Color"),
        BIN_8("8 Bins"),
        BIN_64("64 Bins"),
        BIN_512("512 Bins");

        private String name;

        private GroupingStrategy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ColorValueNode
    extends ColorNode {
        private ColorValue colorValue;

        public ColorValueNode(ThemeColorTree themeColorTree, ColorValue colorValue) {
            super(themeColorTree, (Color)new GColor(colorValue.getId()), colorValue.getId() + "  ");
            this.colorValue = colorValue;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public boolean isIndirect() {
            return this.colorValue.isIndirect();
        }

        public String getReferenceId() {
            return this.colorValue.getReferenceId();
        }

        public String getId() {
            return this.colorValue.getId();
        }

        @Override
        protected void sortChildren(List<GTreeNode> nodes, ColorSorter sorter) {
            Collections.sort(nodes);
        }
    }

    private class SameColorGroupNode
    extends ColorNode {
        SameColorGroupNode(ThemeColorTree themeColorTree, Color color) {
            super(themeColorTree, color);
        }

        @Override
        protected void sortChildren(List<GTreeNode> nodes, ColorSorter sorter) {
            Collections.sort(nodes);
        }
    }

    private class ColorNode
    extends GTreeNode {
        protected Color color;
        protected Icon icon;
        private String name;
        protected String displayText;

        ColorNode(ThemeColorTree themeColorTree, Color color) {
            this(themeColorTree, color, "");
        }

        ColorNode(ThemeColorTree themeColorTree, Color color, String namePrefix) {
            this.name = namePrefix + this.getColorString(color);
            this.color = color instanceof GColor ? new Color(color.getRGB()) : color;
            this.icon = new SwatchIcon(themeColorTree, color);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDisplayText() {
            if (this.displayText == null) {
                this.displayText = this.name;
                int childCount = this.getChildCount();
                if (childCount > 0) {
                    int leafCount = this.getLeafCount();
                    this.displayText = this.name + "  (" + childCount + ", " + leafCount + ")";
                }
            }
            return this.displayText;
        }

        @Override
        public Icon getIcon(boolean expanded) {
            return this.icon;
        }

        @Override
        public String getToolTip() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Color getColor() {
            return this.color;
        }

        protected String getColorString(Color c) {
            Object colorName = WebColors.toString((Color)c, (boolean)false);
            String webColorName = WebColors.toWebColorName((Color)c);
            if (webColorName != null) {
                colorName = (String)colorName + " (" + webColorName + ")";
            }
            return colorName;
        }

        public void sort(ColorSorter sorter) {
            if (this.getChildCount() == 0) {
                return;
            }
            ArrayList<GTreeNode> children = new ArrayList<GTreeNode>(this.getChildren());
            for (GTreeNode node : children) {
                ((ColorNode)node).sort(sorter);
            }
            this.sortChildren(children, sorter);
            this.setChildren(children);
        }

        protected void sortChildren(List<GTreeNode> nodes, ColorSorter sorter) {
            Collections.sort(nodes, (a, b) -> sorter.compare(((ColorNode)a).getColor(), ((ColorNode)b).getColor()));
        }
    }

    private class SwatchIcon
    implements Icon {
        private Color color;
        private Color border;

        SwatchIcon(ThemeColorTree themeColorTree, Color c) {
            this.color = c;
            this.border = GThemeDefaults.Colors.FOREGROUND;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, 16, 16);
            g.setColor(this.border);
            g.drawRect(x, y, 16, 16);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }
}

