/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.AutoLookup;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.GTable;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableSortState;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.table.TableCellRenderer;

public class GTableAutoLookup
extends AutoLookup {
    private GTable table;

    public GTableAutoLookup(GTable table) {
        this.table = table;
    }

    @Override
    public int getCurrentRow() {
        return this.table.getSelectedRow();
    }

    @Override
    public int getRowCount() {
        return this.table.getRowCount();
    }

    @Override
    public String getValueString(int row, int col) {
        TableCellRenderer renderer = this.table.getCellRenderer(row, col);
        if (renderer instanceof JLabel) {
            this.table.prepareRenderer(renderer, row, col);
            return ((JLabel)((Object)renderer)).getText();
        }
        Object obj = this.table.getValueAt(row, col);
        return obj == null ? null : obj.toString();
    }

    private boolean isSortableTableModel() {
        return this.table.getModel() instanceof SortedTableModel;
    }

    @Override
    public boolean isSorted(int column) {
        if (!this.isSortableTableModel()) {
            return false;
        }
        SortedTableModel sortedModel = (SortedTableModel)this.table.getModel();
        return column == sortedModel.getPrimarySortColumnIndex();
    }

    @Override
    public boolean isSortedAscending() {
        if (!this.isSortableTableModel()) {
            return false;
        }
        SortedTableModel model = (SortedTableModel)this.table.getModel();
        int primarySortColumnIndex = model.getPrimarySortColumnIndex();
        TableSortState columnSortState = model.getTableSortState();
        ColumnSortState sortState = columnSortState.getColumnSortState(primarySortColumnIndex);
        return sortState.isAscending();
    }

    @Override
    public void matchFound(int row) {
        this.table.setRowSelectionInterval(row, row);
        Rectangle rect = this.table.getCellRect(row, 0, false);
        this.table.scrollRectToVisible(rect);
    }
}

