/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import docking.widgets.textfield.TextEntryStatusListener;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.InputVerifier;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GFormattedTextField
extends JFormattedTextField {
    private static final Color ERROR_BACKGROUND_COLOR = new GColor("color.bg.formatted.field.error");
    private static final Color EDITING_BACKGROUND_COLOR = new GColor("color.bg.formatted.field.editing");
    private static final Color EDITING_FOREGROUND_COLOR = new GColor("color.fg.formatted.field.editing");
    private Set<TextEntryStatusListener> listeners = new HashSet<TextEntryStatusListener>();
    private Status currentStatus = Status.UNCHANGED;
    private Object defaultValue;
    private String defaultText;
    private boolean isError;
    private boolean ignoreFocusEditChanges;
    private boolean isProcessingFocusEvent;

    public GFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object defaultValue) {
        super(factory);
        this.setValue(defaultValue);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                GFormattedTextField.this.updateText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GFormattedTextField.this.updateText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GFormattedTextField.this.updateText();
            }
        });
        this.setDefaultValue(defaultValue);
        this.addPropertyChangeListener("value", evt -> this.editingFinished());
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.defaultText = this.getText();
        this.update();
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void disableFocusEventProcessing() {
        this.ignoreFocusEditChanges = true;
    }

    @Override
    public int getFocusLostBehavior() {
        if (this.ignoreFocusEditChanges) {
            return -1;
        }
        return super.getFocusLostBehavior();
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        this.isProcessingFocusEvent = true;
        super.processFocusEvent(e);
        this.isProcessingFocusEvent = false;
    }

    public Status getTextEntryStatus() {
        return this.currentStatus;
    }

    public void addTextEntryStatusListener(TextEntryStatusListener listener) {
        this.listeners.add(listener);
    }

    private void textEntryStatusChanged(Status status) {
        this.currentStatus = status;
        if (this.listeners == null) {
            return;
        }
        for (TextEntryStatusListener listener : this.listeners) {
            listener.statusChanged(this);
        }
    }

    private void updateText() {
        if (this.isProcessingFocusEvent) {
            return;
        }
        InputVerifier verifier = this.getInputVerifier();
        if (verifier != null) {
            this.setIsError(!verifier.verify(this));
        }
        this.update();
    }

    @Override
    public void setText(String t) {
        if (SystemUtilities.isEqual((Object)this.getText(), (Object)t)) {
            return;
        }
        super.setText(t);
        this.update();
    }

    public void setIsError(boolean isError) {
        this.isError = isError;
        this.update();
    }

    public void reset() {
        this.setText(this.defaultText);
        this.update();
    }

    public boolean isChanged() {
        return this.getTextEntryStatus() != Status.UNCHANGED;
    }

    public boolean isInvalid() {
        return this.getTextEntryStatus() == Status.INVALID;
    }

    public void editingFinished() {
        this.update();
    }

    private boolean hasNonDefaultValue() {
        if (this.defaultText == null) {
            return false;
        }
        JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
        if (formatter == null) {
            return this.hasNonDefaultText();
        }
        try {
            Object value = formatter.stringToValue(this.getText());
            if (value == null) {
                return true;
            }
            return !value.equals(this.defaultValue);
        }
        catch (ParseException e) {
            return true;
        }
    }

    private boolean hasNonDefaultText() {
        return !this.getText().equals(this.defaultText);
    }

    private void update() {
        this.updateStatus();
        if (this.isError) {
            this.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
            this.setBackground(ERROR_BACKGROUND_COLOR);
        } else if (this.hasNonDefaultValue()) {
            this.setForeground(EDITING_FOREGROUND_COLOR);
            this.setBackground(EDITING_BACKGROUND_COLOR);
        } else {
            this.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
            this.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        }
        this.textEntryStatusChanged(this.currentStatus);
    }

    private void updateStatus() {
        Status oldStatus = this.currentStatus;
        this.currentStatus = this.isError ? Status.INVALID : (this.hasNonDefaultValue() ? Status.CHANGED : Status.UNCHANGED);
        if (oldStatus != this.currentStatus) {
            this.textEntryStatusChanged(this.currentStatus);
        }
    }

    public static enum Status {
        UNCHANGED,
        CHANGED,
        INVALID;

    }
}

