/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.filter.TextFilter;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.util.FilterTransformer;
import java.util.List;

public class TreeTextFilter
implements GTreeFilter {
    private final TextFilter textFilter;
    private final FilterTransformer<GTreeNode> transformer;

    public TreeTextFilter(TextFilter textFilter, FilterTransformer<GTreeNode> transformer) {
        this.textFilter = textFilter;
        this.transformer = transformer;
    }

    @Override
    public boolean acceptsNode(GTreeNode node) {
        List searchStrings = this.transformer.transform((Object)node);
        int n = searchStrings.size();
        for (int i = 0; i < n; ++i) {
            String text = (String)searchStrings.get(i);
            if (!this.textFilter.matches(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean showFilterMatches() {
        return true;
    }
}

