/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.settings;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.util.BigEndianDataConverter;
import java.math.BigInteger;

public interface NumberSettingsDefinition
extends SettingsDefinition {
    public long getValue(Settings var1);

    public void setValue(Settings var1, long var2);

    public BigInteger getMaxValue();

    public boolean allowNegativeValue();

    public boolean isHexModePreferred();

    @Override
    default public String getValueString(Settings settings) {
        long value = this.getValue(settings);
        if (!this.allowNegativeValue()) {
            byte[] bytes = BigEndianDataConverter.INSTANCE.getBytes(value);
            BigInteger unsignedValue = new BigInteger(1, bytes);
            return "0x" + unsignedValue.toString(16);
        }
        BigInteger signedValue = BigInteger.valueOf(value);
        String sign = "";
        if (signedValue.signum() < 0) {
            sign = "-";
            signedValue = signedValue.negate();
        }
        return sign + "0x" + signedValue.toString(16);
    }

    @Override
    default public boolean hasSameValue(Settings settings1, Settings settings2) {
        return this.getValue(settings1) == this.getValue(settings2);
    }
}

