/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.column;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.util.DateUtils;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;

public class DefaultTimestampRenderer
extends AbstractGColumnRenderer<Date> {
    @Override
    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(data);
        Date value = (Date)data.getValue();
        if (value != null) {
            label.setText(DateUtils.formatDateTimestamp((Date)value));
        }
        return label;
    }

    @Override
    public String getFilterString(Date t, Settings settings) {
        return DateUtils.formatDateTimestamp((Date)t);
    }

    @Override
    public GColumnRenderer.ColumnConstraintFilterMode getColumnConstraintFilterMode() {
        return GColumnRenderer.ColumnConstraintFilterMode.ALLOW_ALL_FILTERS;
    }
}

