/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.GraphComponent;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.VisualGraphPathHighlighter;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import ghidra.util.task.SwingUpdateManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class VisualGraphHoverMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphMousePlugin
implements MouseMotionListener,
MouseListener,
VisualGraphMousePlugin<V, E> {
    private final GraphComponent<V, E, ?> graphComponent;
    private final VisualGraphPathHighlighter<V, E> pathHighlighter;
    private final VisualGraph<V, E> graph;
    private final VisualizationViewer<V, E> sourceViewer;
    private final VisualizationViewer<V, E> otherViewer;
    private SwingUpdateManager mouseHoverUpdater = new SwingUpdateManager(this::updateMouseHovers);
    private MouseEvent lastMouseEvent;
    private V hoveredVertex;

    public VisualGraphHoverMousePlugin(GraphComponent<V, E, ?> graphComponent, VisualizationViewer<V, E> viewer, VisualizationViewer<V, E> otherViewer) {
        super(0);
        this.graphComponent = graphComponent;
        this.pathHighlighter = graphComponent.getPathHighlighter();
        this.graph = graphComponent.getGraph();
        this.sourceViewer = viewer;
        this.otherViewer = otherViewer;
    }

    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiersEx() == this.modifiers;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastMouseEvent = e;
        this.mouseHoverUpdater.update();
    }

    private void updateMouseHovers() {
        if (this.graphComponent.isUninitialized()) {
            return;
        }
        GraphViewer viewer = this.getGraphViewer(this.lastMouseEvent);
        VisualVertex newHoveredVertex = (VisualVertex)GraphViewerUtils.getVertexFromPointInViewSpace(viewer, this.lastMouseEvent.getPoint());
        if (newHoveredVertex == this.hoveredVertex) {
            return;
        }
        this.updateMouseHoversForVertex(viewer, newHoveredVertex);
    }

    private void updateMouseHoversForVertex(GraphViewer<V, E> viewer, V newHoveredVertex) {
        VisualGraphViewUpdater updater = this.getViewUpdater(viewer);
        updater.stopEdgeHoverAnimation();
        this.setHovered(this.hoveredVertex, false);
        this.hoveredVertex = newHoveredVertex;
        this.setHovered(this.hoveredVertex, true);
        this.setupHoverEdgesForVertex(newHoveredVertex);
    }

    private void setHovered(V v, boolean hovered) {
        if (v != null) {
            v.setHovered(hovered);
        }
    }

    private void setupHoverEdgesForVertex(V newHoveredVertex) {
        if (this.graph.getEdgeCount() == 0) {
            return;
        }
        this.pathHighlighter.setHoveredVertex(newHoveredVertex);
        this.repaint();
    }

    private void repaint() {
        this.sourceViewer.repaint();
        this.otherViewer.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        VisualGraphViewUpdater updater = this.getViewUpdater(e);
        updater.stopEdgeHoverAnimation();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return;
        }
        this.lastMouseEvent = e;
        this.updateMouseHovers();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void dispose() {
        this.mouseHoverUpdater.dispose();
    }
}

