/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.popup;

import docking.widgets.PopupWindow;
import ghidra.graph.viewer.popup.PopupSource;
import ghidra.graph.viewer.popup.ToolTipInfo;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;

public class PopupRegulator<V, E> {
    private int popupDelay = 1000;
    private Timer popupTimer;
    private MouseEvent popupMouseEvent;
    private Object nextPopupTarget;
    private Object lastShownPopupTarget;
    private ToolTipInfo<?> currentToolTipInfo;
    private PopupSource<V, E> popupSource;
    private PopupWindow popupWindow;
    private boolean showPopups = true;

    public PopupRegulator(PopupSource<V, E> popupSupplier) {
        this.popupSource = popupSupplier;
        this.popupTimer = new Timer(this.popupDelay, e -> {
            if (this.isPopupShowing()) {
                return;
            }
            this.showPopupForMouseEvent(this.popupMouseEvent);
        });
        this.popupTimer.setRepeats(false);
        popupSupplier.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PopupRegulator.this.hidePopupTooltips();
                PopupRegulator.this.popupTimer.stop();
                PopupRegulator.this.popupMouseEvent = null;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                PopupRegulator.this.popupMouseEvent = e;
                PopupRegulator.this.savePopupTarget(e);
                PopupRegulator.this.popupTimer.restart();
            }
        });
    }

    public boolean isPopupShowing() {
        return this.popupWindow != null && this.popupWindow.isShowing();
    }

    public void setPopupDelay(int delayMs) {
        this.popupTimer.stop();
        this.popupTimer.setDelay(delayMs);
        this.popupTimer.setInitialDelay(delayMs);
        this.popupDelay = delayMs;
    }

    public void setPopupsVisible(boolean visible) {
        this.showPopups = visible;
        if (!this.showPopups) {
            this.hidePopupTooltips();
        }
    }

    private void showPopupForMouseEvent(MouseEvent event) {
        boolean isCustomJavaTooltip;
        if (!this.showPopups) {
            return;
        }
        if (event == null) {
            return;
        }
        Component c = event.getComponent();
        if (!c.isShowing()) {
            return;
        }
        ToolTipInfo<?> toolTipInfo = this.popupSource.getToolTipInfo(event);
        JComponent toolTipComponent = toolTipInfo.getToolTipComponent();
        boolean bl = isCustomJavaTooltip = !(toolTipComponent instanceof JToolTip);
        if (this.lastShownPopupTarget == this.nextPopupTarget && isCustomJavaTooltip) {
            return;
        }
        this.currentToolTipInfo = toolTipInfo;
        this.showTooltip(this.currentToolTipInfo);
    }

    private void popupShown() {
        this.lastShownPopupTarget = this.nextPopupTarget;
        this.currentToolTipInfo.emphasize();
        this.popupSource.repaint();
    }

    private void popupHidden() {
        this.currentToolTipInfo.deEmphasize();
        this.popupSource.repaint();
    }

    private void savePopupTarget(MouseEvent event) {
        this.nextPopupTarget = null;
        V vertex = this.popupSource.getVertex(event);
        if (vertex != null) {
            this.nextPopupTarget = vertex;
        } else {
            E edge = this.popupSource.getEdge(event);
            this.nextPopupTarget = edge;
        }
        if (this.nextPopupTarget == null) {
            this.lastShownPopupTarget = null;
        }
    }

    private void hidePopupTooltips() {
        if (this.popupWindow != null && this.popupWindow.isShowing()) {
            this.popupWindow.hide();
        }
    }

    private void showTooltip(ToolTipInfo<?> info) {
        JComponent tipComponent = info.getToolTipComponent();
        if (tipComponent == null) {
            return;
        }
        MouseEvent event = info.getMouseEvent();
        this.showPopupWindow(event, tipComponent);
    }

    private void showPopupWindow(MouseEvent event, JComponent component) {
        MenuSelectionManager menuManager = MenuSelectionManager.defaultManager();
        if (menuManager.getSelectedPath().length != 0) {
            return;
        }
        Window parentWindow = this.popupSource.getPopupParent();
        this.popupWindow = new PopupWindow(parentWindow, component);
        this.popupWindow.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PopupRegulator.this.popupShown();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                PopupRegulator.this.popupHidden();
            }
        });
        this.popupWindow.showPopup(event);
    }
}

